/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class AvgBaseTimeColumnLabel
extends ColumnLabelAdapter {
    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)this.getContextAttribute(eObj, info), (int)1);
        if (info.showPercentage) {
            return TString.formatAsPercentage((double)(this.comparableDoubleValue(element, null) / info.max));
        }
        return formatter.getDisplayStringFromElement((Object)this.comparableDoubleValue(element, null), element, 1);
    }

    public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)this.getContextAttribute(eObj, info), (int)1);
        return this.createImage(formatter.getDisplayImageByElement((Object)this.comparableDoubleValue(element, null), element, 1));
    }

    protected int getCalls(Object element) {
        if (element instanceof TRCPackage) {
            return ((TRCPackageImpl.TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getCalls();
        }
        if (element instanceof TRCClass) {
            return ((TRCClassImpl.TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getCalls();
        }
        if (element instanceof TRCMethod) {
            return ((TRCMethodImpl.TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getCalls();
        }
        return 0;
    }

    protected double getBaseTime(Object element) {
        if (element instanceof TRCPackage) {
            return ((TRCPackageImpl.TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getBaseTime();
        }
        if (element instanceof TRCClass) {
            return ((TRCClassImpl.TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getBaseTime();
        }
        if (element instanceof TRCMethod) {
            return ((TRCMethodImpl.TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getBaseTime();
        }
        return 0.0;
    }

    public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
        int calls = this.getCalls(element);
        if (calls == 0) {
            calls = 1;
        }
        return new Double(this.getBaseTime(element) / (double)calls);
    }

    protected String getContextAttribute(EObject element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            return "package.avg.base.time";
        }
        if (element instanceof TRCClass) {
            return "class.avg.base.time";
        }
        if (element instanceof TRCMethod) {
            return "method.avg.base.time";
        }
        return null;
    }
}

