/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AbstractNumberColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;

public class BaseTimeColumnLabel
extends AbstractNumberColumnLabel {
    protected Number getValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            return new Double(((TRCPackageImpl.TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getBaseTime());
        }
        if (element instanceof TRCClass) {
            return new Double(((TRCClassImpl.TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getBaseTime());
        }
        if (element instanceof TRCMethod) {
            return new Double(((TRCMethodImpl.TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getBaseTime());
        }
        if (element instanceof TRCFullTraceObject) {
            return new Double(((TRCFullTraceObject)element).getBaseTime());
        }
        return null;
    }

    protected Number getDelta(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            TRCPackageImpl.TRCPackageSnapshot delta = this.packageSnapshot();
            ((TRCPackage)element).computeDelta((IDelta)delta, 3);
            return new Double(delta.getBaseTime());
        }
        if (element instanceof TRCClass) {
            TRCClassImpl.TRCClassSnapshot delta = this.classSnapshot();
            ((TRCClass)element).computeDelta((IDelta)delta, 10);
            return new Double(delta.getBaseTime());
        }
        if (element instanceof TRCMethod) {
            TRCMethodImpl.TRCMethodSnapshot delta = this.methodSnapshot();
            ((TRCMethod)element).computeDelta((IDelta)delta, 9);
            return new Double(delta.getBaseTime());
        }
        return null;
    }

    protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        if (eObj instanceof TRCPackage) {
            return "package.base.time";
        }
        if (eObj instanceof TRCClass) {
            return "class.base.time";
        }
        if (eObj instanceof TRCMethod) {
            return "method.base.time";
        }
        if (eObj instanceof TRCObject) {
            return "object.base.time";
        }
        return null;
    }
}

