/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AbstractNumberColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;

public class CPUTimeColumnLabel
extends AbstractNumberColumnLabel {
    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return "";
        }
        if (element instanceof TRCFullTraceObject && info.isDeltaColumn) {
            return "";
        }
        if (element instanceof TRCFullMethodInvocation && info.isDeltaColumn) {
            return "";
        }
        return super.getDisplayString(element, info);
    }

    protected Number getValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            return new Double(((TRCPackageImpl.TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot()).getTotalCpuTime());
        }
        if (element instanceof TRCClass) {
            return new Double(((TRCClassImpl.TRCClassSnapshot)((TRCClass)element).retrieveSnapshot()).getTotalCpuTime());
        }
        if (element instanceof TRCMethod) {
            return new Double(((TRCMethodImpl.TRCMethodSnapshot)((TRCMethod)element).retrieveSnapshot()).getTotalCpuTime());
        }
        if (element instanceof TRCFullTraceObject) {
            return new Double(this.getTRCFullTraceCPUtime((TRCFullTraceObject)element));
        }
        if (element instanceof TRCFullMethodInvocation) {
            return new Double(((TRCFullMethodInvocation)element).getCpuTime());
        }
        return null;
    }

    protected Number getDelta(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            TRCPackageImpl.TRCPackageSnapshot delta = this.packageSnapshot();
            ((TRCPackage)element).computeDelta((IDelta)delta, 13);
            return new Double(delta.getTotalCpuTime());
        }
        if (element instanceof TRCClass) {
            TRCClassImpl.TRCClassSnapshot delta = this.classSnapshot();
            ((TRCClass)element).computeDelta((IDelta)delta, 20);
            return new Double(delta.getTotalCpuTime());
        }
        if (element instanceof TRCMethod) {
            TRCMethodImpl.TRCMethodSnapshot delta = this.methodSnapshot();
            ((TRCMethod)element).computeDelta((IDelta)delta, 12);
            return new Double(delta.getTotalCpuTime());
        }
        return null;
    }

    private double getTRCFullTraceCPUtime(TRCFullTraceObject fullTraceObject) {
        double totalCPUtime = 0.0;
        for (EObject methodInvo : fullTraceObject.getInvocations()) {
            if (methodInvo instanceof TRCFullMethodInvocation) {
                totalCPUtime += ((TRCFullMethodInvocation)methodInvo).getCpuTime();
                continue;
            }
            if (!(methodInvo instanceof TRCAggregatedMethodInvocation)) continue;
            totalCPUtime += ((TRCAggregatedMethodInvocation)methodInvo).getTotalCpuTime();
        }
        return totalCPUtime;
    }

    protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        if (eObj instanceof TRCPackage) {
            return "package.cpu.time";
        }
        if (eObj instanceof TRCClass) {
            return "class.cpu.time";
        }
        if (eObj instanceof TRCMethod) {
            return "method.cpu.time";
        }
        if (eObj instanceof TRCObject) {
            return "object.cpu.time";
        }
        if (eObj instanceof TRCFullMethodInvocation) {
            return "method.cpu.time";
        }
        return null;
    }
}

