/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.AbstractNumberColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;

public class CollectedInstancesColumnLabel
extends AbstractNumberColumnLabel {
    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return "";
        }
        if (element instanceof TRCFullTraceObject) {
            if (info.isDeltaColumn) {
                return "";
            }
            EObject eObj = ContextUpdaterHelper.getEObject(element);
            IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)ContextUpdaterHelper.getContext(eObj), (String)"object.collected", (int)1);
            return formatter.getDisplayStringFromElement((Object)new Boolean(((TRCFullTraceObject)element).getCollectTime() != 0.0), element, 1);
        }
        return super.getDisplayString(element, info);
    }

    protected Number getValue(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return null;
        }
        if (element instanceof TRCPackage) {
            TRCPackageImpl.TRCPackageSnapshot ps = (TRCPackageImpl.TRCPackageSnapshot)((TRCPackage)element).retrieveSnapshot();
            return new Integer(ps.getCollectedInstances());
        }
        if (element instanceof TRCClass) {
            TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)((TRCClass)element).retrieveSnapshot();
            return new Integer(cs.getCollectedInstances());
        }
        return null;
    }

    protected Number getDelta(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCPackage) {
            TRCPackageImpl.TRCPackageSnapshot delta = this.packageSnapshot();
            ((TRCPackage)element).computeDelta((IDelta)delta, 12);
            return new Integer(delta.getCollectedInstances());
        }
        if (element instanceof TRCClass) {
            TRCClassImpl.TRCClassSnapshot delta = this.classSnapshot();
            ((TRCClass)element).computeDelta((IDelta)delta, 19);
            return new Integer(delta.getCollectedInstances());
        }
        return null;
    }

    protected String getContextAttribute(Object element, ColumnDisplayInfo info) {
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        if (eObj instanceof TRCPackage) {
            return "package.collect.inst";
        }
        if (eObj instanceof TRCClass) {
            return "class.collect.inst";
        }
        if (eObj instanceof TRCClass) {
            return "object.collected";
        }
        return null;
    }
}

