/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ClassNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.MethodNameColumnLabel;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.PackageNameColumnLabel;
import org.eclipse.hyades.trace.views.util.internal.AggregatedInvocation;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class MethodQualifiedNameColumnLabel
extends ColumnLabelAdapter {
    private ClassNameColumnLabel classNameCol = new ClassNameColumnLabel();
    private MethodNameColumnLabel methodNameCol = new MethodNameColumnLabel();
    private PackageNameColumnLabel packageNameCol = new PackageNameColumnLabel();

    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return "";
        }
        if (element instanceof AggregatedInvocation.Item) {
            TRCMethod method = ((AggregatedInvocation.Item)element).getMethod();
            String displayString = this.getDisplyStringFromMap((EObject)method);
            if (displayString == null) {
                TRCPackage pkg = method.getDefiningClass().getPackage();
                String cls = this.classNameCol.getDisplayString(method.getDefiningClass(), null);
                String mtd = this.methodNameCol.getDisplayString(method, info);
                displayString = String.valueOf(cls) + "." + mtd;
                if (!"".equals(pkg.getName())) {
                    displayString = String.valueOf(this.packageNameCol.getDisplayString(pkg, null)) + "." + displayString;
                }
                this.displayStringMap.put(method, displayString);
            }
            return displayString;
        }
        return "";
    }

    public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
        if (element == null) {
            return null;
        }
        if (element instanceof AggregatedInvocation.Item) {
            TRCMethod method = ((AggregatedInvocation.Item)element).getMethod();
            IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext((EObject)method), (String)"method.name", (int)1);
            return this.createImage(formatter.getDisplayImageByElement((Object)method.getName(), (Object)method, 1));
        }
        return null;
    }

    public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
        return null;
    }
}

