/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class NumberReferencesColumnLabel
extends ColumnLabelAdapter {
    protected int getValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCObjectReference) {
            TRCObjectReference ref = (TRCObjectReference)element;
            if (info.showReferTo) {
                int nb = 0;
                Object[] list = ref.getOwner().getRefTarget().toArray();
                int size = list.length;
                int idx = 0;
                while (idx < size) {
                    nb = list[idx] instanceof TRCAggregatedObjectReference ? (nb += ((TRCAggregatedObjectReference)list[idx]).getCount()) : ++nb;
                    ++idx;
                }
                return nb;
            }
            int nb = 0;
            Object[] list = ref.getTarget().getRefOwner().toArray();
            int size = list.length;
            int idx = 0;
            while (idx < size) {
                nb = list[idx] instanceof TRCAggregatedObjectReference ? (nb += ((TRCAggregatedObjectReference)list[idx]).getCount()) : ++nb;
                ++idx;
            }
            return nb;
        }
        return 0;
    }

    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        if (info.showReferTo) {
            if (element instanceof TRCObjectReference) {
                int nb = this.getValue(element, info);
                EObject eObj = ContextUpdaterHelper.getEObject(element);
                IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)"ref.number.to", (int)1);
                return formatter.getDisplayStringFromElement((Object)new Integer(nb), element, 1);
            }
            if (element instanceof TRCHeapObject) {
                TRCHeapObject object = (TRCHeapObject)element;
                int nb = 0;
                int size = object.getRefTarget().size();
                int idx = 0;
                while (idx < size) {
                    nb = object.getRefTarget().get(idx) instanceof TRCAggregatedObjectReference ? (nb += ((TRCAggregatedObjectReference)object.getRefTarget().get(idx)).getCount()) : ++nb;
                    ++idx;
                }
                EObject eObj = ContextUpdaterHelper.getEObject(element);
                IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)"ref.number.to", (int)1);
                return formatter.getDisplayStringFromElement((Object)new Integer(nb), element, 1);
            }
        } else {
            if (element instanceof TRCObjectReference) {
                int nb = this.getValue(element, info);
                EObject eObj = ContextUpdaterHelper.getEObject(element);
                IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)"ref.number.by", (int)1);
                return formatter.getDisplayStringFromElement((Object)new Integer(nb), element, 1);
            }
            if (element instanceof TRCHeapObject) {
                TRCHeapObject object = (TRCHeapObject)element;
                int nb = 0;
                int size = object.getRefOwner().size();
                int idx = 0;
                while (idx < size) {
                    nb = object.getRefOwner().get(idx) instanceof TRCAggregatedObjectReference ? (nb += ((TRCAggregatedObjectReference)object.getRefOwner().get(idx)).getCount()) : ++nb;
                    ++idx;
                }
                EObject eObj = ContextUpdaterHelper.getEObject(element);
                IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)this.getContext(eObj), (String)"ref.number.by", (int)1);
                return formatter.getDisplayStringFromElement((Object)new Integer(nb), element, 1);
            }
        }
        return "";
    }

    public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
        return null;
    }

    public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCHeapObject) {
            return null;
        }
        return new Double(this.getValue(element, info));
    }
}

