/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.util.internal.AggregatedInvocation;
import org.eclipse.swt.graphics.Image;

public class PerThreadPercentColumnLabel
extends ColumnLabelAdapter {
    public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCThread) {
            return new Double(1.0);
        }
        if (element instanceof AggregatedInvocation) {
            return new Double(((AggregatedInvocation)element).getTimePercentPerThread());
        }
        if (element instanceof AggregatedInvocation.Item) {
            return new Double(((AggregatedInvocation.Item)element).getTimePercentPerThread());
        }
        if (element instanceof TRCAggregatedMethodInvocation) {
            TRCAggregatedMethodInvocation el = (TRCAggregatedMethodInvocation)element;
            double parentTime = this.getThreadTime(el.getThread());
            return new Double(parentTime > 0.0 ? el.getCumulativeTime() / parentTime : 0.0);
        }
        if (element instanceof TRCFullMethodInvocation) {
            TRCFullMethodInvocation el = (TRCFullMethodInvocation)element;
            double parentTime = this.getThreadTime(el.getThread());
            double exitTime = el.getEntryTime() > 0.0 ? el.getEntryTime() : el.getProcess().getLastEventTime();
            double selfTime = Math.max(exitTime - el.getEntryTime(), 0.0);
            return new Double(parentTime > 0.0 ? selfTime / parentTime : 0.0);
        }
        return new Double(0.0);
    }

    private double getThreadTime(TRCThread thread) {
        double startTime = thread.getStartTime();
        double stopTime = thread.getStopTime();
        if (stopTime < startTime) {
            stopTime = thread.getProcess().getLastEventTime();
        }
        return Math.max(stopTime - startTime, 0.0);
    }

    public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
        return null;
    }

    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        return PerftraceUtil.formatAsPercentage((double)this.comparableDoubleValue(element, info));
    }
}

