/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal.view.columnlabels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnDisplayInfo;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ColumnLabelAdapter;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;
import org.eclipse.swt.graphics.Image;

public class ReferenceSizeColumnLabel
extends ColumnLabelAdapter {
    private int getValueObjRefClas(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCObjectReference) {
            TRCObjectReference ref = (TRCObjectReference)element;
            if (ref instanceof TRCAggregatedObjectReference) {
                if (info.showReferTo) {
                    return ((TRCAggregatedObjectReference)ref).getOwnerSize();
                }
                return ((TRCAggregatedObjectReference)ref).getTargetSize();
            }
            if (info.showReferTo) {
                return ref.getOwner().getSize();
            }
            return ref.getTarget().getSize();
        }
        if (element instanceof TRCClass) {
            return ((TRCClass)element).getTotalSize() - ((TRCClass)element).getCollectedSize();
        }
        return 0;
    }

    private int getValueHeapObject(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCHeapObject) {
            TRCHeapObject object = (TRCHeapObject)element;
            int size = object.getSize();
            if (size != 0) {
                return size;
            }
            if (info.showReferTo) {
                if (object.getRefTarget().size() > 0 && object.getRefTarget().get(0) instanceof TRCAggregatedObjectReference) {
                    return ((TRCAggregatedObjectReference)object.getRefTarget().get(0)).getTargetSize();
                }
                TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                int instSize = clas.getTotalInstances();
                if (instSize == 0) {
                    instSize = 1;
                }
                return clas.getTotalSize() / instSize;
            }
            if (object.getRefOwner().size() > 0 && object.getRefOwner().get(0) instanceof TRCAggregatedObjectReference) {
                return ((TRCAggregatedObjectReference)object.getRefOwner().get(0)).getOwnerSize();
            }
            TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
            int instSize = clas.getTotalInstances();
            if (instSize == 0) {
                instSize = 1;
            }
            return clas.getTotalSize() / instSize;
        }
        return 0;
    }

    public String getDisplayString(Object element, ColumnDisplayInfo info) {
        EObject eObj = ContextUpdaterHelper.getEObject(element);
        IContextLabelFormatProvider formatter = ContextManager.getContextLabelFormatProvider((String)ContextUpdaterHelper.getContext(eObj), (String)"ref.size", (int)1);
        if (element instanceof TRCObjectReference || element instanceof TRCClass) {
            return formatter.getDisplayStringFromElement((Object)new Integer(this.getValueObjRefClas(element, info)), element, 1);
        }
        if (element instanceof TRCHeapObject) {
            return formatter.getDisplayStringFromElement((Object)new Integer(this.getValueHeapObject(element, info)), element, 1);
        }
        return "";
    }

    public Double comparableDoubleValue(Object element, ColumnDisplayInfo info) {
        if (element instanceof TRCObjectReference || element instanceof TRCClass) {
            return new Double(this.getValueObjRefClas(element, info));
        }
        if (element instanceof TRCHeapObject) {
            return new Double(this.getValueHeapObject(element, info));
        }
        return null;
    }

    public Image getDisplayImage(Object element, ColumnDisplayInfo info) {
        return null;
    }
}

