/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;

public class AggregatedInvocation {
    protected TRCThread _thread;
    protected TRCMethod _method;
    protected AggregatedInvocation _parent;
    protected ArrayList _allInvocations = new ArrayList();
    protected HashMap _nestedCalls;
    protected boolean _running;
    protected double _snapshotTime;
    protected double _minTime = Double.MAX_VALUE;
    protected double _maxTime;
    protected double _sumTime;

    public AggregatedInvocation(TRCFullMethodInvocation call) {
        this._thread = call.getThread();
        this._method = call.getMethod();
        this._snapshotTime = call.getProcess().getLastEventTime();
        this.add(call);
    }

    public AggregatedInvocation(AggregatedInvocation inv, TRCMethod method) {
        this._thread = inv._thread;
        this._method = method;
        this._snapshotTime = inv._snapshotTime;
        this._parent = inv;
    }

    public TRCMethod getMethod() {
        return this._method;
    }

    public TRCThread getThread() {
        return this._thread;
    }

    public List getAllInvocations() {
        return this._allInvocations;
    }

    public AggregatedInvocation getParent() {
        return this._parent;
    }

    public Collection getNestedCalls() {
        if (this._nestedCalls == null) {
            this._nestedCalls = new HashMap();
            this.updateNestedCalls();
        }
        return this._nestedCalls.values();
    }

    public double getSnapshotTime() {
        return this._snapshotTime;
    }

    public double getMaxTime() {
        return this._maxTime;
    }

    public double getMinTime() {
        return !this._allInvocations.isEmpty() ? this._minTime : 0.0;
    }

    public double getAvgTime() {
        return !this._allInvocations.isEmpty() ? this._sumTime / (double)this._allInvocations.size() : 0.0;
    }

    public double getSumTime() {
        return this._sumTime;
    }

    public static Collection getThreadCalls(TRCThread thread) {
        HashMap<TRCMethod, AggregatedInvocation> calls = new HashMap<TRCMethod, AggregatedInvocation>();
        EList invocations = thread.getInitialInvocations();
        for (Object obj : invocations) {
            if (!(obj instanceof TRCFullMethodInvocation)) continue;
            TRCFullMethodInvocation call = (TRCFullMethodInvocation)obj;
            TRCMethod method = call.getMethod();
            AggregatedInvocation inv = (AggregatedInvocation)calls.get(method);
            if (inv == null) {
                inv = new AggregatedInvocation(call);
                calls.put(method, inv);
                continue;
            }
            inv.add(call);
        }
        return calls.values();
    }

    public double getTimePercentPerThread() {
        double time = this.getThreadTime();
        return time > 0.0 ? this.getSumTime() / time : 0.0;
    }

    public double getThreadTime() {
        double start = this._thread.getStartTime();
        double end = this._thread.getStopTime();
        if (end > this._snapshotTime || end <= 0.0) {
            end = this._snapshotTime;
        }
        return Math.max(end - start, 0.0);
    }

    protected void updateNestedCalls() {
        int i = 0;
        while (i < this._allInvocations.size()) {
            TRCFullMethodInvocation inv = ((Item)this._allInvocations.get((int)i))._invocation;
            EList invokes = inv.getInvokes();
            for (Object obj : invokes) {
                if (!(obj instanceof TRCFullMethodInvocation)) continue;
                TRCFullMethodInvocation call = (TRCFullMethodInvocation)obj;
                if (call.getEntryTime() > this._snapshotTime) break;
                TRCMethod method = call.getMethod();
                AggregatedInvocation nestedCall = (AggregatedInvocation)this._nestedCalls.get(method);
                if (nestedCall == null) {
                    nestedCall = new AggregatedInvocation(this, method);
                    this._nestedCalls.put(method, nestedCall);
                }
                nestedCall.add(call);
            }
            ++i;
        }
    }

    protected void add(TRCFullMethodInvocation call) {
        this._allInvocations.add(new Item(call, this));
        double start = call.getEntryTime();
        double end = call.getExitTime();
        if (end <= 0.0 || end > this._snapshotTime) {
            end = this._snapshotTime;
        }
        double time = Math.max(end - start - call.getOverhead(), 0.0);
        this._minTime = Math.min(time, this._minTime);
        this._maxTime = Math.max(time, this._maxTime);
        this._sumTime += time;
    }

    public static class Item {
        protected TRCFullMethodInvocation _invocation;
        protected AggregatedInvocation _parent;

        public Item(TRCFullMethodInvocation invocation, AggregatedInvocation parent) {
            this._invocation = invocation;
            this._parent = parent;
        }

        public Item getInvokedBy() {
            TRCMethodInvocation invokedBy = this._invocation.getInvokedBy();
            return invokedBy instanceof TRCFullMethodInvocation ? new Item((TRCFullMethodInvocation)invokedBy, this._parent) : null;
        }

        public double getTimePercentPerThread() {
            double time = this.getSumTime();
            double threadTime = this._parent.getThreadTime();
            return threadTime > 0.0 ? time / threadTime : 0.0;
        }

        public double getSumTime() {
            double start = this._invocation.getEntryTime();
            double end = this._invocation.getExitTime();
            if (end <= 0.0 || end > this._parent.getSnapshotTime()) {
                end = this._parent.getSnapshotTime();
            }
            return Math.max(end - start - this._invocation.getOverhead(), 0.0);
        }

        public TRCMethod getMethod() {
            return this._invocation.getMethod();
        }

        public TRCFullMethodInvocation getInvocation() {
            return this._invocation;
        }

        public AggregatedInvocation getParent() {
            return this._parent;
        }
    }
}

