/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLabelFormatProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnData {
    public static final int IS_VISIBLE = 1;
    public static final int NONDELETABLE = 2;
    public static final int NONMOVABLE = 4;
    public static final int NONRESIZABLE = 8;
    public static final int SUPPORTS_DELTA = 16;
    public static final int NOT_VISIBLE_CHOOSE_COLUMNS = 32;
    private String _key;
    private int _style = 0;
    private int _width = 20;
    private int _alignment;
    private int _initialPos = 0;
    private String _context = null;

    public ColumnData(String key, int initialPos, int style, int alignment, int width) {
        this.initialize(key, initialPos, style, alignment, width);
    }

    private void initialize(String key, int initialPos, int style, int alignment, int width) {
        this._key = key;
        this._initialPos = initialPos;
        this._style = style;
        this._width = width;
        this._alignment = alignment;
    }

    public static ArrayList<ColumnData> createColumnData(String preferenceKey, String defaultColumns) {
        String preferenceColumns = TraceUIPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
        if (preferenceColumns == null || preferenceColumns.length() == 0) {
            preferenceColumns = defaultColumns;
        }
        return ColumnData.createColumnDataFromString(preferenceColumns);
    }

    public static ArrayList<ColumnData> createColumnDataFromString(String preferenceColumns) {
        ArrayList<ColumnData> columnDataList = new ArrayList<ColumnData>();
        if (preferenceColumns != null && !preferenceColumns.equals("")) {
            int idx = 0;
            while (idx != -1) {
                String columnDataTemplate;
                idx = preferenceColumns.indexOf(",");
                if (idx != -1) {
                    columnDataTemplate = preferenceColumns.substring(0, idx);
                    preferenceColumns = preferenceColumns.substring(idx + 1);
                } else {
                    columnDataTemplate = preferenceColumns;
                }
                ColumnData.addColumnData(columnDataTemplate, columnDataList);
            }
        }
        return columnDataList;
    }

    private static void addColumnData(String columnTemplate, ArrayList<ColumnData> list) {
        String columnName = "";
        int style = 0;
        int width = 0;
        int alignment = 16384;
        int initialPos = 0;
        int idx = columnTemplate.indexOf(":");
        if (idx != -1) {
            columnName = columnTemplate.substring(0, idx);
            columnTemplate = columnTemplate.substring(idx + 1);
        }
        if ((idx = columnTemplate.indexOf(":")) != -1) {
            initialPos = Integer.parseInt(columnTemplate.substring(0, idx));
            columnTemplate = columnTemplate.substring(idx + 1);
        }
        if ((idx = columnTemplate.indexOf(":")) != -1) {
            style = Integer.parseInt(columnTemplate.substring(0, idx));
            columnTemplate = columnTemplate.substring(idx + 1);
        }
        if ((idx = columnTemplate.indexOf(":")) != -1) {
            alignment = columnTemplate.substring(0, idx).equals("left") ? 16384 : 131072;
            columnTemplate = columnTemplate.substring(idx + 1);
        }
        width = Integer.parseInt(columnTemplate);
        list.add(new ColumnData(columnName, initialPos, style, alignment, width));
    }

    public static void setColumns(ArrayList newList, ArrayList currentList, String preferenceKey) {
        currentList.clear();
        currentList.addAll(newList);
        ColumnData.setColumns(currentList, preferenceKey);
    }

    public static void setColumns(ArrayList currentList, String preferenceKey) {
        String columnKey = "";
        String columns = "";
        int i = 0;
        while (i < currentList.size()) {
            ColumnData columnData = (ColumnData)currentList.get(i);
            columnKey = columnData.key();
            int width = columnData.width();
            String alignment = columnData.getAlignment() == 16384 ? "left" : "right";
            columns = String.valueOf(columns) + "," + columnKey + ":" + columnData.getInitalPos() + ":" + columnData.getStyle() + ":" + alignment + ":" + width;
            ++i;
        }
        if (columns.startsWith(",") && columns.length() > 1) {
            columns = columns.substring(1);
        }
        TraceUIPlugin.getDefault().getPreferenceStore().setValue(preferenceKey, columns);
    }

    public void setContext(String context) {
        this._context = context;
    }

    public String name() {
        if (this._context != null) {
            IContextLabelFormatProvider clfp = ContextManager.getContextLabelFormatProvider((String)this._context, (String)this._key, (int)0);
            if (clfp != null) {
                return clfp.getDisplayStringFromElement(null, null, 0);
            }
            return this._key;
        }
        return this._key;
    }

    public String key() {
        return this._key;
    }

    public void key(String key) {
        this._key = key;
    }

    public boolean isNonDeletable() {
        return (this._style & 2) != 0;
    }

    public boolean visible() {
        return (this._style & 1) != 0;
    }

    public boolean visibleChooseColumns() {
        return (this._style & 0x20) == 0;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public int getStyle() {
        return this._style;
    }

    public boolean isResizable() {
        return (this._style & 8) == 0;
    }

    public boolean isMovable() {
        return (this._style & 4) == 0;
    }

    public boolean supportsDelta() {
        return (this._style & 0x10) != 0;
    }

    public int width() {
        return this._width;
    }

    public void width(int width) {
        this._width = width;
    }

    public int getInitalPos() {
        return this._initialPos;
    }

    public class UpdatePair {
        private String attributeId;
        private Object value;

        public UpdatePair(String _attributeId, Object _value) {
            this.attributeId = _attributeId;
            this.value = _value;
        }

        public String attributeId() {
            return this.attributeId;
        }

        public Object value() {
            return this.value;
        }
    }
}

