/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.preferences.internal.GraphColorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SpectrumColorMap {
    private static ArrayList _colors = new ArrayList();
    private static int _position = 0;
    private static HashMap spectrum = new HashMap();
    private static boolean _useOneColor = true;
    private static Color _backgroundColor;
    private static FontData _fontData;
    private static Color _selectionColor;
    private static Color _unknownColor;
    private static Color _classColor;

    static {
        _fontData = GraphColorPreferencePage.getConsoleFontData();
        _selectionColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)TraceUIPlugin.getDefault().getPreferenceStore(), (String)"selection_rgb"));
        _unknownColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)TraceUIPlugin.getDefault().getPreferenceStore(), (String)"unknown_rgb"));
        _classColor = new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)TraceUIPlugin.getDefault().getPreferenceStore(), (String)"classes_rgb"));
    }

    public static Color color(int i) {
        if (_useOneColor) {
            return _classColor;
        }
        int col = Math.abs(i) % 512;
        return SpectrumColorMap.getNextColor(col);
    }

    private static Color getNextColor(int col) {
        String key = String.valueOf(col);
        Object color = spectrum.get(key);
        if (color != null) {
            return (Color)color;
        }
        if (_position < _colors.size()) {
            RGB rgb = (RGB)_colors.get(_position++);
            color = new Color((Device)Display.getDefault(), rgb);
            spectrum.put(key, color);
            return (Color)color;
        }
        int i1 = col % 8 * 32;
        int i2 = col / 8 % 8 * 32;
        int i3 = col / 64 % 8 * 32;
        color = new Color(null, i1, i2, i3);
        spectrum.put(key, color);
        return (Color)color;
    }

    public static Color color(String s) {
        if (s == null) {
            return SpectrumColorMap.color(0);
        }
        if (s.equals("_Unknown")) {
            return _unknownColor;
        }
        return SpectrumColorMap.color(s.hashCode());
    }

    public static void shutdown() {
        Iterator values = spectrum.values().iterator();
        while (values.hasNext()) {
            ((Color)values.next()).dispose();
        }
        if (_backgroundColor != null) {
            _backgroundColor.dispose();
        }
        if (_classColor != null) {
            _classColor.dispose();
        }
        if (_unknownColor != null) {
            _unknownColor.dispose();
        }
        if (_selectionColor != null) {
            _selectionColor.dispose();
        }
    }

    private static void setSelectionColor(RGB rgb) {
        if (_selectionColor != null) {
            _selectionColor.dispose();
        }
        _selectionColor = new Color((Device)Display.getDefault(), rgb);
    }

    private static void setClassColor(RGB rgb) {
        _useOneColor = TraceUIPlugin.getDefault().getPreferenceStore().getString("class_option").equals("class_one_color");
        if (_classColor != null) {
            _classColor.dispose();
        }
        _classColor = new Color((Device)Display.getDefault(), rgb);
    }

    private static void setUnknownColor(RGB rgb) {
        if (_unknownColor != null) {
            _unknownColor.dispose();
        }
        _unknownColor = new Color((Device)Display.getDefault(), rgb);
    }

    private static void setBackgroundColor(RGB rgb) {
        if (_backgroundColor != null) {
            _backgroundColor.dispose();
        }
        _backgroundColor = TraceUIPlugin.getDefault().getPreferenceStore().getString("bg_option").equals("system_default") ? new Color((Device)Display.getDefault(), Display.getDefault().getSystemColor(25).getRGB()) : new Color((Device)Display.getDefault(), rgb);
    }

    public static Color getSelectionColor() {
        return _selectionColor;
    }

    public static Color getBackgroundColor() {
        return _backgroundColor;
    }

    public static FontData getFontData() {
        return _fontData;
    }

    public static void updateColors() {
        SpectrumColorMap.setBackgroundColor(PreferenceConverter.getColor((IPreferenceStore)TraceUIPlugin.getDefault().getPreferenceStore(), (String)"background_rgb"));
        SpectrumColorMap.setSelectionColor(PreferenceConverter.getColor((IPreferenceStore)TraceUIPlugin.getDefault().getPreferenceStore(), (String)"selection_rgb"));
        SpectrumColorMap.setUnknownColor(PreferenceConverter.getColor((IPreferenceStore)TraceUIPlugin.getDefault().getPreferenceStore(), (String)"unknown_rgb"));
        SpectrumColorMap.setClassColor(PreferenceConverter.getColor((IPreferenceStore)TraceUIPlugin.getDefault().getPreferenceStore(), (String)"classes_rgb"));
        _fontData = GraphColorPreferencePage.getConsoleFontData();
        TraceUIPlugin.getDefault().notifyColorChangedEventListener();
    }

    public static Color getColor(RGB rgb) {
        Color color = (Color)spectrum.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            spectrum.put(rgb, color);
        }
        return color;
    }

    public static void startup() {
        _backgroundColor = TraceUIPlugin.getDefault().getPreferenceStore().getString("bg_option").equals("system_default") ? new Color((Device)Display.getDefault(), Display.getDefault().getSystemColor(25).getRGB()) : new Color((Device)Display.getDefault(), PreferenceConverter.getColor((IPreferenceStore)TraceUIPlugin.getDefault().getPreferenceStore(), (String)"background_rgb"));
        _useOneColor = TraceUIPlugin.getDefault().getPreferenceStore().getString("class_option").equals("class_one_color");
        _colors.add(new RGB(127, 127, 191));
        _colors.add(new RGB(63, 63, 127));
        _colors.add(new RGB(127, 127, 63));
        _colors.add(new RGB(191, 159, 191));
        _colors.add(new RGB(95, 63, 159));
        _colors.add(new RGB(159, 63, 159));
        _colors.add(new RGB(159, 127, 159));
        _colors.add(new RGB(255, 127, 159));
        _colors.add(new RGB(223, 191, 159));
        _colors.add(new RGB(223, 63, 127));
        _colors.add(new RGB(127, 95, 127));
        _colors.add(new RGB(191, 95, 127));
        _colors.add(new RGB(255, 127, 127));
        _colors.add(new RGB(191, 159, 127));
        _colors.add(new RGB(95, 63, 95));
        _colors.add(new RGB(223, 63, 159));
        _colors.add(new RGB(127, 63, 95));
        _colors.add(new RGB(191, 127, 95));
        _colors.add(new RGB(223, 191, 95));
        _colors.add(new RGB(127, 63, 63));
        _colors.add(new RGB(255, 63, 63));
        _colors.add(new RGB(223, 127, 63));
        _colors.add(new RGB(95, 191, 63));
        _colors.add(new RGB(159, 223, 63));
        _colors.add(new RGB(63, 223, 95));
        _colors.add(new RGB(63, 159, 95));
        _colors.add(new RGB(127, 255, 95));
        _colors.add(new RGB(63, 127, 127));
        _colors.add(new RGB(95, 223, 127));
        _colors.add(new RGB(159, 223, 127));
        _colors.add(new RGB(63, 159, 159));
        _colors.add(new RGB(95, 191, 159));
        _colors.add(new RGB(159, 223, 223));
        _colors.add(new RGB(63, 191, 191));
        _colors.add(new RGB(95, 159, 191));
        _colors.add(new RGB(127, 191, 191));
        _colors.add(new RGB(191, 191, 95));
        _colors.add(new RGB(63, 63, 191));
    }
}

