/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.TreeColumn;

public class StatisticTableColumnInfo {
    private boolean _isSortColumn = false;
    private boolean _isDeltaColumn = false;
    private ColumnData _columnData;

    public ColumnData getColumnData() {
        return this._columnData;
    }

    public boolean isSortColumn() {
        return this._isSortColumn;
    }

    public boolean isDeltaColumn() {
        return this._isDeltaColumn;
    }

    public void setSortColumn(boolean flag) {
        this._isSortColumn = flag;
    }

    public void setDeltaColumn(boolean flag) {
        this._isDeltaColumn = flag;
    }

    public static StatisticTableColumnInfo getStatisticTableColumnInfo(TreeColumn col) {
        if (col.getData() != null && col.getData() instanceof StatisticTableColumnInfo) {
            return (StatisticTableColumnInfo)col.getData();
        }
        return null;
    }

    private StatisticTableColumnInfo(StatisticView statisticView, ColumnData data) {
        TreeColumn treeColumn = new TreeColumn(statisticView.getTree(), 0x40000 | data.getAlignment());
        treeColumn.setData((Object)this);
        this.initializeTreeColumn(statisticView, treeColumn, data, true);
        TreeViewerColumn tvc = new TreeViewerColumn((TreeViewer)statisticView.getTreeViewer(), treeColumn);
        CellLabelProvider clp = statisticView.getCellLabelProvider(data);
        if (clp != null) {
            tvc.setLabelProvider(clp);
        }
    }

    public StatisticTableColumnInfo(StatisticView statisticView, ColumnData data, boolean deltaColumnsEnabled) {
        TreeColumn treeColumn = new TreeColumn(statisticView.getTree(), 0x40000 | data.getAlignment());
        treeColumn.setData((Object)this);
        this.initializeTreeColumn(statisticView, treeColumn, data, false);
        TreeViewerColumn tvc = new TreeViewerColumn((TreeViewer)statisticView.getTreeViewer(), treeColumn);
        CellLabelProvider clp = statisticView.getCellLabelProvider(data);
        if (clp != null) {
            tvc.setLabelProvider(clp);
        }
        if (deltaColumnsEnabled && data.supportsDelta()) {
            new StatisticTableColumnInfo(statisticView, data);
        }
    }

    private void initializeTreeColumn(StatisticView statisticView, TreeColumn treeColumn, ColumnData data, boolean isDeltaColumn) {
        this._columnData = data;
        this._isDeltaColumn = isDeltaColumn;
        treeColumn.setResizable(data.isResizable());
        if (isDeltaColumn) {
            treeColumn.setText(new StringBuffer(TraceUIMessages._85).append(" : ").append(data.name()).toString());
        } else {
            treeColumn.setText(data.name());
        }
        treeColumn.setWidth(data.width());
        treeColumn.addSelectionListener(statisticView.getSelectionListener());
        treeColumn.addControlListener((ControlListener)statisticView);
    }
}

