/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.ui.internal.util.OpenJavaSource;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JavaOpenSource {
    public static boolean openSource(EObject eObj, boolean showError) {
        if (eObj != null) {
            final String pattern = JavaOpenSource.getPattern(eObj);
            int javaType = JavaOpenSource.getType(eObj);
            final boolean showErrorMessage = showError;
            if (pattern != null && javaType != -1) {
                if (!OpenJavaSource.openSource((String)pattern, (int)javaType, (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (boolean)true)) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (showErrorMessage) {
                                MessageDialog.openInformation((Shell)UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TraceMessages.TRC_MSGT, (String)NLS.bind((String)TraceUIMessages._68, (Object)pattern));
                            }
                        }
                    });
                }
                return true;
            }
        }
        return false;
    }

    private static String getPattern(Object selection) {
        TRCObjectReference obj;
        if (selection == null || selection instanceof TRCPackage) {
            return null;
        }
        if (selection instanceof TRCMethodInvocation) {
            selection = ((TRCMethodInvocation)selection).getMethod();
        }
        if (selection instanceof TRCMethod) {
            TRCMethod trcMethod = (TRCMethod)selection;
            if ((trcMethod.getModifier() & 0x80) != 0) {
                TRCClass clas = trcMethod.getDefiningClass();
                String packName = clas.getPackage().getName();
                if (packName.equals("")) {
                    return new StringBuffer().append(clas.getName()).append(trcMethod.getSignature()).toString();
                }
                return new StringBuffer().append(clas.getPackage().getName()).append(".").append(clas.getName()).append(trcMethod.getSignature()).toString();
            }
            TRCClass clas = trcMethod.getDefiningClass();
            String packName = clas.getPackage().getName();
            if (packName.equals("")) {
                return new StringBuffer().append(clas.getName()).append(".").append(trcMethod.getName()).append(trcMethod.getSignature()).toString();
            }
            return new StringBuffer().append(clas.getPackage().getName()).append(".").append(clas.getName()).append(".").append(trcMethod.getName()).append(trcMethod.getSignature()).toString();
        }
        if (selection instanceof TRCObjectReference) {
            obj = (TRCObjectReference)selection;
            selection = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display") == 0 ? obj.getOwner() : obj.getTarget();
        }
        if (selection instanceof TRCObject) {
            obj = (TRCObject)selection;
            selection = obj.getIsA() == obj.getProcess().getClassClass() ? JavaOpenSource.findClassType((TRCObject)obj) : obj.getIsA();
        }
        if (selection instanceof TRCClass) {
            TRCClass clas = (TRCClass)selection;
            String packName = clas.getPackage().getName();
            if (packName.equals("")) {
                return clas.getName();
            }
            return new StringBuffer().append(clas.getPackage().getName()).append(".").append(clas.getName()).toString();
        }
        return null;
    }

    private static int getType(Object selection) {
        TRCMethod trcMethod;
        if (selection == null || selection instanceof TRCPackage) {
            return -1;
        }
        if (selection instanceof TRCMethodInvocation) {
            selection = ((TRCMethodInvocation)selection).getMethod();
        }
        int javaType = selection instanceof TRCMethod ? (((trcMethod = (TRCMethod)selection).getModifier() & 0x80) != 0 ? 3 : 1) : 0;
        return javaType;
    }

    private static Object findClassType(TRCObject obj) {
        for (TRCPackage aPackage : obj.getProcess().getPackages()) {
            for (TRCClass aClass : aPackage.getClasses()) {
                for (TRCObject aObject : aClass.getClassObjects()) {
                    if (aObject != obj) continue;
                    return aClass;
                }
            }
        }
        return obj.getIsA();
    }
}

