/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.actions.OpenAssociatedTraceViewAction;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.trace.views.internal.TraceUIMessages;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class OpenTraceInteractions
extends OpenAssociatedTraceViewAction
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private final String VIEW_ID = "org.eclipse.hyades.uml2sd.ui.view.SDView";

    public OpenTraceInteractions() {
        super("");
    }

    public OpenTraceInteractions(String label) {
        super(label);
    }

    public OpenTraceInteractions(String label, ImageDescriptor image) {
        super(label, image);
    }

    public boolean isVisibleForType(Object mofObject) {
        return mofObject instanceof TRCProcess;
    }

    public void run() {
        IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage persp = UIPlugin.getActivePage();
            SDView view = (SDView)persp.showView("org.eclipse.hyades.uml2sd.trace.view.TraceSDView");
            LoadersManager.getLoadersManager().createLoader(this.getLoaderClassName(), ((Object)((Object)this)).getClass().getClassLoader(), view);
        }
        catch (Exception e) {
            String msg = TraceUIMessages._153;
            Status err = new Status(2, "org.eclipse.core.resources", 566, e.toString(), null);
            ErrorDialog.openError((Shell)window.getShell(), (String)msg, (String)"", (IStatus)err);
            e.printStackTrace();
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public abstract String getLoaderClassName();

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void init(IViewPart view) {
    }

    public void dispose() {
    }

    public String getViewID() {
        return "org.eclipse.hyades.uml2sd.ui.view.SDView";
    }

    protected boolean checkEObjectCollectionMode(Object obj) {
        if (obj instanceof EObject) {
            return this.checkCollectionMode((EObject)obj);
        }
        if (obj instanceof ProfileDetailItem) {
            return this.checkEObjectCollectionMode(((ProfileDetailItem)obj).getParent());
        }
        return true;
    }

    public boolean isEnabledForObject(Object obj) {
        return this.checkEObjectCollectionMode(obj);
    }

    public boolean checkCollectionMode(EObject object) {
        if (object instanceof TRCMonitor) {
            TRCMonitor m = (TRCMonitor)object;
            if (m.getNodes() == null || m.getNodes().isEmpty()) {
                return false;
            }
            Iterator i = m.getNodes().iterator();
            while (i.hasNext()) {
                if (!this.checkCollectionMode((EObject)i.next())) continue;
                return true;
            }
        } else if (object instanceof TRCNode) {
            TRCNode n = (TRCNode)object;
            if (n.getProcessProxies() == null || n.getProcessProxies().isEmpty()) {
                return false;
            }
            Iterator i = n.getProcessProxies().iterator();
            while (i.hasNext()) {
                if (!this.checkCollectionMode((EObject)i.next())) continue;
                return true;
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy pp = (TRCProcessProxy)object;
            if (pp.getAgentProxies() == null || pp.getAgentProxies().isEmpty()) {
                return false;
            }
            Iterator i = pp.getAgentProxies().iterator();
            while (i.hasNext()) {
                if (!this.checkCollectionMode((EObject)i.next())) continue;
                return true;
            }
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler")) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)object;
            return agentProxy.getCollectionMode() == TRCCollectionMode.EXECUTION_FULL_LITERAL || agentProxy.getCollectionMode() == TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL || agentProxy.getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL || agentProxy.getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL;
        }
        return false;
    }
}

