/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.uml2sd.trace.TraceSDUtil;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;

public class TraceProcesses
extends ArrayList {
    private static final long serialVersionUID = 1L;
    private ArrayList sortedProcesses;

    public TRCFullMethodInvocation consumeMethodInvocation() {
        if (this.sortedProcesses.isEmpty()) {
            return null;
        }
        TraceProcess tp = (TraceProcess)this.sortedProcesses.get(0);
        TRCFullMethodInvocation ret = tp.nextInvocation();
        if (tp.hasNext()) {
            if (this.sortedProcesses.size() > 1 && tp.getCurrentTime() > ((TraceProcess)this.sortedProcesses.get(1)).getCurrentTime()) {
                this.sortedProcesses.remove(tp);
                this.sortProcess(tp);
            }
        } else {
            this.sortedProcesses.remove(tp);
        }
        return ret;
    }

    public double getStartTime() {
        if (this.sortedProcesses.isEmpty()) {
            return 0.0;
        }
        return ((TraceProcess)this.sortedProcesses.get(0)).getStartTime();
    }

    public void init() {
        this.sortedProcesses = new ArrayList();
        for (TraceProcess p : this) {
            p.init();
            this.sortProcess(p);
        }
    }

    private void sortProcess(TraceProcess p) {
        double targetTime = p.getCurrentTime();
        int i = 0;
        while (i < this.sortedProcesses.size()) {
            if (((TraceProcess)this.sortedProcesses.get(i)).getCurrentTime() > targetTime) {
                this.sortedProcesses.add(i, p);
                return;
            }
            ++i;
        }
        this.sortedProcesses.add(p);
    }

    public boolean contains(TRCProcess process) {
        int i = 0;
        while (i < this.size()) {
            TraceProcess p = (TraceProcess)this.get(i);
            if (p.getProcess() == process) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static TraceProcesses getTraceProcesses(EObject eObject, IProgressMonitor monitor) {
        TraceProcesses ret = new TraceProcesses();
        TraceInteractionUtils.searchTRCProcesses(eObject, ret, monitor);
        if (ret.isEmpty()) {
            if (TraceSDUtil.debugLoader) {
                TraceSDUtil.debugUml2SDTraceLoader("No processes to display");
            }
            return null;
        }
        if (TraceSDUtil.debugLoader) {
            TraceSDUtil.debugUml2SDTraceLoader(String.valueOf(ret.size()) + " process(es) to display:");
            int i = 0;
            while (i < ret.size()) {
                TraceSDUtil.debugUml2SDTraceLoader("  " + ((TraceProcess)ret.get(i)).getProcess().getAgent().getAgentProxy().getProcessProxy().getName());
                ++i;
            }
        }
        return ret;
    }
}

