/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.preference;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.security.internal.preference.TableViewerSorter;
import org.eclipse.hyades.security.internal.util.CertificateProperties;
import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.security.internal.util.SecurityUI;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SecurityPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private static final String[] COLUMNS = new String[]{"STRING", "STRING"};
    private TableViewer tableViewer;
    private ArrayList tableElements = new ArrayList();
    private Button btnAdd;
    private Button btnRemove;
    private Button btnRename;
    private Button btnProperties;
    private KeyStore ks;

    public SecurityPreferencePage() {
        this.setPreferenceStore(HyadesUIPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridUtil.createFill());
        composite.setLayout((Layout)new GridLayout());
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new GridLayout());
        folder.setLayoutData((Object)GridUtil.createFill());
        TabItem item = new TabItem(folder, 0);
        item.setText(SecurityMessages._4);
        item.setImage(HyadesUIImages.INSTANCE.getImage("certif_file.gif"));
        item.setControl(this.createSecurityTab((Composite)folder));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Control createSecurityTab(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridUtil.createFill());
        Label label = new Label(composite, 0);
        label.setText(SecurityMessages._15);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.createTableViewer(composite);
        Composite buttons = new Composite(composite, 0);
        data = new GridData(1040);
        buttons.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        buttons.setLayout((Layout)layout);
        this.createButtons(buttons);
        this.initializeValues();
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRename.addSelectionListener((SelectionListener)this);
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnProperties.addSelectionListener((SelectionListener)this);
        return composite;
    }

    private void createTableViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 67588);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = GridUtil.createFill();
        data.heightHint = 50;
        data.widthHint = 100;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[COLUMNS.length];
        TableColumn aliasColumn = new TableColumn(table, 16384);
        aliasColumn.setText(SecurityMessages._1);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        cellEditors[0] = new TextCellEditor((Composite)table);
        TableColumn certificateColumn = new TableColumn(table, 16384);
        certificateColumn.setText(SecurityMessages._2);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(120));
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
        TableViewerSorter.setTableSorter(this.tableViewer, 0, true);
    }

    private void createButtons(Composite parent) {
        this.btnAdd = new Button(parent, 8);
        this.btnAdd.setText(SecurityMessages._9);
        GridData data = GridUtil.createHorizontalFill();
        this.btnAdd.setLayoutData((Object)data);
        this.btnRemove = new Button(parent, 8);
        this.btnRemove.setText(SecurityMessages._10);
        data = GridUtil.createHorizontalFill();
        this.btnRemove.setLayoutData((Object)data);
        this.btnRemove.setEnabled(false);
        Composite space = new Composite(parent, 0);
        data = GridUtil.createHorizontalFill();
        data.verticalSpan = 2;
        space.setLayoutData((Object)data);
        this.btnRename = new Button(parent, 8);
        this.btnRename.setText(SecurityMessages._11);
        data = GridUtil.createHorizontalFill();
        this.btnRename.setLayoutData((Object)data);
        this.btnRename.setEnabled(false);
        this.btnProperties = new Button(parent, 8);
        this.btnProperties.setText(SecurityMessages._16);
        data = GridUtil.createHorizontalFill();
        this.btnProperties.setLayoutData((Object)data);
        this.btnProperties.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent event) {
        boolean sel;
        IStructuredSelection elem;
        if (event.widget == this.btnAdd) {
            AddDialog dlg = new AddDialog(this.getShell());
            dlg.open();
            if (dlg.getReturnCode() == 0) {
                this.tableViewer.refresh();
            }
        } else if (event.widget == this.btnRemove) {
            elem = (IStructuredSelection)this.tableViewer.getSelection();
            if (elem.size() > 0) {
                Iterator i = elem.iterator();
                while (i.hasNext()) {
                    try {
                        MyTableElement current = (MyTableElement)i.next();
                        this.ks.deleteEntry(current.getAlias());
                        this.tableElements.remove(current);
                    }
                    catch (KeyStoreException keyStoreException) {}
                }
                this.tableViewer.refresh();
            }
        } else if (event.widget == this.btnRename) {
            elem = (IStructuredSelection)this.tableViewer.getSelection();
            if (elem.size() == 1) {
                MyTableElement sel2 = (MyTableElement)elem.getFirstElement();
                RenameDialog dlg = new RenameDialog(this.getShell(), sel2.getAlias());
                dlg.open();
                if (dlg.getReturnCode() == 0) {
                    try {
                        KeystoreHelper.addCertificateToKeyStore((KeyStore)this.ks, (Certificate)((Certificate)sel2.getValue()), (String)dlg.getNewAlias());
                        this.ks.deleteEntry(sel2.getAlias());
                        sel2.setAlias(dlg.getNewAlias());
                        this.tableViewer.refresh();
                    }
                    catch (KeyStoreException keyStoreException) {}
                }
            }
        } else if (event.widget == this.btnProperties && (elem = (IStructuredSelection)this.tableViewer.getSelection()).size() == 1) {
            MyTableElement sel3 = (MyTableElement)elem.getFirstElement();
            CertificateProperties dlg = new CertificateProperties(this.getShell());
            dlg.init(sel3.getAlias(), sel3.getValue());
            dlg.open();
        }
        this.btnRename.setEnabled(!(sel = this.tableViewer.getSelection().isEmpty()));
        this.btnRemove.setEnabled(!sel);
        this.btnProperties.setEnabled(!sel);
    }

    public Point computeSize() {
        Point p = super.computeSize();
        return p;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        String storePath = CommonUIPlugin.getKeyStoreLocation();
        String passw = CommonUIPlugin.getDefault().getWorkspaceName();
        try {
            KeystoreHelper.persistKeyStore((KeyStore)this.ks, (String)storePath, (String)passw);
        }
        catch (IOException e) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._54, (Object)storePath), (Throwable)e);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            return false;
        }
        catch (CertificateException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._55, (Object)storePath), (Throwable)exc);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            return false;
        }
        catch (KeyStoreException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._56, (Object)CommonUIPlugin.getKeyStoreLocation()), (Throwable)exc);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            return false;
        }
        catch (NoSuchAlgorithmException exc2) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._47, (Object)CommonUIPlugin.getKeyStoreLocation()), (Throwable)exc2);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._53, (IStatus)err);
            return false;
        }
        return true;
    }

    private void initializeValues() {
        String storePath = CommonUIPlugin.getKeyStoreLocation();
        String passw = CommonUIPlugin.getDefault().getWorkspaceName();
        try {
            this.ks = KeystoreHelper.createKeyStore((String)storePath, (String)passw);
            Enumeration<String> aliases = this.ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = this.ks.getCertificate(alias);
                if (cert != null) {
                    MyTableElement elem = new MyTableElement(alias, SecurityMessages._62);
                    elem.setValue(cert);
                    this.tableElements.add(elem);
                    continue;
                }
                try {
                    Key key = this.ks.getKey(alias, passw.toCharArray());
                    MyTableElement elem = new MyTableElement(alias, SecurityMessages._63);
                    elem.setValue(key);
                    this.tableElements.add(elem);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {}
            }
        }
        catch (IOException e) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._61, (Object)storePath), (Throwable)e);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._59, (IStatus)err);
        }
        catch (CertificateException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._46, (Object)storePath), (Throwable)exc);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._59, (IStatus)err);
        }
        catch (KeyStoreException exc) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._57, (Object)CommonUIPlugin.getKeyStoreLocation()), (Throwable)exc);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._59, (IStatus)err);
        }
        catch (NoSuchProviderException exc2) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, SecurityMessages._58, (Throwable)exc2);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)NLS.bind((String)SecurityMessages._57, (Object)CommonUIPlugin.getKeyStoreLocation()), (IStatus)err);
        }
        catch (NoSuchAlgorithmException exc2) {
            Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._47, (Object)CommonUIPlugin.getKeyStoreLocation()), (Throwable)exc2);
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._59, (IStatus)err);
        }
        this.tableViewer.setInput((Object)this.tableElements);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setText(SecurityMessages._80);
        this.getApplyButton().setText(SecurityMessages._81);
    }

    public class AddDialog
    extends Dialog
    implements Listener {
        private SecurityUI _securityUI;
        private Certificate fCertificate;
        private Shell shell;

        public AddDialog(Shell shell) {
            super(shell);
            this.shell = shell;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(SecurityMessages._12);
            Composite content = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData data = GridUtil.createFill();
            layout.numColumns = 1;
            content.setLayout((Layout)layout);
            content.setLayoutData((Object)data);
            this._securityUI = new SecurityUI(this.shell);
            this._securityUI.createContents(content);
            this._securityUI.registerListener(this);
            return content;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.getButton(0).setEnabled(false);
            return control;
        }

        protected void okPressed() {
            try {
                this.fCertificate = this._securityUI.loadCertificate(SecurityPreferencePage.this.ks);
            }
            catch (FileNotFoundException e) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._45, (Object)this._securityUI.getPath()), (Throwable)e);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._31, (IStatus)err);
                return;
            }
            catch (IOException e) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._61, (Object)CommonUIPlugin.getKeyStoreLocation()), (Throwable)e);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._31, (IStatus)err);
                return;
            }
            catch (CertificateException exc) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._60, (Object)this._securityUI.getPath()), (Throwable)exc);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._31, (IStatus)err);
                return;
            }
            catch (KeyStoreException exc) {
                Status err = new Status(4, "org.eclipse.core.resources", 4, NLS.bind((String)SecurityMessages._49, (Object)CommonUIPlugin.getKeyStoreLocation()), (Throwable)exc);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SecurityMessages._41, (String)SecurityMessages._31, (IStatus)err);
                return;
            }
            MyTableElement elem = new MyTableElement(this._securityUI.getAliasName(), SecurityMessages._62);
            elem.setValue(this.fCertificate);
            SecurityPreferencePage.this.tableElements.add(elem);
            super.okPressed();
        }

        public void handleEvent(Event e) {
            this.getButton(0).setEnabled(this._securityUI.validateDialog());
        }

        public Certificate getCertificate() {
            return this.fCertificate;
        }
    }

    private class MyTableElement {
        private String alias;
        private Object value;

        public MyTableElement(String alias, String value) {
            this.alias = alias;
            this.value = value;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String text) {
            this.alias = text;
        }

        public Object getValue() {
            return this.value;
        }

        public String getType() {
            if (this.value instanceof Certificate) {
                return SecurityMessages._62;
            }
            if (this.value instanceof Key) {
                return SecurityMessages._63;
            }
            return SecurityMessages._64;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    private class PreferenceContentProvider
    implements IStructuredContentProvider {
        private PreferenceContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof ArrayList) {
                return ((ArrayList)element).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PreferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PreferenceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MyTableElement) {
                MyTableElement myTableElement = (MyTableElement)element;
                if (columnIndex == 0) {
                    return myTableElement.getAlias();
                }
                if (columnIndex == 1) {
                    return myTableElement.getType();
                }
            }
            return "";
        }
    }

    public class RenameDialog
    extends Dialog
    implements Listener {
        private Text txtName;
        private String newAlias;
        private String oldAlias;

        public RenameDialog(Shell shell, String oldValue) {
            super(shell);
            this.oldAlias = oldValue;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(SecurityMessages._13);
            Composite content = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData data = GridUtil.createFill();
            data.widthHint = 350;
            layout.numColumns = 2;
            content.setLayout((Layout)layout);
            content.setLayoutData((Object)data);
            Label lblName = new Label(content, 0);
            lblName.setText(SecurityMessages._7);
            this.txtName = new Text(content, 2048);
            this.txtName.setText(this.oldAlias);
            this.txtName.selectAll();
            this.txtName.addListener(24, (Listener)this);
            data = GridUtil.createHorizontalFill();
            data.widthHint = 200;
            this.txtName.setLayoutData((Object)data);
            return content;
        }

        private void validateDialog() {
            if (this.txtName.getText().trim().length() == 0) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        }

        public void handleEvent(Event e) {
            if (e.widget.equals(this.txtName)) {
                this.validateDialog();
            }
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.validateDialog();
            return control;
        }

        public String getNewAlias() {
            return this.newAlias;
        }

        protected void okPressed() {
            this.newAlias = this.txtName.getText();
            super.okPressed();
        }
    }
}

