/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.internal.preference;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerSorter
extends ViewerSorter {
    private static final String ASC_SYMBOL = "^";
    private static final String DESC_SYMBOL = ".";
    private TableViewer tableViewer;
    private int currentColumn;
    private boolean asc;
    private boolean addDirectionSymbol;
    private SelectionListener headerListener;

    public TableViewerSorter(TableViewer tableViewer, int defaultColumn, boolean asc, boolean addDirectionSymbol, boolean addHeaderListener) {
        this.tableViewer = tableViewer;
        this.addDirectionSymbol = addDirectionSymbol;
        this.setSort(defaultColumn, asc);
        tableViewer.setSorter((ViewerSorter)this);
        if (addHeaderListener) {
            this.addColumnHeaderListeners();
        }
    }

    public static void setTableSorter(TableViewer tableViewer, int defaultColumn, boolean asc) {
        new TableViewerSorter(tableViewer, defaultColumn, asc, false, true);
    }

    private void initializeHeaderListener() {
        this.headerListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String text = null;
                if (TableViewerSorter.this.currentColumn >= 0) {
                    TableColumn currentTableColumn = TableViewerSorter.this.tableViewer.getTable().getColumn(TableViewerSorter.this.currentColumn);
                    if (TableViewerSorter.this.addDirectionSymbol && currentTableColumn != null && (text = currentTableColumn.getText()) != null && (text.startsWith(TableViewerSorter.ASC_SYMBOL) || text.startsWith(TableViewerSorter.DESC_SYMBOL))) {
                        text = text.substring(1);
                        currentTableColumn.setText(text);
                    }
                }
                TableColumn tableColumn = (TableColumn)e.widget;
                text = tableColumn.getText();
                int index = TableViewerSorter.this.tableViewer.getTable().indexOf(tableColumn);
                if (index == TableViewerSorter.this.currentColumn) {
                    TableViewerSorter.this.asc = !TableViewerSorter.this.asc;
                } else {
                    TableViewerSorter.this.asc = true;
                    TableViewerSorter.this.currentColumn = index;
                }
                if (TableViewerSorter.this.addDirectionSymbol && text != null) {
                    text = TableViewerSorter.this.asc ? TableViewerSorter.ASC_SYMBOL + text : TableViewerSorter.DESC_SYMBOL + text;
                    tableColumn.setText(text);
                }
                TableViewerSorter.this.tableViewer.getTable().setRedraw(false);
                TableViewerSorter.this.tableViewer.refresh();
                TableViewerSorter.this.tableViewer.getTable().setRedraw(true);
            }
        };
    }

    public void addColumnHeaderListeners() {
        int i = 0;
        int length = this.tableViewer.getTable().getColumnCount();
        while (i < length) {
            TableColumn column = this.tableViewer.getTable().getColumn(i);
            column.removeSelectionListener(this.getHeaderListener());
            column.addSelectionListener(this.getHeaderListener());
            ++i;
        }
    }

    public void setSort(int currentColumn) {
        this.currentColumn = currentColumn;
    }

    public void setSort(int currentColumn, boolean asc) {
        this.setSort(currentColumn);
        this.setSort(asc);
    }

    public void setSort(boolean asc) {
        this.asc = asc;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public SelectionListener getHeaderListener() {
        if (this.headerListener == null) {
            this.initializeHeaderListener();
        }
        return this.headerListener;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (viewer != this.tableViewer) {
            return super.compare(viewer, e1, e2);
        }
        int ret = this.compareAsc(e1, e2);
        return this.asc ? ret : -1 * ret;
    }

    protected int compareAsc(Object e1, Object e2) {
        int defaultRet = super.compare((Viewer)this.tableViewer, e1, e2);
        IBaseLabelProvider o = this.tableViewer.getLabelProvider();
        if (o == null || !(o instanceof ITableLabelProvider)) {
            return defaultRet;
        }
        ITableLabelProvider labelProvider = (ITableLabelProvider)o;
        String value1 = labelProvider.getColumnText(e1, this.currentColumn);
        String value2 = labelProvider.getColumnText(e2, this.currentColumn);
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        return this.compareAsc(value1, value2);
    }

    protected int compareAsc(String value1, String value2) {
        return value1.compareToIgnoreCase(value2);
    }
}

