/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.adapter.HyadesAdapterFactory;
import org.eclipse.hyades.ui.filters.internal.util.ScopeContainer;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.util.ResourceBundleManager;
import org.eclipse.hyades.ui.util.ILogger;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class HyadesUIPlugin
extends AbstractUIPlugin {
    public static final String EP_EDITOR_EXTENSIONS = "editorExtensions";
    public static final String EP_ANALYZER_EXTENSIONS = "analyzerExtensions";
    public static final String EP_TYPE_DESCRIPTIONS = "typeDescriptions";
    public static final String EP_TYPE_VALIDATORS = "typeValidators";
    public static final String EP_SAMPLE_WIZARD = "sampleWizards";
    public static final String PLUGIN_ID = "org.eclipse.hyades.ui";
    private static HyadesUIPlugin instance;
    private ILogger logger;
    private ResourceBundleManager resourceBundleManager;
    private ResourceBundle resourceBundle;
    private static String PREFERENCE_FILTER_SELECTION_KEY;
    private static String PREFERENCE_STRING_SEPARATOR;
    private static String PREFERENCE_STRING_VALUE_SEPARATOR;

    static {
        PREFERENCE_FILTER_SELECTION_KEY = "filters.filterSelection";
        PREFERENCE_STRING_SEPARATOR = "\n";
        PREFERENCE_STRING_VALUE_SEPARATOR = ";";
    }

    public HyadesUIPlugin() {
        instance = this;
    }

    public static HyadesUIPlugin getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        this.resourceBundleManager = new ResourceBundleManager();
        this.resourceBundleManager.add(this.getResourceBundle());
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)HyadesAdapterFactory.INSTANCE, LogicalFolder.class);
        super.start(context);
        this.restoreFilterSelections();
    }

    public void stop(BundleContext context) throws Exception {
        this.storeFilterSelections();
        NavigatorExtensionUtil.disposeAll();
        this.resourceBundleManager.dispose();
        instance = null;
        this.savePluginPreferences();
        this.logger = null;
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)HyadesAdapterFactory.INSTANCE);
        HyadesAdapterFactory.INSTANCE.dispose();
        super.stop(context);
    }

    public static ILogger getLogger() {
        if (HyadesUIPlugin.instance.logger == null) {
            HyadesUIPlugin.instance.logger = new ILogger(){

                public void logError(Throwable throwable) {
                    this.logError(throwable);
                }

                public void logError(String text) {
                    this.logError(text);
                }

                public void logInfo(String text) {
                    this.logInfo(text);
                }
            };
        }
        return HyadesUIPlugin.instance.logger;
    }

    public static String getID() {
        return PLUGIN_ID;
    }

    public static void logError(Throwable throwable) {
        CommonPlugin.logError((Throwable)throwable);
    }

    public static void logError(String text) {
        CommonPlugin.logError((String)text);
    }

    public static void logInfo(String text) {
        CommonPlugin.logInfo((String)text);
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            try {
                this.resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (Exception exception) {
                this.resourceBundle = null;
            }
        }
        return this.resourceBundle;
    }

    public static String getString(String key) {
        try {
            return HyadesUIPlugin.instance.resourceBundleManager.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getString(String key, String arg) {
        try {
            return HyadesUIPlugin.instance.resourceBundleManager.getString(key, arg);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getString(String key, String[] args) {
        try {
            return HyadesUIPlugin.instance.resourceBundleManager.getString(key, args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    private void storeFilterSelections() {
        ScopeContainer scopeContainer = ScopeContainer.instance();
        StringBuffer filterSelectionStr = new StringBuffer();
        String[] scopes = scopeContainer.scopes();
        String selectedFilterName = null;
        int i = 0;
        while (i < scopes.length) {
            selectedFilterName = scopeContainer.getSelectedFilterName(scopes[i]);
            if (selectedFilterName != null) {
                filterSelectionStr.append(scopes[i]);
                filterSelectionStr.append(PREFERENCE_STRING_VALUE_SEPARATOR);
                filterSelectionStr.append(selectedFilterName);
                filterSelectionStr.append(PREFERENCE_STRING_SEPARATOR);
            }
            ++i;
        }
        filterSelectionStr.append(PREFERENCE_STRING_SEPARATOR);
        String[] viewers = scopeContainer.viewers();
        String selectedScope = null;
        int i2 = 0;
        while (i2 < viewers.length) {
            selectedScope = scopeContainer.getSelectedScope(viewers[i2]);
            if (selectedScope != null) {
                filterSelectionStr.append(viewers[i2]);
                filterSelectionStr.append(PREFERENCE_STRING_VALUE_SEPARATOR);
                filterSelectionStr.append(selectedScope);
                filterSelectionStr.append(PREFERENCE_STRING_SEPARATOR);
            }
            ++i2;
        }
        this.getPluginPreferences().setValue(PREFERENCE_FILTER_SELECTION_KEY, filterSelectionStr.toString());
    }

    private void restoreFilterSelections() {
        int sIdx;
        String filterSelectionStr = this.getPluginPreferences().getString(PREFERENCE_FILTER_SELECTION_KEY);
        if (filterSelectionStr == null || "".equals(filterSelectionStr)) {
            return;
        }
        ScopeContainer scopeContainer = ScopeContainer.instance();
        int idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        while (idx > 0) {
            String scopeSelectedFilterStr = filterSelectionStr.substring(0, idx);
            sIdx = scopeSelectedFilterStr.indexOf(PREFERENCE_STRING_VALUE_SEPARATOR);
            String scope = scopeSelectedFilterStr.substring(0, sIdx);
            String selectedFilter = scopeSelectedFilterStr.substring(sIdx + 1);
            scopeContainer.setSelectedFilterName(scope, selectedFilter);
            filterSelectionStr = filterSelectionStr.substring(idx + 1);
            idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        }
        filterSelectionStr = filterSelectionStr.substring(1);
        idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        while (idx >= 0) {
            String viewerSelectedScope = filterSelectionStr.substring(0, idx);
            sIdx = viewerSelectedScope.indexOf(PREFERENCE_STRING_VALUE_SEPARATOR);
            String viewer = viewerSelectedScope.substring(0, sIdx);
            String selectedScope = viewerSelectedScope.substring(sIdx + 1);
            scopeContainer.setSelectedScope(viewer, selectedScope);
            filterSelectionStr = filterSelectionStr.substring(idx + 1);
            idx = filterSelectionStr.indexOf(PREFERENCE_STRING_SEPARATOR);
        }
    }
}

