/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.FileUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.IProjectAdjuster;

public abstract class ZipAdjusterCreationWizard
extends CreationWizard
implements IProjectAdjuster {
    private String encoding = "UTF-8";
    private List pagesToDeleteFile = new ArrayList();
    private Set zipExtensionsToChange = new HashSet();
    private String[] oldPats;
    private String[] newPats;

    public ZipAdjusterCreationWizard() {
        this.setAdjuster(this);
        this.addZipExtensions();
    }

    protected abstract void addZipExtensions();

    public void dispose() {
        this.zipExtensionsToChange.clear();
        this.pagesToDeleteFile.clear();
        this.setAdjuster(null);
        super.dispose();
    }

    public boolean addZipExtension(String zipExtension) {
        return this.zipExtensionsToChange.add(zipExtension);
    }

    public boolean removeZipExtension(String zipExtension) {
        return this.zipExtensionsToChange.remove(zipExtension);
    }

    public void removeAllZipExtensions() {
        this.zipExtensionsToChange.clear();
    }

    public ZipFile adjust(CreationWizardPage[] pages, CreationWizardPage currentPage, ZipFile zipFile) {
        if (!this.needsReplace(pages)) {
            return null;
        }
        this.pagesToDeleteFile.add(currentPage);
        try {
            return this.copyZip(zipFile.getName(), FileUtil.getTempDir() + File.separator + this.getPluginId() + FileUtil.getLastSegment((String)zipFile.getName()), this.oldPats, this.newPats);
        }
        catch (Exception e) {
            this.pagesToDeleteFile.remove((Object)currentPage);
            HyadesUIPlugin.logError(e);
            return null;
        }
    }

    public void finished(CreationWizardPage page, ZipFile zipFile) {
        if (!this.pagesToDeleteFile.contains((Object)page)) {
            return;
        }
        File file = new File(zipFile.getName());
        file.delete();
    }

    public File adjust(CreationWizardPage[] pages, CreationWizardPage currentPage, File file) {
        if (!this.needsReplace(pages)) {
            return null;
        }
        if (file.isDirectory()) {
            File tempDir = new File(FileUtil.getTempDir(), String.valueOf(this.getPluginId()) + file.getName() + "LMAP");
            if (tempDir.exists()) {
                FileUtil.delete((File)tempDir);
            }
            if (this.copyDir(file, tempDir, this.oldPats, this.newPats)) {
                this.pagesToDeleteFile.add(currentPage);
                return tempDir;
            }
            FileUtil.delete((File)tempDir);
        }
        return null;
    }

    public void finished(CreationWizardPage page, File file) {
        if (!this.pagesToDeleteFile.contains((Object)page)) {
            return;
        }
        FileUtil.delete((File)file);
    }

    public ZipFile copyZip(String sourceZip, String targetZip, String[] oldPats, String[] newPats) throws IOException, FileNotFoundException {
        if (oldPats == null) {
            oldPats = new String[]{};
        }
        if (newPats == null) {
            newPats = new String[]{};
        }
        if (oldPats.length != newPats.length) {
            throw new IllegalArgumentException("oldPats.length != newPas.length");
        }
        boolean succeed = false;
        File target = new File(targetZip);
        boolean exists = target.exists();
        if (!exists) {
            target.createNewFile();
        }
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(sourceZip));
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(target));
        try {
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    zipOutputStream.putNextEntry(entry);
                    FileUtil.streamCopy((InputStream)zipInputStream, (OutputStream)zipOutputStream);
                } else {
                    String content;
                    byte[] buffer = null;
                    String newContent = content = FileUtil.readFromInputStream((String)this.encoding, (InputStream)zipInputStream, (boolean)true);
                    int i = 0;
                    while (i < oldPats.length) {
                        newContent = StringUtil.replace((String)newContent, (String)oldPats[i], (String)newPats[i]);
                        ++i;
                    }
                    buffer = StringUtil.encode((String)this.encoding, (String)newContent);
                    if (buffer == null) {
                        buffer = newContent.getBytes();
                    }
                    ZipEntry newEntry = new ZipEntry(entry);
                    newEntry.setCompressedSize(-1L);
                    if (!content.equals(newContent)) {
                        newEntry.setSize(buffer.length);
                        CRC32 checksum = new CRC32();
                        checksum.update(buffer, 0, buffer.length);
                        newEntry.setCrc(checksum.getValue());
                    }
                    zipOutputStream.putNextEntry(newEntry);
                    zipOutputStream.write(buffer);
                }
                zipInputStream.closeEntry();
                zipOutputStream.closeEntry();
            }
            succeed = true;
        }
        catch (Throwable throwable) {
            try {
                zipInputStream.close();
            }
            catch (Exception exception) {}
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            zipInputStream.close();
        }
        catch (Exception exception) {}
        try {
            zipOutputStream.close();
        }
        catch (Exception exception) {}
        if (!succeed && !exists) {
            target.delete();
        }
        return new ZipFile(target);
    }

    private boolean needsReplace(CreationWizardPage[] pages) {
        if (this.oldPats != null) {
            return true;
        }
        ArrayList<CreationWizardPage> pagesWithNewProjectNames = new ArrayList<CreationWizardPage>();
        int i = 0;
        while (i < pages.length) {
            IConfigurationElement[] natures = pages[i].getConfigurationElement().getChildren("nature");
            if (natures != null && natures.length > 0) {
                pagesWithNewProjectNames.add(pages[i]);
            } else if (!pages[i].getProjectName().equals(pages[i].getInitialProjectName())) {
                pagesWithNewProjectNames.add(pages[i]);
            }
            ++i;
        }
        if (pagesWithNewProjectNames.isEmpty()) {
            return false;
        }
        this.oldPats = new String[pagesWithNewProjectNames.size() * 2];
        this.newPats = new String[pagesWithNewProjectNames.size() * 2];
        i = 0;
        int max = pagesWithNewProjectNames.size();
        while (i < max) {
            CreationWizardPage page = (CreationWizardPage)((Object)pagesWithNewProjectNames.get(i));
            this.oldPats[i] = String.valueOf(page.getInitialProjectName()) + "/";
            this.oldPats[i + 1] = String.valueOf(page.getInitialProjectName()) + "\\";
            this.newPats[i] = String.valueOf(page.getProjectName()) + "/";
            this.newPats[i + 1] = String.valueOf(page.getProjectName()) + "\\";
            ++i;
        }
        return true;
    }

    private boolean copyFiles(File source, File target) {
        try {
            if (!target.exists()) {
                target.createNewFile();
            }
            FileInputStream inputStream = null;
            FileOutputStream outputStream = null;
            try {
                inputStream = new FileInputStream(source);
                outputStream = new FileOutputStream(target);
                FileUtil.streamCopy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            HyadesUIPlugin.logError(e);
            return false;
        }
        return true;
    }

    private boolean copyDir(File source, File target, String[] oldPats, String[] newPats) {
        File[] files = source.listFiles();
        if (files == null) {
            return true;
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                File newFile = new File(target, files[i].getName()).getAbsoluteFile();
                if (this.zipExtensionsToChange.contains(FileUtil.getFileExtension((File)files[i]))) {
                    try {
                        this.copyZip(files[i].getAbsolutePath(), newFile.getAbsolutePath(), oldPats, newPats);
                    }
                    catch (Exception e) {
                        HyadesUIPlugin.logError(e);
                    }
                } else if (newFile.getName().equals(".classpath")) {
                    try {
                        String content = FileUtil.readFromFile((String)this.encoding, (File)files[i], (boolean)false);
                        if (content != null) {
                            content = this.replaceClasspathVariables(content);
                            FileUtil.writeToFile((String)this.encoding, (File)newFile, (boolean)false, (String)content);
                        }
                    }
                    catch (IOException e) {
                        HyadesUIPlugin.logError(e);
                    }
                } else if (!this.copyFiles(files[i], newFile)) {
                    return false;
                }
            } else if (files[i].isDirectory() && !"CVS".equals(files[i].getName()) && !this.copyDir(files[i], new File(target, files[i].getName()), oldPats, newPats)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void beforeWorspaceRefresh(CreationWizardPage[] pages) {
    }

    public void afterWorspaceRefresh(CreationWizardPage[] pages) {
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

