/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.services;

import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.automation.server.AbstractService;
import org.eclipse.hyades.execution.core.task.ProgressiveTask;
import org.eclipse.hyades.execution.core.util.MutableObject;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.security.internal.util.ConnectUtil;

public class ConnectorService
extends AbstractService
implements Application {
    private static final long serialVersionUID = 8355004980554497424L;

    public Object execute() {
        Properties properties = this.getProperties();
        String host = properties.getProperty("host");
        String port = properties.getProperty("port");
        String user = properties.getProperty("user");
        String password = properties.getProperty("password");
        Boolean showErrors = (Boolean)properties.get("showErrors");
        MutableObject mutableNode = (MutableObject)properties.get("mutableNode");
        return this.connect(host == null ? "localhost" : host, port == null ? "10002" : port, user, password, showErrors, mutableNode);
    }

    public String getName() {
        return "Agent Controller connector service";
    }

    private IStatus connect(final String host, final String port, final String user, final String password, final boolean showErrors, final MutableObject mutableNode) {
        final MutableObject mutableStatus = new MutableObject();
        ProgressiveTask connector = new ProgressiveTask("Agent Controller Connect", new Runnable(){

            public void run() {
                try {
                    ConnectUtil connectUtil = new ConnectUtil(host, port, user, (Application)ConnectorService.this);
                    int result = connectUtil.connect(password, showErrors);
                    switch (result) {
                        case 0: {
                            mutableStatus.set((Object)new Status(0, ConnectorService.this.getName(), result, "", null));
                            mutableNode.set((Object)connectUtil.getNode());
                            break;
                        }
                        default: {
                            mutableStatus.set((Object)new Status(4, ConnectorService.this.getName(), result, "", null));
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
        }, (IProgressMonitor)new NullProgressMonitor(), 10000);
        connector.execute(ProgressiveTask.Synchronicity.SYNCHRONOUS);
        return (IStatus)mutableStatus.getAndClear();
    }
}

