/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.grapher;

import org.eclipse.hyades.ui.widgets.grapher.GraphCanvas;
import org.eclipse.hyades.ui.widgets.grapher.GraphSource;
import org.eclipse.hyades.ui.widgets.grapher.graphs.LineGraph;
import org.eclipse.hyades.ui.widgets.grapher.sources.TestGraphSource;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderEvent;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class APIExample
implements ZoomSliderListener {
    private LineGraph sinLineGraph;
    private LineGraph cosLineGraph;
    private GraphSource sinGraphSource;
    private GraphSource cosGraphSource;
    private Color redGraphColor;
    private Color blueGraphColor;
    private Composite graphComposite;
    private ZoomSlider ySlider;
    private GraphCanvas canvas;
    private Composite empty;
    private TimeZoomSlider xSlider;

    public static void main(String[] args) throws Exception {
        APIExample grapher = new APIExample();
        grapher.newGraphShell();
    }

    public void setupComposite(Composite parent) throws Exception {
        this.graphComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.graphComposite.setLayout((Layout)gridLayout);
        this.ySlider = new ZoomSlider(this.graphComposite);
        GridData gridData = new GridData(4, 4, false, true);
        this.ySlider.setLayoutData(gridData);
        this.ySlider.addZoomSliderListener(this);
        this.ySlider.configure(0.0, 200.0, 50.0, 150.0, 2.0);
        this.canvas = new GraphCanvas(this.graphComposite, 0);
        gridData = new GridData(4, 4, true, true);
        this.canvas.setLayoutData(gridData);
        this.empty = new Composite(this.graphComposite, 0);
        gridData = new GridData(4, 4, false, false);
        this.empty.setLayoutData((Object)gridData);
        this.xSlider = new TimeZoomSlider(this.graphComposite);
        gridData = new GridData(4, 4, true, false);
        this.xSlider.setDirection(-1);
        this.xSlider.setOrientation(1);
        this.xSlider.setLayoutData(gridData);
        this.xSlider.addZoomSliderListener(this);
        this.xSlider.configure(-10000.0, 10000.0, -200.0, 200.0, 2.0);
    }

    public void createGrapher() {
        this.redGraphColor = new Color((Device)Display.getCurrent(), 255, 0, 0);
        this.blueGraphColor = new Color((Device)Display.getCurrent(), 0, 0, 255);
        this.sinGraphSource = this.createGraphSource(0);
        this.cosGraphSource = this.createGraphSource(1);
        this.sinLineGraph = new LineGraph(0, this.sinGraphSource, this.xSlider, this.ySlider, this.redGraphColor);
        this.cosLineGraph = new LineGraph(0, this.cosGraphSource, this.xSlider, this.ySlider, this.blueGraphColor);
        this.canvas.addGraph(this.sinLineGraph);
        this.canvas.addGraph(this.cosLineGraph);
    }

    public GraphSource createGraphSource(int type) {
        int min = -10000;
        int max = 10000;
        TestGraphSource testGraphSource = new TestGraphSource(min, max, type);
        return testGraphSource;
    }

    public void newGraphShell() throws Exception {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        this.setupComposite((Composite)shell);
        this.createGrapher();
        shell.setText("ZoomSlider and Grapher Example");
        shell.setSize(400, 400);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.sinLineGraph.dispose();
        this.cosLineGraph.dispose();
        this.redGraphColor.dispose();
        this.blueGraphColor.dispose();
        display.dispose();
    }

    public void zoomSliderChanged(ZoomSliderEvent event) {
        this.canvas.redraw();
    }
}

