/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.grapher;

import org.eclipse.hyades.ui.widgets.grapher.Graph;

public class VisiblePointsCache {
    private double[] x_values = new double[this.pointLen];
    private double[] y_values = new double[this.pointLen];
    private boolean[] is_valid = new boolean[this.pointLen];
    private int pointLen = 100;
    private int length = 0;
    private Graph graph;

    public VisiblePointsCache(Graph graph) {
        this.graph = graph;
    }

    public int getLength() {
        return this.length;
    }

    public Graph getGraph() {
        return this.graph;
    }

    private void doubleBuffer() {
        this.pointLen *= 2;
        double[] new_x = new double[this.pointLen];
        double[] new_y = new double[this.pointLen];
        System.arraycopy(this.x_values, 0, new_x, 0, this.length);
        System.arraycopy(this.y_values, 0, new_y, 0, this.length);
        this.x_values = new_x;
        this.y_values = new_y;
        boolean[] new_valid = new boolean[this.pointLen];
        System.arraycopy(this.is_valid, 0, new_valid, 0, this.length);
        this.is_valid = new_valid;
    }

    public double[] getXValues() {
        return this.x_values;
    }

    public double[] getYValues() {
        return this.y_values;
    }

    public boolean[] getValidValues() {
        return this.is_valid;
    }

    public void reset() {
        this.length = 0;
    }

    public void addPoint(double x, double y) {
        this.addPoint(x, y, true);
    }

    public void addPoint(double x, double y, boolean isValid) {
        if (this.length == this.pointLen) {
            this.doubleBuffer();
        }
        this.x_values[this.length] = x;
        this.y_values[this.length] = y;
        this.is_valid[this.length] = isValid;
        ++this.length;
    }
}

