/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.grapher.graphs;

import org.eclipse.hyades.ui.widgets.grapher.BasicGraphSource;
import org.eclipse.hyades.ui.widgets.grapher.EnumerationGraphSource;
import org.eclipse.hyades.ui.widgets.grapher.GraphCanvas;
import org.eclipse.hyades.ui.widgets.grapher.IndicatorSource;
import org.eclipse.hyades.ui.widgets.grapher.TextGraph;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class EnumerationGraph
implements TextGraph {
    private static Color black_color;
    private double xoffset = 0.0;
    private double yoffset = 0.0;
    private double xdelta = 0.0;
    private double ydelta = 0.0;
    private String name;
    private String description;
    private String misc;
    private TimeZoomSlider xslider;
    private ZoomSlider yslider;
    private Color fg_col;
    private int line_width = 1;
    private int line_style = 1;
    private EnumerationGraphSource source;

    public EnumerationGraph(TimeZoomSlider xslider, ZoomSlider yslider, Color col, EnumerationGraphSource source) {
        this.xslider = xslider;
        this.yslider = yslider;
        this.fg_col = col;
        this.source = source;
    }

    public void setIndicatorSource(IndicatorSource isource) {
    }

    public BasicGraphSource getGraphSource() {
        return this.source;
    }

    public double getXMin() {
        return this.source.getMin();
    }

    public double getXMax() {
        return this.source.getMax();
    }

    public double getYMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getYMax() {
        return Double.POSITIVE_INFINITY;
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider slider) {
        this.xslider = slider;
    }

    public void setYSlider(ZoomSlider slider) {
        this.yslider = slider;
    }

    public void setForeground(Color col) {
        this.fg_col = col;
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int w) {
        this.line_width = w;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int swt_line_style) {
        this.line_style = swt_line_style;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void paintGraph(GC gc, int x, int y, int w, int h) {
        this.paintGraph(gc, x, y, w, h, 0);
    }

    public int paintGraph(GC gc, int x, int y, int w, int h, int stroffset) {
        int yoffset = stroffset;
        int fheight = gc.getFontMetrics().getHeight();
        gc.setForeground(this.fg_col);
        gc.setLineWidth(this.line_width);
        gc.setLineStyle(this.line_style);
        Object prev = null;
        int i = x;
        while (i < x + w) {
            double t = this.xslider.pixel2Value(i);
            if (t >= this.source.getMin() && t <= this.source.getMax()) {
                Object str = this.source.getValueAt(t);
                if (str != prev && !str.equals(prev)) {
                    gc.setForeground(this.fg_col);
                    gc.drawLine(i, y, i, y + h);
                    gc.drawString(str.toString(), i + 2, yoffset + y + 1, true);
                    try {
                        gc.setForeground(this.yslider.getDisplay().getSystemColor(2));
                    }
                    catch (Throwable throwable) {
                        if (black_color == null) {
                            black_color = new Color((Device)this.yslider.getDisplay(), 0, 0, 0);
                        }
                        gc.setForeground(black_color);
                    }
                    gc.drawString(str.toString(), i + 1, yoffset + y, true);
                    if ((yoffset += fheight) + fheight > h) {
                        yoffset = 0;
                    }
                }
                prev = str;
            }
            ++i;
        }
        return yoffset;
    }

    public void setStaticScaling(double mult) {
    }

    public double getStaticScaling() {
        return 1.0;
    }

    public int getPlottingType() {
        return 0;
    }

    public void setPlottingType(int type) {
    }

    public void setPlottingPeriod(int type, double value) {
    }

    public int getPlottingPeriodType() {
        return 0;
    }

    public double getPlottingPeriodValue() {
        return 1.0;
    }

    public void setXOffset(double millis) {
        this.xoffset = millis;
    }

    public double getXOffset() {
        return this.xoffset;
    }

    public void setYOffset(double millis) {
        this.yoffset = millis;
    }

    public double getYOffset() {
        return this.yoffset;
    }

    public int getNoDataBehaviour() {
        return 0;
    }

    public void setNoDataBehaviour(int i) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setMisc(String misc) {
        this.misc = misc;
    }

    public String getMisc() {
        return this.misc;
    }

    public void setGraphCanvas(GraphCanvas gc) {
    }

    public GraphCanvas getGraphCanvas() {
        return null;
    }

    public void dispose() {
    }

    public void setXDelta(double millis) {
        this.xdelta = millis;
    }

    public double getXDelta() {
        return this.xdelta;
    }

    public void setYDelta(double millis) {
        this.ydelta = millis;
    }

    public double getYDelta() {
        return this.ydelta;
    }
}

