/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.grapher.sources;

import org.eclipse.hyades.ui.widgets.grapher.GraphSource;

public class TestGraphSource
implements GraphSource {
    public static final int SINE_WAVE = 0;
    public static final int COSINE_WAVE = 1;
    private int type;
    private double min;
    private double max;

    public TestGraphSource(double min, double max, int type) {
        this.min = min;
        this.max = max;
        this.type = type;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getValueMin() {
        return 0.0;
    }

    public double getValueMax() {
        return 100.0;
    }

    public double getValueAt(double x) {
        if (this.type == 0) {
            return 100.0 + 50.0 * Math.sin(Math.toRadians(x));
        }
        if (this.type == 1) {
            return 100.0 + 50.0 * Math.cos(Math.toRadians(x));
        }
        return 0.0;
    }

    public double getAverageBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getSumBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getMaxBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getMinBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getCountBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getStandardDeviationBetween(double x, double x2) {
        return this.getValueAt(x);
    }

    public double getSessionMin() {
        return 0.0;
    }

    public double getSessionMax() {
        return 0.0;
    }
}

