/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.zoomslider;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import java.util.Date;
import org.eclipse.hyades.ui.widgets.zoomslider.TimeZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderTick;

public class TimeZoomSliderTick
extends ZoomSliderTick {
    private int hrs;
    private int mins;
    private int secs;
    private int day;
    private int month;
    private int year;
    private String hrs$;
    private String mins$;
    private String secs$;
    private static Object df_LOCK = new Object();
    private static DateFormat df = DateFormat.getDateInstance();
    private static DateFormat dtf = DateFormat.getDateTimeInstance();
    private static DateFormat tf = DateFormat.getTimeInstance((int)2);
    private static NumberFormat nf = NumberFormat.getInstance();

    static {
        nf.setMinimumIntegerDigits(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWallTitle() {
        double endTime = this.slider.getMaxVisible();
        double startTime = this.slider.getMinVisible();
        Date d = new Date((long)this.sliderValue);
        Object object = df_LOCK;
        synchronized (object) {
            if (endTime - startTime < 8.64E7) {
                return tf.format(d);
            }
            if (endTime - startTime < 4.32E8) {
                return dtf.format(d);
            }
            return df.format(d);
        }
    }

    public TimeZoomSliderTick(ZoomSlider slider, double d) {
        this.slider = slider;
        this.sliderValue = d;
        this.calculateComponents();
        if (((TimeZoomSlider)slider).isWallTime()) {
            this.representation = this.getWallTitle();
        } else {
            this.representation = "";
            if (this.hrs != 0) {
                this.representation = String.valueOf(this.representation) + this.hrs$ + ":";
            }
            if (this.mins != 0 || this.hrs != 0) {
                this.representation = String.valueOf(this.representation) + this.mins$ + ":";
            }
            this.representation = String.valueOf(this.representation) + this.secs$;
        }
        this.sliderPixel = (int)slider.value2Pixel(this.sliderValue);
        this.textVisible = this.isTextVisible();
    }

    private void calculateComponents() {
        long millis = (long)this.sliderValue;
        if (!((TimeZoomSlider)this.slider).isWallTime()) {
            millis = (long)this.sliderValue - (long)this.slider.rawOffset;
        }
        ((TimeZoomSlider)this.slider).getGregorianCalendar().setTime(new Date(millis));
        this.day = ((TimeZoomSlider)this.slider).getGregorianCalendar().get(6);
        this.month = ((TimeZoomSlider)this.slider).getGregorianCalendar().get(2);
        this.year = ((TimeZoomSlider)this.slider).getGregorianCalendar().get(1);
        this.hrs = ((TimeZoomSlider)this.slider).getGregorianCalendar().get(11);
        this.hrs$ = nf.format((long)this.hrs);
        this.mins = ((TimeZoomSlider)this.slider).getGregorianCalendar().get(12);
        this.mins$ = nf.format((long)this.mins);
        this.secs = ((TimeZoomSlider)this.slider).getGregorianCalendar().get(13);
        this.secs$ = nf.format((long)this.secs);
    }

    private boolean isTextVisible(int increment) {
        switch (increment) {
            case 0: {
                return true;
            }
            case 1: {
                return this.secs % 5 == 0;
            }
            case 2: {
                return this.secs % 10 == 0;
            }
            case 5: {
                return this.secs % 15 == 0;
            }
            case 10: {
                return this.secs % 30 == 0;
            }
            case 20: {
                return this.secs % 60 == 0;
            }
            case 30: {
                return this.secs % 60 == 0 && this.mins % 2 == 0;
            }
            case 60: {
                return this.mins % 5 == 0;
            }
            case 120: {
                return this.mins % 10 == 0;
            }
            case 300: {
                return this.mins % 20 == 0;
            }
            case 600: {
                return this.mins % 60 == 0;
            }
            case 1200: {
                return this.mins % 60 == 0 && this.hrs % 2 == 0;
            }
            case 1800: {
                return this.mins % 60 == 0 && this.hrs % 2 == 0;
            }
            case 3600: {
                return this.hrs % 12 == 0;
            }
            case 7200: {
                return this.hrs % 12 == 0;
            }
            case 14400: {
                return this.hrs % 12 == 0;
            }
            case 21600: {
                return this.hrs % 24 == 0;
            }
            case 43200: {
                return this.hrs % 24 == 0;
            }
            case 86400: {
                return this.day % 4 == 0;
            }
        }
        int dayIncrement = increment / 86400;
        if (dayIncrement <= 20) {
            int dayOfYear = this.day / dayIncrement * dayIncrement;
            return dayOfYear % (4 * dayIncrement) == 0;
        }
        if (dayIncrement < 380) {
            int monthIncrement = dayIncrement / 30;
            int monthOfYear = this.month / monthIncrement * monthIncrement;
            return monthOfYear % (2 * monthIncrement) == 0;
        }
        int yearIncrement = dayIncrement / 360;
        int thisYear = this.year / yearIncrement * yearIncrement;
        return (thisYear += thisYear % 2) % (4 * yearIncrement) == 0;
    }

    protected boolean isTextVisible() {
        int inc = (int)((long)this.slider.getIncrement() / 1000L);
        boolean res = this.isTextVisible(inc);
        return res;
    }
}

