/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.zoomslider;

import org.eclipse.hyades.ui.widgets.zoomslider.ZoomControlBar;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ZoomImageBar
extends ZoomControlBar {
    Image barImage;
    Image enabledImage;
    Image disabledImage;
    int imageWidth;
    int imageHeight;

    public ZoomImageBar(ZoomSlider slider, double value, Image enabledImage, Image disabledImage, int size) {
        super(slider, value);
        this.size = size;
        this.enabledImage = enabledImage;
        this.disabledImage = disabledImage;
        this.barImage = enabledImage;
        this.imageWidth = this.barImage.getBounds().width;
        this.imageHeight = this.barImage.getBounds().height;
    }

    public void paint(GC g) {
        this.area = this.getDrawingArea(this.value);
        if (this.image == null) {
            Image tempImage = new Image((Device)this.slider.getDisplay(), this.area.width, this.area.height);
            this.draw3DBox(new GC((Drawable)tempImage), 0, 0, this.area.width, this.area.height, this.color);
            ImageData imageData = tempImage.getImageData();
            tempImage.dispose();
            int i = 0;
            while (i < this.area.width) {
                int j = 0;
                while (j < this.area.height) {
                    imageData.setAlpha(i, j, 180);
                    ++j;
                }
                ++i;
            }
            this.image = new Image((Device)this.slider.getDisplay(), imageData);
        }
        g.drawImage(this.image, this.area.x, this.area.y);
        try {
            g.drawImage(this.barImage, this.area.x + this.area.width / 2 - this.imageWidth / 2, this.area.y + this.area.height / 2 - this.imageHeight / 2);
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.barImage = b ? this.enabledImage : this.disabledImage;
        this.imageWidth = this.barImage.getBounds().width;
        this.imageHeight = this.barImage.getBounds().height;
        this.slider.updateScale();
    }
}

