/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.widgets.zoomslider;

import java.util.Vector;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomIndicator;
import org.eclipse.hyades.ui.widgets.zoomslider.ZoomSlider;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ZoomIndicatorsCollection {
    protected static final int IDEAL_WIDTH = 7;
    protected static final int INDENT = 6;
    protected ZoomSlider slider;
    protected int width = 7;
    private Vector indicators = new Vector();
    private int startPoint;

    public ZoomIndicatorsCollection(ZoomSlider slider) {
        this.slider = slider;
    }

    public void add(ZoomIndicator indicator) {
        if (indicator != null && !this.indicators.contains(indicator)) {
            this.indicators.addElement(indicator);
            this.calculatePositions();
        }
    }

    public void remove(ZoomIndicator indicator) {
        if (indicator != null && this.indicators.contains(indicator)) {
            this.indicators.removeElement(indicator);
            this.calculatePositions();
        }
    }

    public void calculatePositions() {
        if (this.indicators.size() > 0) {
            int base = this.slider.getBounds().width;
            if (this.slider.getOrientation() == 1) {
                base = this.slider.getBounds().height;
            }
            this.width = (base - 12) / this.indicators.size();
            if (this.width > 7) {
                this.width = 7;
            }
            this.startPoint = base / 2 - this.width / 2 * this.indicators.size();
        }
    }

    public void paint(GC g, Image backBuffer) {
        int i = 0;
        while (i < this.indicators.size()) {
            ((ZoomIndicator)this.indicators.elementAt(i)).paint(g, backBuffer, this.startPoint + i * this.width, this.width);
            ++i;
        }
    }

    public Vector getZoomIndicators() {
        return this.indicators;
    }

    public void setXORColors() {
        int i = 0;
        while (i < this.indicators.size()) {
            ((ZoomIndicator)this.indicators.elementAt(i)).setXORColor();
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.indicators.size()) {
            ((ZoomIndicator)this.indicators.elementAt(i)).dispose();
            ++i;
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.indicators.size()) {
            ((ZoomIndicator)this.indicators.elementAt(i)).dispose();
            ++i;
        }
        this.indicators.clear();
    }
}

