/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.ShutdownThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorServer
extends AbstractLifeCycle {
    JMXConnectorServer _connectorServer;

    public ConnectorServer(JMXServiceURL serviceURL, String name) throws Exception {
        this(serviceURL, null, name);
    }

    public ConnectorServer(JMXServiceURL serviceURL, Map<String, ?> environment, String name) throws Exception {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this._connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, environment, mbeanServer);
        mbeanServer.registerMBean(this._connectorServer, new ObjectName(name));
    }

    public void doStart() throws Exception {
        this._connectorServer.start();
        ShutdownThread.register((int)0, (LifeCycle[])new LifeCycle[]{this});
        Log.info((String)"JMX Remote URL: {}", (Object)this._connectorServer.getAddress().toString());
    }

    public void doStop() throws Exception {
        ShutdownThread.deregister((LifeCycle)this);
        this._connectorServer.stop();
    }
}

