/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.util.Map;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogbackInitializer {
    private static boolean isPDEDevelopment() {
        String eclipseCommands = System.getProperty("eclipse.commands");
        return eclipseCommands != null && eclipseCommands.indexOf("-dev") != -1 && (eclipseCommands.indexOf("-dev\n") != -1 || eclipseCommands.indexOf("-dev\r") != -1 || eclipseCommands.indexOf("-dev ") != -1);
    }

    public static void processFilesInResourcesFolder(File jettyHome, Map<String, File> files) {
        File logConf;
        File confFile;
        String logbackConf = System.getProperty("logback.configurationFile");
        if (logbackConf != null && (confFile = new File(logbackConf)).exists()) {
            return;
        }
        File file = logConf = LogbackInitializer.isPDEDevelopment() ? files.get("logback-dev.xml") : null;
        if (logConf == null) {
            logConf = files.get("logback-test.xml");
        }
        if (logConf == null) {
            logConf = files.get("logback.xml");
        }
        if (logConf == null) {
            return;
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            configurator.doConfigure(logConf.getAbsoluteFile().getAbsolutePath());
        }
        catch (JoranException je) {
            je.printStackTrace();
        }
        StatusPrinter.printIfErrorsOccured((Context)lc);
    }
}

