/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.WindowCursor;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class UnpackedObject {
    private static final int BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectLoader parse(byte[] raw, AnyObjectId id) throws IOException {
        WindowCursor wc = new WindowCursor(null);
        try {
            ObjectLoader objectLoader = UnpackedObject.open(new ByteArrayInputStream(raw), null, id, wc);
            Object var5_4 = null;
            wc.release();
            return objectLoader;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            wc.release();
            throw throwable;
        }
    }

    static ObjectLoader open(InputStream in, File path, AnyObjectId id, WindowCursor wc) throws IOException {
        try {
            in = UnpackedObject.buffer(in);
            in.mark(20);
            byte[] hdr = new byte[64];
            IO.readFully(in, hdr, 0, 2);
            if (UnpackedObject.isStandardFormat(hdr)) {
                in.reset();
                Inflater inf = wc.inflater();
                InflaterInputStream zIn = UnpackedObject.inflate(in, inf);
                int avail = UnpackedObject.readSome(zIn, hdr, 0, 64);
                if (avail < 5) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectNoHeader);
                }
                MutableInteger p = new MutableInteger();
                int type = Constants.decodeTypeString(id, hdr, (byte)32, p);
                long size = RawParseUtils.parseLongBase10(hdr, p.value, p);
                if (size < 0L) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectNegativeSize);
                }
                if (hdr[p.value++] != 0) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectGarbageAfterSize);
                }
                if (path == null && Integer.MAX_VALUE < size) {
                    LargeObjectException.ExceedsByteArrayLimit e = new LargeObjectException.ExceedsByteArrayLimit();
                    e.setObjectId(id);
                    throw e;
                }
                if (size < (long)wc.getStreamFileThreshold() || path == null) {
                    byte[] data = new byte[(int)size];
                    int n = avail - p.value;
                    if (n > 0) {
                        System.arraycopy(hdr, p.value, data, 0, n);
                    }
                    IO.readFully(zIn, data, n, data.length - n);
                    UnpackedObject.checkValidEndOfStream(in, inf, id, hdr);
                    return new ObjectLoader.SmallObject(type, data);
                }
                return new LargeObject(type, size, path, id, wc.db);
            }
            UnpackedObject.readSome(in, hdr, 2, 18);
            int c = hdr[0] & 0xFF;
            int type = c >> 4 & 7;
            long size = c & 0xF;
            int shift = 4;
            int p = 1;
            while ((c & 0x80) != 0) {
                c = hdr[p++] & 0xFF;
                size += (long)((c & 0x7F) << shift);
                shift += 7;
            }
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectInvalidType);
                }
            }
            if (path == null && Integer.MAX_VALUE < size) {
                LargeObjectException.ExceedsByteArrayLimit e = new LargeObjectException.ExceedsByteArrayLimit();
                e.setObjectId(id);
                throw e;
            }
            if (size < (long)wc.getStreamFileThreshold() || path == null) {
                in.reset();
                IO.skipFully(in, p);
                Inflater inf = wc.inflater();
                InflaterInputStream zIn = UnpackedObject.inflate(in, inf);
                byte[] data = new byte[(int)size];
                IO.readFully(zIn, data, 0, data.length);
                UnpackedObject.checkValidEndOfStream(in, inf, id, hdr);
                return new ObjectLoader.SmallObject(type, data);
            }
            return new LargeObject(type, size, path, id, wc.db);
        }
        catch (ZipException badStream) {
            throw new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
        }
    }

    static long getSize(InputStream in, AnyObjectId id, WindowCursor wc) throws IOException {
        try {
            in = UnpackedObject.buffer(in);
            in.mark(20);
            byte[] hdr = new byte[64];
            IO.readFully(in, hdr, 0, 2);
            if (UnpackedObject.isStandardFormat(hdr)) {
                in.reset();
                Inflater inf = wc.inflater();
                InflaterInputStream zIn = UnpackedObject.inflate(in, inf);
                int avail = UnpackedObject.readSome(zIn, hdr, 0, 64);
                if (avail < 5) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectNoHeader);
                }
                MutableInteger p = new MutableInteger();
                Constants.decodeTypeString(id, hdr, (byte)32, p);
                long size = RawParseUtils.parseLongBase10(hdr, p.value, p);
                if (size < 0L) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectNegativeSize);
                }
                return size;
            }
            UnpackedObject.readSome(in, hdr, 2, 18);
            int c = hdr[0] & 0xFF;
            long size = c & 0xF;
            int shift = 4;
            int p = 1;
            while ((c & 0x80) != 0) {
                c = hdr[p++] & 0xFF;
                size += (long)((c & 0x7F) << shift);
                shift += 7;
            }
            return size;
        }
        catch (ZipException badStream) {
            throw new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
        }
    }

    private static void checkValidEndOfStream(InputStream in, Inflater inf, AnyObjectId id, byte[] buf) throws IOException, CorruptObjectException {
        while (true) {
            int r;
            try {
                r = inf.inflate(buf);
            }
            catch (DataFormatException e) {
                throw new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
            }
            if (r != 0) {
                throw new CorruptObjectException(id, JGitText.get().corruptObjectIncorrectLength);
            }
            if (inf.finished()) {
                if (inf.getRemaining() == 0 && in.read() == -1) break;
                throw new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
            }
            if (!inf.needsInput()) {
                throw new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
            }
            r = in.read(buf);
            if (r <= 0) {
                throw new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
            }
            inf.setInput(buf, 0, r);
        }
    }

    private static boolean isStandardFormat(byte[] hdr) {
        int fb = hdr[0] & 0xFF;
        return fb == 120 && (fb << 8 | hdr[1] & 0xFF) % 31 == 0;
    }

    private static InputStream inflate(InputStream in, final long size, final ObjectId id) {
        Inflater inf = InflaterCache.get();
        return new InflaterInputStream(in, inf){
            private long remaining;
            {
                super(x0, x1);
                this.remaining = size;
            }

            public int read(byte[] b, int off, int cnt) throws IOException {
                try {
                    int r = super.read(b, off, cnt);
                    if (r > 0) {
                        this.remaining -= (long)r;
                    }
                    return r;
                }
                catch (ZipException badStream) {
                    throw new CorruptObjectException(id, JGitText.get().corruptObjectBadStream);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    if (this.remaining <= 0L) {
                        UnpackedObject.checkValidEndOfStream(this.in, this.inf, id, new byte[64]);
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    InflaterCache.release(this.inf);
                    super.close();
                    throw throwable;
                }
                InflaterCache.release(this.inf);
                super.close();
            }
        };
    }

    private static InflaterInputStream inflate(InputStream in, Inflater inf) {
        return new InflaterInputStream(in, inf, 8192);
    }

    private static BufferedInputStream buffer(InputStream in) {
        return new BufferedInputStream(in, 8192);
    }

    private static int readSome(InputStream in, byte[] hdr, int off, int cnt) throws IOException {
        int n;
        int avail = 0;
        while (0 < cnt && (n = in.read(hdr, off, cnt)) >= 0) {
            avail += n;
            cnt -= n;
        }
        return avail;
    }

    private static final class LargeObject
    extends ObjectLoader {
        private final int type;
        private final long size;
        private final File path;
        private final ObjectId id;
        private final FileObjectDatabase source;

        private LargeObject(int type, long size, File path, AnyObjectId id, FileObjectDatabase db) {
            this.type = type;
            this.size = size;
            this.path = path;
            this.id = id.copy();
            this.source = db;
        }

        public int getType() {
            return this.type;
        }

        public long getSize() {
            return this.size;
        }

        public boolean isLarge() {
            return true;
        }

        public byte[] getCachedBytes() throws LargeObjectException {
            throw new LargeObjectException(this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectStream openStream() throws MissingObjectException, IOException {
            ObjectStream.Filter filter;
            block8: {
                BufferedInputStream in;
                try {
                    in = UnpackedObject.buffer(new FileInputStream(this.path));
                }
                catch (FileNotFoundException gone) {
                    return this.source.open(this.id, this.type).openStream();
                }
                boolean ok = false;
                try {
                    byte[] hdr = new byte[64];
                    ((InputStream)in).mark(20);
                    IO.readFully(in, hdr, 0, 2);
                    if (UnpackedObject.isStandardFormat(hdr)) {
                        ((InputStream)in).reset();
                        in = UnpackedObject.buffer(UnpackedObject.inflate(in, this.size, this.id));
                        while (0 < ((InputStream)in).read()) {
                        }
                    } else {
                        UnpackedObject.readSome(in, hdr, 2, 18);
                        int c = hdr[0] & 0xFF;
                        int p = 1;
                        while ((c & 0x80) != 0) {
                            c = hdr[p++] & 0xFF;
                        }
                        ((InputStream)in).reset();
                        IO.skipFully(in, p);
                        in = UnpackedObject.buffer(UnpackedObject.inflate(in, this.size, this.id));
                    }
                    ok = true;
                    filter = new ObjectStream.Filter(this.type, this.size, in);
                    Object var7_8 = null;
                    if (ok) break block8;
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var7_9 = null;
                        if (ok) break block9;
                        ((InputStream)in).close();
                    }
                    throw throwable;
                }
                ((InputStream)in).close();
            }
            return filter;
        }
    }
}

