/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmConverter;
import org.eclipse.jpt.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.core.context.orm.OrmGeneratorContainer;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.jpa2.context.IdMapping2_0;
import org.eclipse.jpt.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.core.resource.orm.Attributes;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlConvertibleMapping;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.core.resource.orm.XmlGeneratorContainer;
import org.eclipse.jpt.core.resource.orm.XmlId;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmIdMapping<T extends XmlId>
extends AbstractOrmAttributeMapping<T>
implements OrmIdMapping,
IdMapping2_0 {
    protected final OrmColumn column = this.getXmlContextNodeFactory().buildOrmColumn(this, this);
    protected boolean mappedByRelationship;
    protected OrmGeneratedValue generatedValue;
    protected OrmConverter converter;
    protected final OrmConverter nullConverter;
    protected final OrmGeneratorContainer generatorContainer;

    protected AbstractOrmIdMapping(OrmPersistentAttribute parent, T resourceMapping) {
        super(parent, resourceMapping);
        this.column.initialize(((XmlId)this.resourceAttributeMapping).getColumn());
        this.mappedByRelationship = this.calculateMappedByRelationship();
        this.generatorContainer = this.buildGeneratorContainer();
        this.initializeGeneratedValue();
        this.nullConverter = this.getXmlContextNodeFactory().buildOrmNullConverter(this);
        this.converter = this.buildConverter(this.getResourceConverterType());
    }

    protected OrmGeneratorContainer buildGeneratorContainer() {
        return this.getXmlContextNodeFactory().buildOrmGeneratorContainer(this, (XmlGeneratorContainer)((Object)this.resourceAttributeMapping));
    }

    @Override
    public String getKey() {
        return "id";
    }

    @Override
    public int getXmlSequence() {
        return 0;
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmIdMapping(this);
    }

    @Override
    public void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromOrmColumnMapping(oldMapping);
        this.getColumn().initializeFrom(oldMapping.getColumn());
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public OrmConverter getConverter() {
        return this.converter;
    }

    protected String getConverterType() {
        return this.converter.getType();
    }

    @Override
    public void setConverter(String converterType) {
        if (this.valuesAreEqual(this.getConverterType(), converterType)) {
            return;
        }
        OrmConverter oldConverter = this.converter;
        OrmConverter newConverter = this.buildConverter(converterType);
        this.converter = this.nullConverter;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.converter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void setConverter(OrmConverter newConverter) {
        OrmConverter oldConverter = this.converter;
        this.converter = newConverter;
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    @Override
    public OrmGeneratedValue addGeneratedValue() {
        if (this.getGeneratedValue() != null) {
            throw new IllegalStateException("gemeratedValue already exists");
        }
        XmlGeneratedValue resourceGeneratedValue = OrmFactory.eINSTANCE.createXmlGeneratedValue();
        this.generatedValue = this.buildGeneratedValue(resourceGeneratedValue);
        ((XmlId)this.resourceAttributeMapping).setGeneratedValue(resourceGeneratedValue);
        this.firePropertyChanged("generatedValue", null, this.generatedValue);
        return this.generatedValue;
    }

    @Override
    public void removeGeneratedValue() {
        if (this.getGeneratedValue() == null) {
            throw new IllegalStateException("gemeratedValue does not exist, cannot be removed");
        }
        OrmGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = null;
        ((XmlId)this.resourceAttributeMapping).setGeneratedValue(null);
        this.firePropertyChanged("generatedValue", oldGeneratedValue, null);
    }

    @Override
    public OrmGeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    protected void setGeneratedValue(OrmGeneratedValue newGeneratedValue) {
        OrmGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = newGeneratedValue;
        this.firePropertyChanged("generatedValue", oldGeneratedValue, newGeneratedValue);
    }

    @Override
    public OrmGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getColumn().getName();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public void addToResourceModel(Attributes resourceAttributes) {
        resourceAttributes.getIds().add((Object)((XmlId)this.resourceAttributeMapping));
    }

    @Override
    public void removeFromResourceModel(Attributes resourceAttributes) {
        resourceAttributes.getIds().remove((Object)this.resourceAttributeMapping);
    }

    @Override
    public XmlColumn getResourceColumn() {
        return ((XmlId)this.resourceAttributeMapping).getColumn();
    }

    protected boolean isColumnSpecified() {
        if (!this.isVirtual()) {
            return this.getResourceColumn() != null;
        }
        return this.getJavaResourcePersistentAttribute().getAnnotation("javax.persistence.Column") != null;
    }

    @Override
    public void addResourceColumn() {
        ((XmlId)this.resourceAttributeMapping).setColumn(OrmFactory.eINSTANCE.createXmlColumn());
    }

    @Override
    public void removeResourceColumn() {
        ((XmlId)this.resourceAttributeMapping).setColumn(null);
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public String getDefaultColumnName() {
        return this.isMappedByRelationship() && !this.isColumnSpecified() ? null : this.getName();
    }

    @Override
    public String getDefaultTableName() {
        return this.isMappedByRelationship() && !this.isColumnSpecified() ? null : this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterator<String> candidateTableNames() {
        return this.getTypeMapping().associatedTableNamesIncludingInherited();
    }

    @Override
    public boolean isMappedByRelationship() {
        return this.mappedByRelationship;
    }

    protected void setMappedByRelationship(boolean newValue) {
        boolean oldValue = this.mappedByRelationship;
        this.mappedByRelationship = newValue;
        this.firePropertyChanged("mappedByRelationship", oldValue, newValue);
    }

    protected boolean calculateMappedByRelationship() {
        for (SingleRelationshipMapping2_0 each : this.getMapsIdRelationships()) {
            if (each.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getResolvedAttributeMappingValue() != this) continue;
            return true;
        }
        return false;
    }

    protected Iterable<SingleRelationshipMapping2_0> getMapsIdRelationships() {
        return new FilteringIterable<SingleRelationshipMapping2_0>((Iterable)new SubIterableWrapper((Iterable)new CompositeIterable(new Iterable[]{this.getTypeMapping().getAllAttributeMappings("oneToOne"), this.getTypeMapping().getAllAttributeMappings("manyToOne")}))){

            protected boolean accept(SingleRelationshipMapping2_0 o) {
                return o.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy();
            }
        };
    }

    protected void initializeGeneratedValue() {
        if (((XmlId)this.resourceAttributeMapping).getGeneratedValue() != null) {
            this.generatedValue = this.buildGeneratedValue(((XmlId)this.resourceAttributeMapping).getGeneratedValue());
        }
    }

    protected OrmGeneratedValue buildGeneratedValue(XmlGeneratedValue resourceGeneratedValue) {
        return this.getXmlContextNodeFactory().buildOrmGeneratedValue(this, resourceGeneratedValue);
    }

    @Override
    public void update() {
        super.update();
        this.column.update(this.getResourceColumn());
        this.setMappedByRelationship(this.calculateMappedByRelationship());
        this.generatorContainer.update();
        this.updateGeneratedValue();
        if (this.valuesAreEqual(this.getResourceConverterType(), this.getConverterType())) {
            this.getConverter().update();
        } else {
            this.setConverter(this.buildConverter(this.getResourceConverterType()));
        }
    }

    protected void updateGeneratedValue() {
        if (((XmlId)this.resourceAttributeMapping).getGeneratedValue() == null) {
            if (this.getGeneratedValue() != null) {
                this.setGeneratedValue(null);
            }
        } else if (this.getGeneratedValue() == null) {
            this.setGeneratedValue(this.buildGeneratedValue(((XmlId)this.resourceAttributeMapping).getGeneratedValue()));
        } else {
            this.getGeneratedValue().update(((XmlId)this.resourceAttributeMapping).getGeneratedValue());
        }
    }

    protected OrmConverter buildConverter(String converterType) {
        if (this.valuesAreEqual(converterType, "noConverter")) {
            return this.nullConverter;
        }
        if (this.valuesAreEqual(converterType, "temporalConverter")) {
            return this.getXmlContextNodeFactory().buildOrmTemporalConverter(this, (XmlConvertibleMapping)((Object)this.resourceAttributeMapping));
        }
        return null;
    }

    protected String getResourceConverterType() {
        if (((XmlId)this.resourceAttributeMapping).getTemporal() != null) {
            return "temporalConverter";
        }
        return "noConverter";
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.isColumnSpecified() || !this.isMappedByRelationship()) {
            this.getColumn().validate(messages, reporter);
        }
        if (this.isColumnSpecified() && this.isMappedByRelationship()) {
            messages.add(this.buildMessage("ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_COLUMN_SPECIFIED", new String[0], this.getColumn().getValidationTextRange()));
        }
        if (this.generatedValue != null) {
            this.generatedValue.validate(messages, reporter);
        }
        this.generatorContainer.validate(messages, reporter);
    }

    @Override
    public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
        if (this.isVirtual()) {
            return this.buildVirtualUnresolvedNameMessage(column, textRange);
        }
        return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
    }

    protected IMessage buildVirtualUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), column.getName(), column.getDbTable().getName()}, column, textRange);
    }

    @Override
    public IMessage buildTableNotValidMessage(BaseColumn column, TextRange textRange) {
        if (this.isVirtual()) {
            return this.buildVirtualTableNotValidMessage(column, textRange);
        }
        return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
    }

    public IMessage buildVirtualTableNotValidMessage(BaseColumn column, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_TABLE_NOT_VALID", new String[]{this.getName(), column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
    }

    protected IMessage buildMessage(String msgID, String[] params, TextRange textRange) {
        OrmPersistentAttribute attribute = this.getPersistentAttribute();
        String attributeDescString = attribute.isVirtual() ? NLS.bind((String)JpaValidationDescriptionMessages.VIRTUAL_ATTRIBUTE_DESC, (Object)attribute.getName()) : NLS.bind((String)JpaValidationDescriptionMessages.ATTRIBUTE_DESC, (Object)attribute.getName());
        return DefaultJpaValidationMessages.buildMessage(1, msgID, (String[])ArrayTools.add((Object[])params, (int)0, (Object)attributeDescString), this, textRange);
    }
}

