/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkConversionValue;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkObjectTypeConverterAnnotation;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkObjectTypeConverter
extends JavaEclipseLinkConverter
implements EclipseLinkObjectTypeConverter {
    private String dataType;
    private String fullyQualifiedDataType;
    public static final String FULLY_QUALIFIED_DATA_TYPE_PROPERTY = "fullyQualifiedDataType";
    private String objectType;
    private String fullyQualifiedObjectType;
    public static final String FULLY_QUALIFIED_OBJECT_TYPE_PROPERTY = "fullyQualifiedObjectType";
    private String defaultObjectValue;
    private final List<JavaEclipseLinkConversionValue> conversionValues = new ArrayList<JavaEclipseLinkConversionValue>();

    public JavaEclipseLinkObjectTypeConverter(JavaJpaContextNode parent) {
        super(parent);
    }

    @Override
    public String getType() {
        return "objectTypeConverter";
    }

    @Override
    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ObjectTypeConverter";
    }

    @Override
    protected EclipseLinkObjectTypeConverterAnnotation getAnnotation() {
        return (EclipseLinkObjectTypeConverterAnnotation)super.getAnnotation();
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        this.getAnnotation().setDataType(newDataType);
        this.firePropertyChanged("dataType", oldDataType, newDataType);
    }

    protected void setDataType_(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        this.firePropertyChanged("dataType", oldDataType, newDataType);
    }

    public String getFullyQualifiedDataType() {
        return this.fullyQualifiedDataType;
    }

    protected void setFullyQualifiedDataType(String dataType) {
        String old = this.fullyQualifiedDataType;
        this.fullyQualifiedDataType = dataType;
        this.firePropertyChanged(FULLY_QUALIFIED_DATA_TYPE_PROPERTY, old, dataType);
    }

    protected String buildFullyQualifiedDataType(EclipseLinkObjectTypeConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getFullyQualifiedDataType();
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        this.getAnnotation().setObjectType(newObjectType);
        this.firePropertyChanged("objectType", oldObjectType, newObjectType);
    }

    protected void setObjectType_(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        this.firePropertyChanged("objectType", oldObjectType, newObjectType);
    }

    public String getFullyQualifiedObjectType() {
        return this.fullyQualifiedObjectType;
    }

    protected void setFullyQualifiedObjectType(String objectType) {
        String old = this.fullyQualifiedObjectType;
        this.fullyQualifiedObjectType = objectType;
        this.firePropertyChanged(FULLY_QUALIFIED_OBJECT_TYPE_PROPERTY, old, objectType);
    }

    protected String buildFullyQualifiedObjectType(EclipseLinkObjectTypeConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getFullyQualifiedObjectType();
    }

    public ListIterator<JavaEclipseLinkConversionValue> conversionValues() {
        return new CloneListIterator(this.conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.conversionValues.size();
    }

    @Override
    public JavaEclipseLinkConversionValue addConversionValue(int index) {
        JavaEclipseLinkConversionValue conversionValue = new JavaEclipseLinkConversionValue(this);
        this.conversionValues.add(index, conversionValue);
        EclipseLinkConversionValueAnnotation resourceConversionValue = this.getAnnotation().addConversionValue(index);
        conversionValue.initialize(resourceConversionValue);
        this.fireItemAdded("conversionValues", index, conversionValue);
        return conversionValue;
    }

    @Override
    public JavaEclipseLinkConversionValue addConversionValue() {
        return this.addConversionValue(this.conversionValues.size());
    }

    protected void addConversionValue(int index, JavaEclipseLinkConversionValue conversionValue) {
        this.addItemToList(index, conversionValue, this.conversionValues, "conversionValues");
    }

    protected void addConversionValue(JavaEclipseLinkConversionValue conversionValue) {
        this.addConversionValue(this.conversionValues.size(), conversionValue);
    }

    @Override
    public void removeConversionValue(EclipseLinkConversionValue conversionValue) {
        this.removeConversionValue(this.conversionValues.indexOf(conversionValue));
    }

    @Override
    public void removeConversionValue(int index) {
        JavaEclipseLinkConversionValue removedConversionValue = this.conversionValues.remove(index);
        this.getAnnotation().removeConversionValue(index);
        this.fireItemRemoved("conversionValues", index, removedConversionValue);
    }

    protected void removeConversionValue_(JavaEclipseLinkConversionValue conversionValue) {
        this.removeItemFromList(conversionValue, this.conversionValues, "conversionValues");
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.conversionValues, (int)targetIndex, (int)sourceIndex);
        this.getAnnotation().moveConversionValue(targetIndex, sourceIndex);
        this.fireItemMoved("conversionValues", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<String> dataValues() {
        return new TransformationListIterator<JavaEclipseLinkConversionValue, String>(this.conversionValues()){

            protected String transform(JavaEclipseLinkConversionValue next) {
                return next.getDataValue();
            }
        };
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        this.getAnnotation().setDefaultObjectValue(newDefaultObjectValue);
        this.firePropertyChanged("defaultObjectValue", oldDefaultObjectValue, newDefaultObjectValue);
    }

    protected void setDefaultObjectValue_(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        this.firePropertyChanged("defaultObjectValue", oldDefaultObjectValue, newDefaultObjectValue);
    }

    @Override
    protected void initialize(JavaResourcePersistentMember jrpm) {
        super.initialize(jrpm);
        EclipseLinkObjectTypeConverterAnnotation resourceConverter = this.getAnnotation();
        this.dataType = this.dataType(resourceConverter);
        this.fullyQualifiedDataType = this.buildFullyQualifiedDataType(resourceConverter);
        this.objectType = this.objectType(resourceConverter);
        this.fullyQualifiedObjectType = this.buildFullyQualifiedObjectType(resourceConverter);
        this.defaultObjectValue = this.defaultObjectValue(resourceConverter);
        this.initializeConversionValues(resourceConverter);
    }

    protected void initializeConversionValues(EclipseLinkObjectTypeConverterAnnotation resourceConverter) {
        if (resourceConverter == null) {
            return;
        }
        ListIterator<EclipseLinkConversionValueAnnotation> resourceConversionValues = resourceConverter.conversionValues();
        while (resourceConversionValues.hasNext()) {
            this.conversionValues.add(this.buildConversionValue(resourceConversionValues.next()));
        }
    }

    protected JavaEclipseLinkConversionValue buildConversionValue(EclipseLinkConversionValueAnnotation resourceConversionValue) {
        JavaEclipseLinkConversionValue conversionValue = new JavaEclipseLinkConversionValue(this);
        conversionValue.initialize(resourceConversionValue);
        return conversionValue;
    }

    @Override
    public void update(JavaResourcePersistentMember jrpm) {
        super.update(jrpm);
        EclipseLinkObjectTypeConverterAnnotation resourceConverter = this.getAnnotation();
        this.setDataType_(this.dataType(resourceConverter));
        this.setFullyQualifiedDataType(this.buildFullyQualifiedDataType(resourceConverter));
        this.setObjectType_(this.objectType(resourceConverter));
        this.setFullyQualifiedObjectType(this.buildFullyQualifiedObjectType(resourceConverter));
        this.setDefaultObjectValue_(this.defaultObjectValue(resourceConverter));
        this.updateConversionValues(resourceConverter);
    }

    protected void updateConversionValues(EclipseLinkObjectTypeConverterAnnotation resourceConverter) {
        ListIterator<JavaEclipseLinkConversionValue> contextConversionValues = this.conversionValues();
        ListIterator<EclipseLinkConversionValueAnnotation> resourceConversionValues = resourceConverter.conversionValues();
        while (contextConversionValues.hasNext()) {
            JavaEclipseLinkConversionValue conversionValues = contextConversionValues.next();
            if (resourceConversionValues.hasNext()) {
                conversionValues.update(resourceConversionValues.next());
                continue;
            }
            this.removeConversionValue_(conversionValues);
        }
        while (resourceConversionValues.hasNext()) {
            this.addConversionValue(this.buildConversionValue(resourceConversionValues.next()));
        }
    }

    protected String dataType(EclipseLinkObjectTypeConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getDataType();
    }

    protected String objectType(EclipseLinkObjectTypeConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getObjectType();
    }

    protected String defaultObjectValue(EclipseLinkObjectTypeConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getDefaultObjectValue();
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        ListIterator<JavaEclipseLinkConversionValue> stream = this.conversionValues();
        while (stream.hasNext()) {
            ((JavaEclipseLinkConversionValue)stream.next()).validate(messages, reporter, astRoot);
        }
    }
}

