/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlClassReference;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkCustomizer;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlCustomizerHolder;

public class OrmEclipseLinkCustomizer
extends AbstractOrmXmlContextNode
implements EclipseLinkCustomizer {
    protected final XmlCustomizerHolder resource;
    protected String specifiedCustomizerClass;
    protected String defaultCustomizerClass;

    public OrmEclipseLinkCustomizer(OrmTypeMapping parent, XmlCustomizerHolder resource, JavaEclipseLinkCustomizer javaCustomizer) {
        super((JpaContextNode)parent);
        this.resource = resource;
        this.defaultCustomizerClass = this.getJavaCustomizerClass(javaCustomizer);
        this.specifiedCustomizerClass = this.getResourceCustomizerClass();
    }

    public char getCustomizerClassEnclosingTypeSeparator() {
        return '$';
    }

    public String getCustomizerClass() {
        return this.specifiedCustomizerClass == null ? this.defaultCustomizerClass : this.specifiedCustomizerClass;
    }

    public String getDefaultCustomizerClass() {
        return this.defaultCustomizerClass;
    }

    protected void setDefaultCustomizerClass(String newDefaultCustomizerClass) {
        String oldDefaultCustomizerClass = this.defaultCustomizerClass;
        this.defaultCustomizerClass = newDefaultCustomizerClass;
        this.firePropertyChanged("defaultCustomizerClass", oldDefaultCustomizerClass, newDefaultCustomizerClass);
    }

    public String getSpecifiedCustomizerClass() {
        return this.specifiedCustomizerClass;
    }

    public void setSpecifiedCustomizerClass(String newCustomizerClass) {
        String oldCustomizerClass = this.specifiedCustomizerClass;
        this.specifiedCustomizerClass = newCustomizerClass;
        if (oldCustomizerClass != newCustomizerClass) {
            if (this.getResourceCustomizer() != null) {
                this.getResourceCustomizer().setClassName(newCustomizerClass);
                if (this.getResourceCustomizer().isUnset()) {
                    this.removeResourceCustomizer();
                }
            } else if (newCustomizerClass != null) {
                this.addResourceCustomizer();
                this.getResourceCustomizer().setClassName(newCustomizerClass);
            }
        }
        this.firePropertyChanged("specifiedCustomizerClass", oldCustomizerClass, newCustomizerClass);
    }

    protected void setSpecifiedCustomizerClass_(String newCustomizerClass) {
        String oldCustomizerClass = this.specifiedCustomizerClass;
        this.specifiedCustomizerClass = newCustomizerClass;
        this.firePropertyChanged("specifiedCustomizerClass", oldCustomizerClass, newCustomizerClass);
    }

    protected XmlClassReference getResourceCustomizer() {
        return this.resource.getCustomizer();
    }

    protected void addResourceCustomizer() {
        this.resource.setCustomizer(OrmFactory.eINSTANCE.createXmlClassReference());
    }

    protected void removeResourceCustomizer() {
        this.resource.setCustomizer(null);
    }

    protected void update(JavaEclipseLinkCustomizer javaCustomizer) {
        this.setDefaultCustomizerClass(this.getJavaCustomizerClass(javaCustomizer));
        this.setSpecifiedCustomizerClass_(this.getResourceCustomizerClass());
    }

    protected String getJavaCustomizerClass(JavaEclipseLinkCustomizer javaCustomizer) {
        return javaCustomizer == null ? null : javaCustomizer.getFullyQualifiedCustomizerClass();
    }

    protected String getResourceCustomizerClass() {
        XmlClassReference resource = this.getResourceCustomizer();
        return resource == null ? null : resource.getClassName();
    }

    public TextRange getValidationTextRange() {
        XmlClassReference resource = this.getResourceCustomizer();
        return resource == null ? null : resource.getClassNameTextRange();
    }
}

