/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public abstract class VersionUpgradeOperation
extends AbstractOperation {
    protected final int _oldVersion;
    protected final int _newVersion;
    private boolean _hasExecuted;
    private boolean _hasCommitted;
    private boolean _hasCleanState = true;

    public VersionUpgradeOperation(String label, int oldVersion, int newVersion) {
        super(label);
        this._oldVersion = oldVersion;
        this._newVersion = newVersion;
    }

    public final IStatus commit() throws ExecutionException {
        if (this.canCommit()) {
            IStatus result = this.doCommit();
            if (result.getSeverity() == 0) {
                this._hasCommitted = true;
            } else {
                this._hasCommitted = false;
                this._hasCleanState = false;
            }
            return result;
        }
        throw new ExecutionException("Cannot execute");
    }

    protected abstract IStatus doCommit() throws ExecutionException;

    public boolean canCommit() {
        return this._hasExecuted && !this._hasCommitted && this._hasCleanState;
    }

    public final IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.canExecute()) {
            IStatus result = this.doExecute(monitor, info);
            if (result.getSeverity() == 0) {
                this._hasExecuted = true;
            } else {
                this._hasExecuted = false;
                this._hasCleanState = false;
            }
            return result;
        }
        throw new ExecutionException("Cannot execute");
    }

    protected abstract IStatus doExecute(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public final IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.canRedo()) {
            IStatus result = this.doRedo(monitor, info);
            if (result.getSeverity() == 0) {
                this._hasExecuted = true;
            } else {
                this._hasExecuted = false;
                this._hasCleanState = false;
            }
            return result;
        }
        throw new ExecutionException("Cannot redo");
    }

    protected abstract IStatus doRedo(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public final IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.canUndo()) {
            IStatus result = this.doUndo(monitor, info);
            if (result.getSeverity() == 0) {
                this._hasExecuted = false;
            } else {
                this._hasExecuted = true;
                this._hasCleanState = false;
            }
            return result;
        }
        throw new ExecutionException("Cannot redo");
    }

    protected abstract IStatus doUndo(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public boolean canExecute() {
        return !this._hasExecuted && this._hasCleanState;
    }

    public boolean canRedo() {
        return this.canExecute();
    }

    public boolean canUndo() {
        return this._hasExecuted && this._hasCleanState;
    }

    protected void setHasExecuted(boolean executed) {
        this._hasExecuted = executed;
    }

    protected void setHasCommitted(boolean committed) {
        this._hasCommitted = committed;
    }

    protected void setHasCleanState(boolean cleanState) {
        this._hasCleanState = cleanState;
    }

    protected boolean hasExecuted() {
        return this._hasExecuted;
    }

    protected boolean hasCommitted() {
        return this._hasCommitted;
    }

    protected boolean hasCleanState() {
        return this._hasCleanState;
    }
}

