/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jwt.converter.PluginProperties;
import org.eclipse.jwt.converter.internal.ConverterManager;
import org.eclipse.jwt.converter.internal.exception.UnsupportedVersionException;

public class Converter {
    private static final Logger logger = Logger.getLogger(Converter.class.toString());
    private static boolean junit = false;

    public static void activateJUnitMode() {
        junit = true;
    }

    private static String readWEVersionFromFile(String modelFile) throws Exception {
        String fileVersion = "";
        FileInputStream inputStream = null;
        BufferedReader reader = null;
        String fileContents = "";
        try {
            try {
                String line;
                inputStream = new FileInputStream(modelFile);
                StringBuilder sb = new StringBuilder();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                fileContents = sb.toString();
                int versionStringBegin = fileContents.indexOf("fileversion=\"") + "fileversion=\"".length();
                int versionStringEnd = fileContents.indexOf("\"", versionStringBegin);
                if (versionStringBegin != -1 && versionStringEnd != -1 && versionStringBegin != versionStringEnd) {
                    fileVersion = fileContents.substring(versionStringBegin, versionStringEnd);
                }
                reader.close();
            }
            catch (Exception e) {
                throw new Exception(PluginProperties.getString("convert_nosrcver_error"), e);
            }
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            reader.close();
            inputStream.close();
        }
        catch (Exception exception) {}
        return fileVersion;
    }

    public static void updateModel(URI modelFile, String targetVersion, boolean inAgilProMode) throws Exception {
        String filePath = modelFile.toFileString();
        if (filePath == null || !new File(filePath).exists()) {
            URL url = new URL(modelFile.toString());
            filePath = FileLocator.resolve((URL)url).toString().replace("file:", "");
        }
        String sourceWEVersion = Converter.readWEVersionFromFile(filePath);
        String targetWEVersion = targetVersion;
        String sourceWEVersionOfficial = sourceWEVersion;
        String targetWEVersionOfficial = targetWEVersion;
        String displayMessage = String.valueOf(PluginProperties.getString("convert_sourcever_message")) + " \"" + sourceWEVersionOfficial + "\". " + PluginProperties.getString("convert_targetver_message") + " \"" + targetWEVersionOfficial + "\". \n\n";
        if (inAgilProMode) {
            String[] temp = targetWEVersion.split("\\.");
            temp[0] = new Integer(new Integer(temp[0]) + 1).toString();
            targetWEVersionOfficial = String.valueOf(temp[0]) + "." + temp[1] + "." + temp[2];
            temp = sourceWEVersion.split("\\.");
            temp[0] = new Integer(new Integer(temp[0]) + 1).toString();
            sourceWEVersionOfficial = String.valueOf(temp[0]) + "." + temp[1] + "." + temp[2];
        }
        if (sourceWEVersion.equals("")) {
            logger.severe("could not read file version from workflow file " + filePath);
            if (!junit) {
                MessageDialog.openError(null, (String)PluginProperties.getString("convert_title"), (String)(String.valueOf(displayMessage) + PluginProperties.getString("convert_nosrcver_error")));
            }
            throw new Exception(PluginProperties.getString("could not determine the version of the source file"));
        }
        if (sourceWEVersion.equals(targetWEVersion)) {
            return;
        }
        logger.info("converter: source model version " + sourceWEVersion + ", target model version " + targetWEVersion);
        try {
            ConverterManager.getInstance().convert(filePath, filePath, sourceWEVersion, targetWEVersion);
        }
        catch (UnsupportedVersionException e) {
            logger.severe("the file version " + sourceWEVersion + "of the workflow file " + filePath + " is not supported");
            if (!junit) {
                MessageDialog.openError(null, (String)PluginProperties.getString("convert_title"), (String)(String.valueOf(displayMessage) + PluginProperties.getString("convert_nosupport_message")));
            }
            throw e;
        }
        catch (Exception e) {
            logger.severe("the update of the workflow file " + filePath + " failed because of an unknown error");
            if (!junit) {
                MessageDialog.openError(null, (String)PluginProperties.getString("convert_title"), (String)(String.valueOf(displayMessage) + PluginProperties.getString("convert_fail_message")));
            }
            e.printStackTrace();
            throw e;
        }
        logger.info("converter: the workflow file has been successfully converted to version " + targetWEVersion);
        if (!junit) {
            MessageDialog.openInformation(null, (String)PluginProperties.getString("convert_title"), (String)(String.valueOf(displayMessage) + PluginProperties.getString("convert_success_message")));
        }
    }
}

