/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.model.processes.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.meta.model.processes.ActivityLinkNode;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.meta.model.processes.BooleanConnector;
import org.eclipse.jwt.meta.model.processes.ControlNode;
import org.eclipse.jwt.meta.model.processes.DecisionNode;
import org.eclipse.jwt.meta.model.processes.ExecutableNode;
import org.eclipse.jwt.meta.model.processes.FinalNode;
import org.eclipse.jwt.meta.model.processes.ForkNode;
import org.eclipse.jwt.meta.model.processes.Guard;
import org.eclipse.jwt.meta.model.processes.GuardSpecification;
import org.eclipse.jwt.meta.model.processes.InitialNode;
import org.eclipse.jwt.meta.model.processes.JoinNode;
import org.eclipse.jwt.meta.model.processes.MergeNode;
import org.eclipse.jwt.meta.model.processes.OperationType;
import org.eclipse.jwt.meta.model.processes.ProcessesFactory;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.meta.model.processes.StructuredActivityNode;
import org.eclipse.jwt.meta.model.processes.impl.ActionImpl;
import org.eclipse.jwt.meta.model.processes.impl.ActivityEdgeImpl;
import org.eclipse.jwt.meta.model.processes.impl.ActivityImpl;
import org.eclipse.jwt.meta.model.processes.impl.ActivityLinkNodeImpl;
import org.eclipse.jwt.meta.model.processes.impl.ActivityNodeImpl;
import org.eclipse.jwt.meta.model.processes.impl.ControlNodeImpl;
import org.eclipse.jwt.meta.model.processes.impl.DecisionNodeImpl;
import org.eclipse.jwt.meta.model.processes.impl.ExecutableNodeImpl;
import org.eclipse.jwt.meta.model.processes.impl.FinalNodeImpl;
import org.eclipse.jwt.meta.model.processes.impl.ForkNodeImpl;
import org.eclipse.jwt.meta.model.processes.impl.GuardImpl;
import org.eclipse.jwt.meta.model.processes.impl.GuardSpecificationImpl;
import org.eclipse.jwt.meta.model.processes.impl.InitialNodeImpl;
import org.eclipse.jwt.meta.model.processes.impl.JoinNodeImpl;
import org.eclipse.jwt.meta.model.processes.impl.MergeNodeImpl;
import org.eclipse.jwt.meta.model.processes.impl.ScopeImpl;
import org.eclipse.jwt.meta.model.processes.impl.StructuredActivityNodeImpl;

public class ProcessesFactoryImpl
extends EFactoryImpl
implements ProcessesFactory {
    public static final String copyright = "Copyright (c) 2005-2010  Eclipse Java Workflow Tooling (JWT) Project <www.eclipse.org/jwt>";

    public static ProcessesFactory init() {
        try {
            ProcessesFactory theProcessesFactory = (ProcessesFactory)EPackage.Registry.INSTANCE.getEFactory("org.eclipse.jwt/processes");
            if (theProcessesFactory != null) {
                return theProcessesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ProcessesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createScope();
            }
            case 1: {
                return this.createActivity();
            }
            case 2: {
                return this.createStructuredActivityNode();
            }
            case 3: {
                return this.createActivityNode();
            }
            case 4: {
                return this.createActivityEdge();
            }
            case 5: {
                return this.createGuardSpecification();
            }
            case 6: {
                return this.createExecutableNode();
            }
            case 7: {
                return this.createAction();
            }
            case 8: {
                return this.createControlNode();
            }
            case 9: {
                return this.createInitialNode();
            }
            case 10: {
                return this.createForkNode();
            }
            case 11: {
                return this.createJoinNode();
            }
            case 12: {
                return this.createMergeNode();
            }
            case 13: {
                return this.createDecisionNode();
            }
            case 14: {
                return this.createFinalNode();
            }
            case 15: {
                return this.createGuard();
            }
            case 16: {
                return this.createActivityLinkNode();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 17: {
                return this.createOperationTypeFromString(eDataType, initialValue);
            }
            case 18: {
                return this.createBooleanConnectorFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 17: {
                return this.convertOperationTypeToString(eDataType, instanceValue);
            }
            case 18: {
                return this.convertBooleanConnectorToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Scope createScope() {
        ScopeImpl scope = new ScopeImpl();
        return scope;
    }

    public Activity createActivity() {
        ActivityImpl activity = new ActivityImpl();
        return activity;
    }

    public StructuredActivityNode createStructuredActivityNode() {
        StructuredActivityNodeImpl structuredActivityNode = new StructuredActivityNodeImpl();
        return structuredActivityNode;
    }

    public ActivityNode createActivityNode() {
        ActivityNodeImpl activityNode = new ActivityNodeImpl();
        return activityNode;
    }

    public ActivityEdge createActivityEdge() {
        ActivityEdgeImpl activityEdge = new ActivityEdgeImpl();
        return activityEdge;
    }

    public GuardSpecification createGuardSpecification() {
        GuardSpecificationImpl guardSpecification = new GuardSpecificationImpl();
        return guardSpecification;
    }

    public ExecutableNode createExecutableNode() {
        ExecutableNodeImpl executableNode = new ExecutableNodeImpl();
        return executableNode;
    }

    public Action createAction() {
        ActionImpl action = new ActionImpl();
        return action;
    }

    public ControlNode createControlNode() {
        ControlNodeImpl controlNode = new ControlNodeImpl();
        return controlNode;
    }

    public InitialNode createInitialNode() {
        InitialNodeImpl initialNode = new InitialNodeImpl();
        return initialNode;
    }

    public ForkNode createForkNode() {
        ForkNodeImpl forkNode = new ForkNodeImpl();
        return forkNode;
    }

    public JoinNode createJoinNode() {
        JoinNodeImpl joinNode = new JoinNodeImpl();
        return joinNode;
    }

    public MergeNode createMergeNode() {
        MergeNodeImpl mergeNode = new MergeNodeImpl();
        return mergeNode;
    }

    public DecisionNode createDecisionNode() {
        DecisionNodeImpl decisionNode = new DecisionNodeImpl();
        return decisionNode;
    }

    public FinalNode createFinalNode() {
        FinalNodeImpl finalNode = new FinalNodeImpl();
        return finalNode;
    }

    public Guard createGuard() {
        GuardImpl guard = new GuardImpl();
        return guard;
    }

    public ActivityLinkNode createActivityLinkNode() {
        ActivityLinkNodeImpl activityLinkNode = new ActivityLinkNodeImpl();
        return activityLinkNode;
    }

    public OperationType createOperationTypeFromString(EDataType eDataType, String initialValue) {
        OperationType result = OperationType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertOperationTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public BooleanConnector createBooleanConnectorFromString(EDataType eDataType, String initialValue) {
        BooleanConnector result = BooleanConnector.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertBooleanConnectorToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ProcessesPackage getProcessesPackage() {
        return (ProcessesPackage)this.getEPackage();
    }

    @Deprecated
    public static ProcessesPackage getPackage() {
        return ProcessesPackage.eINSTANCE;
    }
}

