/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.xslt.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.eclipse.jwt.transformations.api.TransformationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class XSLTProcessor {
    public void processXSLT(String inFilePath, String outFilePath, InputStream ... xsltInputs) throws TransformationException {
        SAXTransformerFactory stf;
        XMLReader reader;
        File inFile = new File(inFilePath);
        if (!inFile.exists() || inFile.isDirectory() || !inFile.canRead()) {
            throw new TransformationException("Can't open in file " + inFile.getAbsolutePath());
        }
        File outFile = new File(outFilePath);
        if (!outFile.exists()) {
            try {
                outFile.createNewFile();
            }
            catch (IOException ex) {
                throw new TransformationException("Cannot create output file " + outFile.getAbsolutePath(), (Throwable)ex);
            }
        }
        if (outFile.isDirectory() || !outFile.canWrite()) {
            throw new TransformationException("Can't open out file " + outFile.getAbsolutePath());
        }
        try {
            SAXParserFactory spf = SAXParserFactoryImpl.newInstance();
            spf.setNamespaceAware(true);
            reader = spf.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new TransformationException("Can't init SAX parser", (Throwable)e);
        }
        catch (SAXException e) {
            throw new TransformationException("Can't init SAX parser or XML reader", (Throwable)e);
        }
        try {
            stf = (SAXTransformerFactory)TransformerFactoryImpl.newInstance();
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new TransformationException("Can't init transformer factory", (Throwable)e);
        }
        XMLReader parent = reader;
        int i = 0;
        InputStream[] inputStreamArray = xsltInputs;
        int n = xsltInputs.length;
        int n2 = 0;
        while (n2 < n) {
            InputStream xslIs = inputStreamArray[n2];
            XMLFilter filter = null;
            try {
                filter = stf.newXMLFilter(new StreamSource(xslIs));
            }
            catch (TransformerConfigurationException e) {
                throw new TransformationException("Can't init transformer from XSLT", (Throwable)e);
            }
            filter.setParent(parent);
            parent = filter;
            ++i;
            ++n2;
        }
        try {
            SAXSource source = new SAXSource(parent, new InputSource(new FileInputStream(inFile)));
            StreamResult result = new StreamResult(new FileOutputStream(outFile));
            Transformer transformer = stf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new TransformationException("Error transforming " + inFile.getAbsolutePath() + " to " + outFile.getAbsolutePath() + " using specified xsl path", (Throwable)e);
        }
    }
}

