/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.internal.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.model.view.LayoutData;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ReferenceEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WEDragAndDropCommand
extends DragAndDropCommand {
    private WEEditor weeditor;
    private Collection viewInformationStatus;
    private Command deleteCopyCommand;

    public WEDragAndDropCommand(WEEditor weeditor, EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        super(domain, owner, location, operations, operation, collection);
        this.weeditor = weeditor;
    }

    protected boolean prepare() {
        for (EObject object : this.collection) {
            ActivityNode actNode;
            if (object instanceof ReferenceEdge || object instanceof ActivityEdge) {
                return false;
            }
            if (!(!(object instanceof ActivityNode) || (actNode = (ActivityNode)object).getIn().isEmpty() && actNode.getOut().isEmpty())) {
                return false;
            }
            if (object instanceof Action && !EMFHelper.getReferenceEdgesForAction(this.weeditor, (Action)object).isEmpty()) {
                return false;
            }
            if (!(object instanceof Reference) || ((Reference)object).getReferenceEdges().isEmpty()) continue;
            return false;
        }
        return super.prepare();
    }

    public void execute() {
        if (!(this.dragCommand instanceof IdentityCommand)) {
            this.copyRelatedViewInfo();
            this.closeAllRelatedActivities();
            super.execute();
            this.restoreRelatedViewInfoFromCopy();
        } else {
            this.closeAllRelatedActivities();
            super.execute();
        }
    }

    public void redo() {
        if (!(this.dragCommand instanceof IdentityCommand)) {
            this.closeAllRelatedActivities();
            super.redo();
            this.restoreRelatedViewInfoFromCopy();
        } else {
            this.closeAllRelatedActivities();
            super.redo();
        }
    }

    public void undo() {
        if (!(this.dragCommand instanceof IdentityCommand)) {
            this.closeAllRelatedActivities();
            this.removeRelatedViewInfo();
            super.undo();
        } else {
            this.closeAllRelatedActivities();
            super.undo();
        }
    }

    private void copyRelatedViewInfo() {
        Collection containedViewInfo = EMFHelper.getAllContainedReferences(this.weeditor, this.collection);
        containedViewInfo.addAll(EMFHelper.getAllContainedReferenceEdges(this.weeditor, this.collection));
        ArrayList list = new ArrayList();
        list.addAll(this.collection);
        list.addAll(containedViewInfo);
        containedViewInfo.addAll(LayoutDataManager.getAllContainedLayoutDatas(this.weeditor, list));
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
        this.viewInformationStatus = copier.copyAll(containedViewInfo);
        copier.copyReferences();
    }

    private void closeAllRelatedActivities() {
        HashSet relatedActivities = new HashSet();
        for (Object object : this.collection) {
            if (object instanceof Activity) {
                relatedActivities.add(object);
                continue;
            }
            TreeIterator iter = ((EObject)object).eAllContents();
            while (iter.hasNext()) {
                EObject content = (EObject)iter.next();
                if (!(content instanceof Activity)) continue;
                relatedActivities.add(content);
            }
        }
        for (Object object : this.viewInformationStatus) {
            Object containerScope = null;
            if (object instanceof Reference) {
                containerScope = ((Reference)object).getContainedIn();
            }
            if (object instanceof ReferenceEdge) {
                containerScope = ((ReferenceEdge)object).getContainedIn();
            }
            if (object instanceof LayoutData && ((LayoutData)object).getDescribesElement() != null) {
                containerScope = ((LayoutData)object).getDescribesElement() instanceof Reference ? ((Reference)((LayoutData)object).getDescribesElement()).getContainedIn() : ((LayoutData)object).getDescribesElement().eContainer();
            }
            if (containerScope instanceof Activity) {
                relatedActivities.add(containerScope);
                continue;
            }
            if (containerScope == null) continue;
            containerScope = containerScope.eContainer();
            while (!(containerScope instanceof Activity) && containerScope != null) {
                containerScope = containerScope.eContainer();
            }
            if (!(containerScope instanceof Activity)) continue;
            relatedActivities.add(containerScope);
        }
        for (Object activity : relatedActivities) {
            this.weeditor.removeActivityFromPage((Activity)activity);
        }
    }

    private void restoreRelatedViewInfoFromCopy() {
        if (this.deleteCopyCommand != null && this.deleteCopyCommand.canUndo()) {
            this.deleteCopyCommand.undo();
        } else {
            for (Object vi : this.viewInformationStatus) {
                if (vi instanceof Reference) {
                    this.weeditor.getDiagramData().getReferences().add((Object)((Reference)vi));
                    continue;
                }
                if (vi instanceof ReferenceEdge) {
                    this.weeditor.getDiagramData().getReferenceEdges().add((Object)((ReferenceEdge)vi));
                    continue;
                }
                if (!(vi instanceof LayoutData)) continue;
                this.weeditor.getDiagramData().getLayoutData().add((Object)((LayoutData)vi));
            }
        }
    }

    private void removeRelatedViewInfo() {
        this.deleteCopyCommand = DeleteCommand.create((EditingDomain)this.domain, (Collection)this.viewInformationStatus);
        if (this.deleteCopyCommand.canExecute()) {
            this.deleteCopyCommand.execute();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.deleteCopyCommand != null) {
            this.deleteCopyCommand.dispose();
        }
        if (this.viewInformationStatus != null) {
            this.viewInformationStatus.clear();
        }
    }
}

