/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.clipboard;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.commands.clipboard.JWTCopyToClipboardCommand;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.internal.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.model.view.ReferenceEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WECopyToClipboardCommand
extends JWTCopyToClipboardCommand {
    private WEEditor weeditor;

    public WECopyToClipboardCommand(WEEditor weeditor, EditingDomain domain, Collection<?> collection) {
        super(domain, collection);
        this.weeditor = weeditor;
    }

    public boolean checkIfCommandCanBeExecuted() {
        HashSet relevantObjects = new HashSet();
        for (Object object : this.sourceObjects) {
            if (!(object instanceof EObject) || object instanceof ReferenceEdge || object instanceof ActivityEdge) continue;
            boolean containerIsAlreadyPresent = false;
            EObject container = ((EObject)object).eContainer();
            while (container != null) {
                if (this.sourceObjects.contains(container)) {
                    containerIsAlreadyPresent = true;
                    break;
                }
                container = container.eContainer();
            }
            if (containerIsAlreadyPresent) continue;
            relevantObjects.add(object);
        }
        this.sourceObjects = relevantObjects;
        if (this.sourceObjects.isEmpty()) {
            return false;
        }
        Set edges = EMFHelper.getAffectedEdges(this.sourceObjects);
        if (this.copyCommand != null) {
            this.copyCommand.dispose();
        }
        this.sourceObjects.addAll(edges);
        this.sourceObjects.addAll(EMFHelper.getAllContainedReferenceEdges(this.weeditor, this.sourceObjects));
        this.sourceObjects.addAll(EMFHelper.getAllContainedReferences(this.weeditor, this.sourceObjects));
        this.sourceObjects.addAll(LayoutDataManager.getAllContainedLayoutDatas(this.weeditor, this.sourceObjects));
        return this.prepare();
    }
}

