/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.clipboard;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.commands.clipboard.JWTCutToClipboardCommand;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.internal.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.model.view.ReferenceEdge;

public class WECutToClipboardCommand
extends JWTCutToClipboardCommand {
    private WEEditor weeditor;

    public WECutToClipboardCommand(WEEditor weeditor, EditingDomain domain, Command command) {
        super(domain, command);
        this.weeditor = weeditor;
    }

    private Set getAffectedObjectsForClipboard() {
        Set removeCommands = this.getAllRemoveCommandsRecursively(this.command);
        HashSet<EObject> affectedObjects = new HashSet<EObject>();
        for (RemoveCommand removeCommand : removeCommands) {
            for (EObject object : removeCommand.getCollection()) {
                if (object instanceof ActivityEdge || object instanceof ReferenceEdge) continue;
                affectedObjects.add(object);
            }
        }
        affectedObjects.addAll(EMFHelper.getAllContainedReferences(this.weeditor, affectedObjects));
        affectedObjects.addAll(EMFHelper.getAllContainedReferenceEdges(this.weeditor, affectedObjects));
        affectedObjects.addAll(EMFHelper.getAffectedEdges(affectedObjects));
        affectedObjects.addAll(LayoutDataManager.getAllContainedLayoutDatas(this.weeditor, affectedObjects));
        HashSet containerPresent = new HashSet();
        block2: for (Object e : affectedObjects) {
            if (!(e instanceof EObject)) continue;
            EObject container = ((EObject)e).eContainer();
            while (container != null) {
                if (affectedObjects.contains(container)) {
                    containerPresent.add(e);
                    continue block2;
                }
                container = container.eContainer();
            }
        }
        affectedObjects.removeAll(containerPresent);
        return affectedObjects;
    }

    public void execute() {
        Set affectedObjects = this.getAffectedObjectsForClipboard();
        if (this.domain != null) {
            this.oldClipboard = this.domain.getClipboard();
            Collection copy = EcoreUtil.copyAll((Collection)affectedObjects);
            EMFHelper.unsetUnconnectedRefElements(this.weeditor, copy);
            this.domain.setClipboard(copy);
        }
        if (this.command != null) {
            this.command.execute();
        }
    }

    public void redo() {
        Set affectedObjects = this.getAffectedObjectsForClipboard();
        if (this.domain != null) {
            this.oldClipboard = this.domain.getClipboard();
            Collection copy = EcoreUtil.copyAll((Collection)affectedObjects);
            EMFHelper.unsetUnconnectedRefElements(this.weeditor, copy);
            this.domain.setClipboard(copy);
        }
        if (this.command != null) {
            this.command.redo();
        }
    }

    public void undo() {
        super.undo();
    }
}

