/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.scope;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jwt.meta.model.core.Comment;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.internal.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.model.view.LayoutData;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ReferenceEdge;
import org.eclipse.jwt.we.model.view.ViewPackage;

public class InsertScopeCopyCommand
extends Command {
    private WEEditor weeditor;
    private EditingDomain editingDomain;
    private CreateRequest request;
    private Scope newScope;
    private Point insertPoint;
    private CompoundCommand addCommand;
    private Collection elementsCopied;
    private Point minPoint;
    private Point maxPoint;

    public InsertScopeCopyCommand(WEEditor weeditor, EditingDomain editingDomain, CreateRequest request, Scope scope, Point insertPoint) {
        this.editingDomain = editingDomain;
        this.newScope = scope;
        this.insertPoint = insertPoint;
        this.request = request;
        this.weeditor = weeditor;
    }

    public Point getMinPoint() {
        return this.minPoint;
    }

    public Point getMaxPoint() {
        return this.maxPoint;
    }

    public boolean canExecute() {
        return this.editingDomain != null && this.newScope != null && this.request != null && this.request.getNewObjectType() instanceof Class && Scope.class.isAssignableFrom((Class)this.request.getNewObjectType());
    }

    public void prepareCopy() {
        Scope oldScope = (Scope)this.request.getNewObject();
        EList<Reference> oldReferencesInScope = EMFHelper.getReferencesForScope(this.weeditor, oldScope);
        EList<ReferenceEdge> oldReferenceEdgesInScope = EMFHelper.getReferenceEdgesForScope(this.weeditor, oldScope);
        ArrayList<Object> elementsToCopy = new ArrayList<Object>();
        elementsToCopy.addAll((Collection<Object>)oldScope.getNodes());
        elementsToCopy.addAll((Collection<Object>)oldScope.getEdges());
        elementsToCopy.addAll((Collection<Object>)oldScope.getOwnedComment());
        elementsToCopy.addAll((Collection<Object>)oldReferencesInScope);
        elementsToCopy.addAll((Collection<Object>)oldReferenceEdgesInScope);
        Object[] objectArray = elementsToCopy.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof GraphicalElement) {
                elementsToCopy.addAll((Collection<Object>)LayoutDataManager.getLayoutDataForGraphicalElement(this.weeditor, (GraphicalElement)object));
            }
            ++n2;
        }
        this.elementsCopied = EcoreUtil.copyAll(elementsToCopy);
        this.minPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.maxPoint = new Point(0, 0);
        for (Object e : elementsToCopy) {
            if (!(e instanceof GraphicalElement) || LayoutDataManager.getX(this.weeditor, (GraphicalElement)e) == 0) continue;
            this.minPoint = Point.min((Point)this.minPoint, (Point)new Point(LayoutDataManager.getX(this.weeditor, (GraphicalElement)e), LayoutDataManager.getY(this.weeditor, (GraphicalElement)e)));
            this.maxPoint = Point.max((Point)this.maxPoint, (Point)new Point(LayoutDataManager.getX(this.weeditor, (GraphicalElement)e) + LayoutDataManager.getWidth(this.weeditor, (GraphicalElement)e), LayoutDataManager.getY(this.weeditor, (GraphicalElement)e) + LayoutDataManager.getHeight(this.weeditor, (GraphicalElement)e)));
        }
    }

    public void execute() {
        ArrayList newReferences = new ArrayList();
        ArrayList newReferenceEdges = new ArrayList();
        ArrayList newLayoutDatas = new ArrayList();
        ArrayList newActivityNodes = new ArrayList();
        ArrayList newActivityEdges = new ArrayList();
        ArrayList newComments = new ArrayList();
        for (Object object : this.elementsCopied) {
            if (object instanceof Reference) {
                newReferences.add(object);
                ((Reference)object).setContainedIn(null);
                continue;
            }
            if (object instanceof ReferenceEdge) {
                newReferenceEdges.add(object);
                ((ReferenceEdge)object).setContainedIn(null);
                continue;
            }
            if (object instanceof LayoutData) {
                newLayoutDatas.add(object);
                continue;
            }
            if (object instanceof ActivityNode) {
                newActivityNodes.add(object);
                continue;
            }
            if (object instanceof ActivityEdge) {
                newActivityEdges.add(object);
                continue;
            }
            if (!(object instanceof Comment)) continue;
            newComments.add(object);
        }
        this.addCommand = new CompoundCommand();
        for (Object x : newReferences) {
            this.addCommand.appendAndExecute(SetCommand.create((EditingDomain)this.editingDomain, x, (Object)ViewPackage.Literals.REFERENCE__CONTAINED_IN, (Object)this.newScope));
        }
        for (Object x : newReferenceEdges) {
            this.addCommand.appendAndExecute(SetCommand.create((EditingDomain)this.editingDomain, x, (Object)ViewPackage.Literals.REFERENCE_EDGE__CONTAINED_IN, (Object)this.newScope));
        }
        this.addCommand.appendAndExecute(AddCommand.create((EditingDomain)this.editingDomain, (Object)EMFHelper.getDiagram(this.weeditor), (Object)ViewPackage.Literals.DIAGRAM__LAYOUT_DATA, newLayoutDatas));
        this.addCommand.appendAndExecute(AddCommand.create((EditingDomain)this.editingDomain, (Object)EMFHelper.getDiagram(this.weeditor), (Object)ViewPackage.Literals.DIAGRAM__REFERENCES, newReferences));
        this.addCommand.appendAndExecute(AddCommand.create((EditingDomain)this.editingDomain, (Object)EMFHelper.getDiagram(this.weeditor), (Object)ViewPackage.Literals.DIAGRAM__REFERENCE_EDGES, newReferenceEdges));
        this.addCommand.appendAndExecute(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.newScope, (Object)ProcessesPackage.Literals.SCOPE__NODES, newActivityNodes));
        this.addCommand.appendAndExecute(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.newScope, (Object)ProcessesPackage.Literals.SCOPE__EDGES, newActivityEdges));
        for (Object element : this.elementsCopied) {
            if (!(element instanceof GraphicalElement)) continue;
            LayoutDataManager.setX(this.weeditor, (GraphicalElement)element, LayoutDataManager.getX(this.weeditor, (GraphicalElement)element) + this.insertPoint.x - this.minPoint.x);
            LayoutDataManager.setY(this.weeditor, (GraphicalElement)element, LayoutDataManager.getY(this.weeditor, (GraphicalElement)element) + this.insertPoint.y - this.minPoint.y);
        }
    }

    public void redo() {
        this.addCommand.redo();
    }

    public void undo() {
        this.addCommand.undo();
    }
}

