/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.meta.model.processes.StructuredActivityNode;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.layouting.CustomDirectedGraphLayoutAlgorithm;
import org.eclipse.jwt.we.misc.layouting.EdgeRelationship;
import org.eclipse.jwt.we.misc.layouting.GraphicalElementEntity;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.internal.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.model.view.LayoutData;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ReferenceEdge;
import org.eclipse.jwt.we.model.view.impl.ViewFactoryImpl;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLayoutDataCommand
extends Command {
    private static final Logger logger = Logger.getLogger(CreateLayoutDataCommand.class);
    private WEEditor weeditor;
    private HashMap layoutData;
    private Class layoutClass;
    private Set<Scope> selectedScopes;

    public CreateLayoutDataCommand(WEEditor weeditor, Set<Scope> selectedActivities, Class layoutClass) {
        this.layoutClass = layoutClass;
        this.selectedScopes = selectedActivities;
        this.weeditor = weeditor;
    }

    private GraphicalElementEntity findEntityForElement(ArrayList<GraphicalElementEntity> entities, GraphicalElement graphicalElement) {
        if (graphicalElement == null || !Views.getInstance().displayObject((EObject)graphicalElement)) {
            return null;
        }
        GraphicalElementEntity foundEntity = null;
        for (GraphicalElementEntity entity : entities) {
            if (entity.getGraphicalElement() != graphicalElement) continue;
            foundEntity = entity;
            break;
        }
        if (foundEntity == null) {
            foundEntity = new GraphicalElementEntity(this.weeditor);
            foundEntity.setGraphicalElement(graphicalElement);
            entities.add(foundEntity);
        }
        return foundEntity;
    }

    private void layoutScope(Scope scope) {
        EdgeRelationship relationship;
        GraphicalElementEntity targetEntity;
        GraphicalElementEntity sourceEntity;
        ArrayList<GraphicalElementEntity> entities = new ArrayList<GraphicalElementEntity>();
        ArrayList<EdgeRelationship> relationships = new ArrayList<EdgeRelationship>();
        for (Object object : scope.getEdges()) {
            ActivityNode sourceElement = ((ActivityEdge)object).getSource();
            ActivityNode targetElement = ((ActivityEdge)object).getTarget();
            sourceEntity = this.findEntityForElement(entities, (GraphicalElement)sourceElement);
            targetEntity = this.findEntityForElement(entities, (GraphicalElement)targetElement);
            if (sourceEntity == null || targetEntity == null) continue;
            relationship = new EdgeRelationship(sourceEntity, targetEntity);
            relationships.add(relationship);
        }
        for (ReferenceEdge refEdge : EMFHelper.getReferenceEdgesForScope(this.weeditor, scope)) {
            Action sourceAction = refEdge.getAction();
            Reference targetReference = refEdge.getReference();
            sourceEntity = this.findEntityForElement(entities, (GraphicalElement)sourceAction);
            targetEntity = this.findEntityForElement(entities, targetReference);
            if (sourceEntity == null || targetEntity == null) continue;
            relationship = new EdgeRelationship(sourceEntity, targetEntity);
            relationships.add(relationship);
        }
        LayoutEntity[] layoutEntities = new LayoutEntity[entities.size()];
        LayoutRelationship[] layoutRelationships = new LayoutRelationship[relationships.size()];
        entities.toArray(layoutEntities);
        relationships.toArray(layoutRelationships);
        for (GraphicalElementEntity entity : entities) {
            if (entity.getGraphicalElement() instanceof StructuredActivityNode) continue;
            LayoutData before = LayoutDataManager.getLayoutDataForView(this.weeditor, entity.getGraphicalElement(), Views.getInstance().getSelectedView().getInternalName());
            LayoutData after = ViewFactoryImpl.eINSTANCE.createLayoutData();
            LayoutDataManager.transferLayoutDataValues(before, after);
            this.layoutData.put(before, after);
        }
        try {
            AbstractLayoutAlgorithm selected_algorithm = (AbstractLayoutAlgorithm)this.layoutClass.getConstructor(Integer.TYPE).newInstance(1);
            CompositeLayoutAlgorithm algorithm = new CompositeLayoutAlgorithm(1, new LayoutAlgorithm[]{new CustomDirectedGraphLayoutAlgorithm(1), selected_algorithm});
            int x_size = 200;
            int y_size = 100;
            int layout_iterations = 1;
            int max_iterations = 10;
            while (layout_iterations < max_iterations) {
                algorithm.applyLayout(layoutEntities, layoutRelationships, 0.0, 0.0, (double)x_size, (double)y_size, false, false);
                boolean problem_found = false;
                LayoutRelationship[] layoutRelationshipArray = layoutRelationships;
                int n = layoutRelationships.length;
                int n2 = 0;
                while (n2 < n) {
                    LayoutRelationship layoutRelationship = layoutRelationshipArray[n2];
                    LayoutEntity sourceEntity2 = layoutRelationship.getSourceInLayout();
                    LayoutEntity targetEntity2 = layoutRelationship.getDestinationInLayout();
                    double x_dist = Math.abs(sourceEntity2.getXInLayout() + sourceEntity2.getWidthInLayout() / 2.0 - (targetEntity2.getXInLayout() + targetEntity2.getWidthInLayout() / 2.0));
                    double y_dist = Math.abs(sourceEntity2.getYInLayout() + sourceEntity2.getHeightInLayout() / 2.0 - (targetEntity2.getYInLayout() + targetEntity2.getHeightInLayout() / 2.0));
                    double x_mindist = 50.0 + sourceEntity2.getWidthInLayout() / 2.0 + targetEntity2.getWidthInLayout() / 2.0;
                    double y_mindist = 30.0 + sourceEntity2.getHeightInLayout() / 2.0 + targetEntity2.getHeightInLayout() / 2.0;
                    if (x_dist < x_mindist && y_dist < y_mindist) {
                        ++layout_iterations;
                        if (x_dist > y_dist) {
                            x_size += layout_iterations * 30;
                            y_size += layout_iterations * 10;
                        } else {
                            y_size += layout_iterations * 30;
                            x_size += layout_iterations * 10;
                        }
                        problem_found = true;
                        break;
                    }
                    ++n2;
                }
                if (problem_found) continue;
                layout_iterations = max_iterations;
            }
            if (scope instanceof StructuredActivityNode) {
                int san_width = 10;
                int san_height = 10;
                HashSet scopeChildren = new HashSet();
                TreeIterator iter = scope.eAllContents();
                while (iter.hasNext()) {
                    scopeChildren.add(iter.next());
                }
                scopeChildren.addAll(EMFHelper.getReferencesForScope(this.weeditor, scope));
                Point minPoint = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
                Point maxPoint = new Point(0, 0);
                for (Object element : scopeChildren) {
                    if (!(element instanceof GraphicalElement) || LayoutDataManager.getX(this.weeditor, (GraphicalElement)element) == 0) continue;
                    minPoint = Point.min((Point)minPoint, (Point)new Point(LayoutDataManager.getX(this.weeditor, (GraphicalElement)element), LayoutDataManager.getY(this.weeditor, (GraphicalElement)element)));
                    maxPoint = Point.max((Point)maxPoint, (Point)new Point(LayoutDataManager.getX(this.weeditor, (GraphicalElement)element) + LayoutDataManager.getWidth(this.weeditor, (GraphicalElement)element), LayoutDataManager.getY(this.weeditor, (GraphicalElement)element) + LayoutDataManager.getHeight(this.weeditor, (GraphicalElement)element)));
                }
                for (Object element : scopeChildren) {
                    if (!(element instanceof GraphicalElement)) continue;
                    LayoutDataManager.setX(this.weeditor, (GraphicalElement)element, LayoutDataManager.getX(this.weeditor, (GraphicalElement)element) - minPoint.x);
                    LayoutDataManager.setY(this.weeditor, (GraphicalElement)element, LayoutDataManager.getY(this.weeditor, (GraphicalElement)element) - minPoint.y);
                }
                for (Object ge : scopeChildren) {
                    if (!(ge instanceof GraphicalElement)) continue;
                    int ge_x = LayoutDataManager.getX(this.weeditor, (GraphicalElement)ge);
                    int ge_y = LayoutDataManager.getY(this.weeditor, (GraphicalElement)ge);
                    int ge_width = LayoutDataManager.getWidth(this.weeditor, (GraphicalElement)ge);
                    int ge_height = LayoutDataManager.getHeight(this.weeditor, (GraphicalElement)ge);
                    if (ge_x + ge_width > san_width) {
                        san_width = ge_x + ge_width;
                    }
                    if (ge_y + ge_height <= san_height) continue;
                    san_height = ge_y + ge_height;
                }
                LayoutData before = LayoutDataManager.getLayoutDataForView(this.weeditor, (GraphicalElement)((StructuredActivityNode)scope), Views.getInstance().getSelectedView().getInternalName());
                LayoutData after = ViewFactoryImpl.eINSTANCE.createLayoutData();
                LayoutDataManager.transferLayoutDataValues(before, after);
                this.layoutData.put(before, after);
                LayoutDataManager.setWidth(this.weeditor, (GraphicalElement)((StructuredActivityNode)scope), san_width + 50);
                LayoutDataManager.setHeight(this.weeditor, (GraphicalElement)((StructuredActivityNode)scope), san_height + 50);
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "could not instantiate algorithm " + this.layoutClass.toString());
        }
    }

    public void execute() {
        this.layoutData = new HashMap();
        for (Scope scope : this.selectedScopes) {
            if (!(scope instanceof StructuredActivityNode)) continue;
            this.layoutScope(scope);
        }
        for (Scope scope : this.selectedScopes) {
            if (scope instanceof StructuredActivityNode) continue;
            this.layoutScope(scope);
        }
    }

    public void redo() {
        for (Object src : this.layoutData.keySet()) {
            LayoutData source = (LayoutData)src;
            LayoutData target = (LayoutData)this.layoutData.get(src);
            LayoutData temp = ViewFactoryImpl.eINSTANCE.createLayoutData();
            LayoutDataManager.transferLayoutDataValues(source, temp);
            LayoutDataManager.transferLayoutDataValues(target, source);
            LayoutDataManager.transferLayoutDataValues(temp, target);
        }
    }

    public void undo() {
        this.redo();
    }

    public void dispose() {
        this.layoutData.clear();
        this.layoutData = null;
        this.layoutClass = null;
        this.selectedScopes.clear();
        this.selectedScopes = null;
        super.dispose();
    }
}

