/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectAllAction;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jwt.converter.Converter;
import org.eclipse.jwt.meta.commands.editDomain.JWTAdapterFactoryEditingDomain;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ProcessesFactory;
import org.eclipse.jwt.meta.providers.ResourceProviderRegistry;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.commands.editdomain.GefEmfEditingDomain;
import org.eclipse.jwt.we.commands.gefEmfAdapter.GefToEmfCommandStackAdapter;
import org.eclipse.jwt.we.editors.actions.internalActions.CopyAction;
import org.eclipse.jwt.we.editors.actions.internalActions.CutAction;
import org.eclipse.jwt.we.editors.actions.internalActions.DeleteAction;
import org.eclipse.jwt.we.editors.actions.internalActions.DirectEditAction;
import org.eclipse.jwt.we.editors.actions.internalActions.PasteAction;
import org.eclipse.jwt.we.editors.actions.internalActions.PrintAction;
import org.eclipse.jwt.we.editors.actions.internalActions.RedoAction;
import org.eclipse.jwt.we.editors.actions.internalActions.UndoAction;
import org.eclipse.jwt.we.editors.actions.managed.recentfiles.RecentFilesListManager;
import org.eclipse.jwt.we.editors.actions.managed.zoom.ZoomControl;
import org.eclipse.jwt.we.editors.internal.BindingManagerListener;
import org.eclipse.jwt.we.editors.internal.EditorPropertyUpdater;
import org.eclipse.jwt.we.editors.internal.EditorTabUpdater;
import org.eclipse.jwt.we.editors.internal.PartActivationListener;
import org.eclipse.jwt.we.editors.outline.ModelOutlinePage;
import org.eclipse.jwt.we.editors.pages.activityEditor.WEEditorSheet;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.IActivityEditor;
import org.eclipse.jwt.we.editors.pages.externalSheet.internal.WEExternalSheetManager;
import org.eclipse.jwt.we.editors.pages.overviewPage.WEOverviewSheet;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.editors.properties.extension.internal.PropertySheetPageExtensionPoint;
import org.eclipse.jwt.we.editors.selection.SelectionSynchronizer;
import org.eclipse.jwt.we.misc.extensions.externalNotificationListener.ExtensionPointNotifyChangedListener;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.providers.ProviderInstanceFactory;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.util.internal.EMFHelper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.jwt.we.model.view.impl.ViewFactoryImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class WEEditor
extends MultiPageEditorPart
implements CommandStackListener,
ISaveablePart2,
ITabbedPropertySheetPageContributor {
    private static final Logger logger = Logger.getLogger(WEEditor.class);
    private EditorPropertyUpdater editorPropertyUpdater;
    private EditorTabUpdater editorTabUpdater;
    private GefEmfEditingDomain editDomain;
    private ActionRegistry actionRegistry;
    private Resource mainModelResource;
    private Resource mainDiagramResource;
    private IPropertySheetPage propertySheetPage;
    private ModelOutlinePage outlinePage;
    private Image titleImage;
    private SelectionSynchronizer synchronizer;
    private int overviewPageID = -1;
    private PartActivationListener partActivationListener;
    private IBindingManagerListener bindingManagerListener;

    public WEEditor() {
        logger.instanceCreation();
        this.setEditDomain(new GefEmfEditingDomain((IEditorPart)this));
        GeneralHelper.registerEditor(this);
        GeneralHelper.setInitializingEditor(this);
        ResourceProviderRegistry.getInstance().setInitializingEditor((IEditorPart)this);
        ResourceProviderRegistry.getInstance().registerImageProvider((IEditorPart)this, ProviderInstanceFactory.getInstance().getDefaultImageProvider());
        ResourceProviderRegistry.getInstance().registerVisibilityProvider((IEditorPart)this, ProviderInstanceFactory.getInstance().getDefaultVisibilityProvider());
        ResourceProviderRegistry.getInstance().registerCommandProvider((IEditorPart)this, ProviderInstanceFactory.getInstance().getDefaultCommandProvider(this));
        IBindingService bindingService = (IBindingService)Plugin.getDefault().getWorkbench().getService(IBindingService.class);
        this.bindingManagerListener = new BindingManagerListener(this);
        bindingService.addBindingManagerListener(this.bindingManagerListener);
    }

    protected void createPages() {
        this.partActivationListener = new PartActivationListener(this);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.partActivationListener);
        try {
            this.createModel();
        }
        catch (Exception e) {
            logger.severe("Could not load input from " + this.getEditorInput().getName(), e);
            final WEEditor thisWE = this;
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    WEEditor.this.getSite().getPage().closeEditor((IEditorPart)thisWE, false);
                    MessageDialog.openError((Shell)WEEditor.this.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)NLS.bind((String)PluginProperties.editor_ErrorLoadingFile_message, (Object)WEEditor.this.getEditorInput().getName()));
                }
            });
            return;
        }
        this.editorPropertyUpdater = new EditorPropertyUpdater(this);
        this.editorTabUpdater = new EditorTabUpdater(this);
        this.getEditDomain().setPaletteRoot(Plugin.getInstance().getFactoryRegistry().getPaletteFactory().getPaletteRoot(this));
        Views.getInstance().refreshViewsState(this);
        boolean overviewVisible = PreferenceReader.appearanceOverviewShow.get();
        if (overviewVisible) {
            this.overviewPageID = this.addPage((Control)new WEOverviewSheet(this.getContainer(), this));
            this.getTabFolder().getItem(this.overviewPageID).setText(PluginProperties.configPage_Title);
        }
        for (String sheetTitle : WEExternalSheetManager.getInstance().getExternalSheets().keySet()) {
            IConfigurationElement point = WEExternalSheetManager.getInstance().getExternalSheets().get(sheetTitle);
            if (!point.getAttribute("autoshow").equals("true")) continue;
            WEExternalSheetManager.getInstance().displayExternalSheet(this, sheetTitle);
        }
        this.openActivityInNewPage(this.getFirstActivityModel());
        if (overviewVisible) {
            this.activatePage(this.overviewPageID);
        }
        GeneralHelper.setInitializingEditor(null);
        ResourceProviderRegistry.getInstance().setInitializingEditor(null);
    }

    public boolean activateIfAlreadyOpen(Activity newActivityModel) {
        int i = 0;
        while (i < this.getPageCount()) {
            if (this.getEditor(i) instanceof IActivityEditor && ((IActivityEditor)this.getEditor(i)).getActivityModel() == newActivityModel) {
                this.activatePage(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void openActivityInCurrentPage(Activity newActivityModel) {
        if (this.activateIfAlreadyOpen(newActivityModel)) {
            return;
        }
        if (this.getActiveEditor() instanceof IActivityEditor) {
            ((IActivityEditor)this.getActiveEditor()).loadActivityModel(newActivityModel);
            this.activatePage(this.getActivePage());
            this.setPageText(this.getActivePage(), newActivityModel.getName());
        } else {
            this.openActivityInNewPage(newActivityModel);
        }
    }

    public void openActivityInNewPage(Activity newActivityModel) {
        if (this.activateIfAlreadyOpen(newActivityModel)) {
            return;
        }
        try {
            WEEditorSheet editorSheet = new WEEditorSheet(this);
            int pageID = this.addPage((IEditorPart)editorSheet, this.getEditorInput());
            editorSheet.loadActivityModel(newActivityModel);
            this.setPageText(pageID, newActivityModel.getName());
            this.getTabFolder().getItem(pageID).setShowClose(true);
            this.activatePage(pageID);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Open Error", (String)"An error occured during opening the activity editor.", (IStatus)e.getStatus());
        }
    }

    public void removeActivityFromPage(Activity oldActivityModel) {
        int i = 0;
        while (i < this.getPageCount()) {
            if (this.getEditor(i) instanceof IActivityEditor && ((IActivityEditor)this.getEditor(i)).getActivityModel() == oldActivityModel) {
                if (i != 0) {
                    this.removePage(i);
                }
                this.activatePage(0);
            }
            ++i;
        }
    }

    public Activity getDisplayedActivityModel() {
        if (this.getActiveEditor() instanceof IActivityEditor) {
            return ((IActivityEditor)this.getActiveEditor()).getActivityModel();
        }
        return null;
    }

    public Set getOpenActivities() {
        HashSet<Activity> result = new HashSet<Activity>();
        int i = 0;
        while (i < this.getPageCount()) {
            if (this.getEditor(i) instanceof IActivityEditor) {
                result.add(((IActivityEditor)this.getEditor(i)).getActivityModel());
            }
            ++i;
        }
        return result;
    }

    public IActivityEditor getPageForActivity(Activity activity) {
        int i = 0;
        while (i < this.getPageCount()) {
            if (this.getEditor(i) instanceof IActivityEditor && ((IActivityEditor)this.getEditor(i)).getActivityModel() == activity) {
                return (IActivityEditor)this.getEditor(i);
            }
            ++i;
        }
        return null;
    }

    public WEEditorSheet getCurrentActivitySheet() {
        if (this.getActiveEditor() instanceof WEEditorSheet) {
            return (WEEditorSheet)this.getActiveEditor();
        }
        int i = 0;
        while (i < this.getPageCount()) {
            if (this.getEditor(i) instanceof IActivityEditor) {
                return (WEEditorSheet)this.getEditor(i);
            }
            ++i;
        }
        return null;
    }

    public void activatePage(int pageIndex) {
        if (this.getActivePage() != pageIndex) {
            this.setActivePage(pageIndex);
        }
        if (this.getActiveEditor() == null) {
            this.getSelectionProvider().setSelection((ISelection)new StructuredSelection(this.getModel()));
        }
        if (this.getActiveEditor() instanceof IActivityEditor) {
            this.getCurrentActivitySheet().setGridProperties();
            this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.getCurrentActivitySheet().getActivityModel()));
            this.getEditDomain().setPaletteViewer(this.getCurrentActivitySheet().getPaletteViewer());
        }
        this.refreshOutline();
        this.refreshProperties();
        this.updateTitleName();
        this.updateTitleImage();
        this.refreshZoom();
    }

    public int getActivePage() {
        return super.getActivePage();
    }

    public int getPageCount() {
        return super.getPageCount();
    }

    public IEditorPart getEditor(int pageIndex) {
        return super.getEditor(pageIndex);
    }

    public void refreshPages() {
        int i = 0;
        while (i < this.getPageCount()) {
            boolean overviewVisible;
            if (this.getEditor(i) instanceof IActivityEditor) {
                ((IActivityEditor)this.getEditor(i)).refreshEditorSheet();
            }
            if (overviewVisible = PreferenceReader.appearanceOverviewShow.get()) {
                if (this.overviewPageID == -1) {
                    this.overviewPageID = this.addPage((Control)new WEOverviewSheet(this.getContainer(), this));
                    this.getTabFolder().getItem(this.overviewPageID).setText(PluginProperties.configPage_Title);
                }
            } else if (this.overviewPageID != -1) {
                this.getTabFolder().getItem(this.overviewPageID).dispose();
                this.overviewPageID = -1;
            }
            if (this.getControl(i) instanceof WEOverviewSheet) {
                ((WEOverviewSheet)this.getControl(i)).reloadOverviewSheet();
            }
            ++i;
        }
    }

    public void refreshZoom() {
        if (this.getActiveEditor() instanceof IActivityEditor) {
            ZoomControl.getInstance().refreshZoomManager();
            ZoomControl.getInstance().enableZoom();
        } else {
            ZoomControl.getInstance().disableZoom();
        }
    }

    public void refreshProperties() {
        if (this.propertySheetPage == null) {
            return;
        }
        if (this.propertySheetPage instanceof PropertySheetPage) {
            ((PropertySheetPage)this.propertySheetPage).refresh();
        } else {
            ((TabbedPropertySheetPage)this.propertySheetPage).refresh();
        }
    }

    public void refreshPalette() {
        this.getEditDomain().setPaletteRoot(Plugin.getInstance().getFactoryRegistry().getPaletteFactory().getPaletteRoot(this));
    }

    public void refreshOutline() {
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    public static String getWorkflowExtension() {
        return PluginProperties.plugin_workflow_extension;
    }

    public static String getDiagramExtension() {
        return PluginProperties.plugin_diagram_extension;
    }

    public static String getTemplateExtension() {
        return PluginProperties.plugin_template_extension;
    }

    public Resource getMainModelResource() {
        return this.mainModelResource;
    }

    public GefEmfEditingDomain getEditDomain() {
        return this.editDomain;
    }

    protected void setEditDomain(GefEmfEditingDomain newEditDomain) {
        this.editDomain = newEditDomain;
        if (this.editDomain instanceof GefEmfEditingDomain) {
            this.editDomain.setEmfEditingDomain(this.createEmfEditingDomain());
        }
    }

    public EditingDomain getEmfEditingDomain() {
        if (this.getEditDomain() == null || !(this.getEditDomain() instanceof GefEmfEditingDomain)) {
            return null;
        }
        return this.getEditDomain().getEmfEditingDomain();
    }

    public AdapterFactory getAdapterFactory() {
        EditingDomain editingDomain = this.getEmfEditingDomain();
        if (editingDomain == null || !(editingDomain instanceof AdapterFactoryEditingDomain)) {
            return null;
        }
        return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = PropertySheetPageExtensionPoint.createPropertySheetPage(this);
        }
        return this.propertySheetPage;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public ModelOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new ModelOutlinePage(this);
        }
        return this.outlinePage;
    }

    public Object getModel() {
        if (this.mainModelResource == null) {
            return null;
        }
        return this.mainModelResource.getContents().get(0);
    }

    public Diagram getDiagramData() {
        if (this.mainDiagramResource == null || this.mainDiagramResource.getContents().size() == 0) {
            URI fileDiagramUri = this.mainModelResource.getURI().trimFileExtension().appendFileExtension(WEEditor.getDiagramExtension());
            try {
                this.mainDiagramResource = this.mainModelResource.getResourceSet().createResource(fileDiagramUri);
                Diagram diagramData = ViewFactoryImpl.eINSTANCE.createDiagram();
                diagramData.setDescribesModel((Model)this.getModel());
                this.mainDiagramResource.getContents().add((Object)diagramData);
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("ENCODING", "UTF-8");
                this.mainDiagramResource.save(options);
            }
            catch (IOException iOException) {
                logger.severe("couldn't create diagram file " + fileDiagramUri.toFileString());
            }
        }
        return (Diagram)this.mainDiagramResource.getContents().get(0);
    }

    public Activity getFirstActivityModel() {
        if (!(this.getModel() instanceof EObject)) {
            return null;
        }
        TreeIterator contents = ((EObject)this.getModel()).eAllContents();
        while (contents.hasNext()) {
            Object element = contents.next();
            if (!(element instanceof Activity)) continue;
            return (Activity)element;
        }
        Activity activity = ProcessesFactory.eINSTANCE.createActivity();
        ((Package)this.getModel()).getElements().add((Object)activity);
        activity.setName(PluginProperties.wizards_ModelWizardActivity_std);
        return activity;
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public ArrayList getGlobalActionKeys() {
        ArrayList<String> globalActionIDs = new ArrayList<String>();
        globalActionIDs.add(ActionFactory.DELETE.getId());
        globalActionIDs.add(ActionFactory.UNDO.getId());
        globalActionIDs.add(ActionFactory.REDO.getId());
        globalActionIDs.add(ActionFactory.PRINT.getId());
        globalActionIDs.add(ActionFactory.SELECT_ALL.getId());
        globalActionIDs.add(ActionFactory.CUT.getId());
        globalActionIDs.add(ActionFactory.COPY.getId());
        globalActionIDs.add(ActionFactory.PASTE.getId());
        return globalActionIDs;
    }

    public CTabFolder getTabFolder() {
        return (CTabFolder)this.getContainer();
    }

    public EditorPropertyUpdater getEditorPropertyUpdater() {
        return this.editorPropertyUpdater;
    }

    public WEOverviewSheet getOverviewSheet() {
        if (this.overviewPageID != -1) {
            return (WEOverviewSheet)this.getControl(this.overviewPageID);
        }
        return null;
    }

    public int getOverviewPageID() {
        return this.overviewPageID;
    }

    public void setPageText(int pageIndex, String text) {
        if (text == null || text.equals("")) {
            text = org.eclipse.jwt.meta.PluginProperties.model_Unnamed_name;
        }
        if (pageIndex != -1) {
            super.setPageText(pageIndex, text);
        }
    }

    public String getPageText(int pageIndex) {
        return super.getPageText(pageIndex);
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.getSelectionSynchronizer();
    }

    public IMenuListener getContextMenuProvider() {
        return (IMenuListener)this.getEditorSite().getActionBarContributor();
    }

    public Object getAdapter(Class type) {
        if (logger.isDebugEnabled()) {
            logger.debug("type = " + type.getName());
        }
        if (type == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        if (type == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (EditingDomain.class.isAssignableFrom(type)) {
            return this.getEmfEditingDomain();
        }
        if (AdapterFactory.class.isAssignableFrom(type)) {
            return this.getAdapterFactory();
        }
        if (EditPartViewer.class.isAssignableFrom(type)) {
            return this.getCurrentActivitySheet().getGraphicalViewer();
        }
        if (type == CommandStack.class) {
            return this.getEditDomain().getCommandStack();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (IMenuListener.class.isAssignableFrom(type)) {
            return this;
        }
        if (type == PalettePage.class) {
            return this.getCurrentActivitySheet().getAdapter(PalettePage.class);
        }
        if (type == EditPart.class && this.getCurrentActivitySheet().getGraphicalViewer() != null) {
            return this.getCurrentActivitySheet().getGraphicalViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getCurrentActivitySheet().getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getCurrentActivitySheet().getGraphicalViewer().getRootEditPart()).getFigure();
        }
        if (type == ZoomManager.class && this.getActiveEditor() instanceof IActivityEditor && this.getCurrentActivitySheet().getGraphicalViewer() != null) {
            return this.getCurrentActivitySheet().getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(type);
    }

    public EditingDomain createEmfEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        adapterFactory.addListener((INotifyChangedListener)new ExtensionPointNotifyChangedListener());
        return new JWTAdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (org.eclipse.emf.common.command.CommandStack)new GefToEmfCommandStackAdapter(this.editDomain.getCommandStack()));
    }

    public void createModel() throws Exception {
        URI resourceUri = null;
        if (this.getEditorInput() instanceof IFileEditorInput) {
            String fileName = ((IFileEditorInput)this.getEditorInput()).getFile().getFullPath().toString();
            resourceUri = URI.createPlatformResourceURI((String)fileName, (boolean)true);
        } else if (this.getEditorInput() instanceof FileStoreEditorInput) {
            resourceUri = URI.createFileURI((String)((FileStoreEditorInput)this.getEditorInput()).getURI().getPath());
        } else if (this.getEditorInput() instanceof IPathEditorInput) {
            resourceUri = URI.createFileURI((String)((IPathEditorInput)this.getEditorInput()).getPath().toPortableString());
        } else if (this.getEditorInput() instanceof URIEditorInput) {
            resourceUri = ((URIEditorInput)this.getEditorInput()).getURI();
        }
        URI viewURI = resourceUri.trimFileExtension().appendFileExtension(WEEditor.getDiagramExtension());
        try {
            Converter.updateModel((URI)resourceUri, (String)GeneralHelper.getWEVersion(), (!GeneralHelper.isPluginMode() ? 1 : 0) != 0);
            this.mainModelResource = this.getEmfEditingDomain().getResourceSet().getResource(resourceUri, true);
        }
        catch (Exception e) {
            Throwable actualException;
            Throwable throwable = actualException = e instanceof WrappedException ? e.getCause() : e;
            if (actualException instanceof PackageNotFoundException) {
                PackageNotFoundException packageNotFoundException = (PackageNotFoundException)actualException;
                logger.severe("Could not load input from " + this.getEditorInput().getName(), e);
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.incomplete_jwt_extension_conf_title, (String)NLS.bind((String)PluginProperties.incomplete_jwt_extension_conf_details, (Object)this.getEditorInput().getName(), (Object)packageNotFoundException.uri()));
                throw e;
            }
            if (actualException instanceof ClassNotFoundException) {
                ClassNotFoundException classNotFoundException = (ClassNotFoundException)actualException;
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.incorrect_metamodel_extension_definition_title, (String)NLS.bind((String)PluginProperties.incorrect_metamodel_extension_definition_details, (Object[])new Object[]{this.getEditorInput().getName(), classNotFoundException.getName(), classNotFoundException.getFactory().getEPackage().getNsURI()}));
                throw e;
            }
            throw e;
        }
        try {
            this.mainDiagramResource = this.getEmfEditingDomain().getResourceSet().getResource(viewURI, true);
        }
        catch (Exception exception) {
            this.getDiagramData();
        }
        EMFHelper.correctReferences(this, false);
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        registry.registerAction((IAction)new CopyAction(this.getEmfEditingDomain(), this.getSelectionProvider()));
        registry.registerAction((IAction)new CutAction(this.getEmfEditingDomain(), this.getSelectionProvider()));
        registry.registerAction((IAction)new DeleteAction(this.getEmfEditingDomain(), this.getSelectionProvider()));
        registry.registerAction((IAction)new PasteAction(this.getEmfEditingDomain(), this.getSelectionProvider()));
        registry.registerAction((IAction)new PrintAction((IWorkbenchPart)this));
        registry.registerAction((IAction)new RedoAction((IEditorPart)this));
        registry.registerAction((IAction)new UndoAction((IEditorPart)this));
        registry.registerAction((IAction)new SelectAllAction((IWorkbenchPart)this));
        registry.registerAction((IAction)new DirectEditAction((IWorkbenchPart)this, this.getSelectionProvider()));
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 258) {
                    if (WEEditor.this.getEditorInput() instanceof URIEditorInput) {
                        if (((URIEditorInput)WEEditor.this.getEditorInput()).getURI().toFileString() != null) {
                            RecentFilesListManager.getInstance().setNewFile(((URIEditorInput)WEEditor.this.getEditorInput()).getURI().toFileString());
                        } else {
                            RecentFilesListManager.getInstance().setNewFile(((URIEditorInput)WEEditor.this.getEditorInput()).getURI().toString());
                        }
                    } else {
                        RecentFilesListManager.getInstance().setNewFile(URI.createURI((String)WEEditor.this.getEditorInput().getName()).toFileString());
                    }
                }
            }
        });
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(input);
        this.getEditDomain().getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getSelectionSynchronizer());
        this.initializeActionRegistry();
    }

    protected void initializeActionRegistry() {
        this.createActions();
    }

    public boolean isDirty() {
        return this.getEditDomain().getCommandStack().isDirty();
    }

    public String getNameofProcess() {
        if (this.mainModelResource == null || this.getDisplayedActivityModel() == null) {
            return null;
        }
        String pathtoprocess = this.mainModelResource.getURI().devicePath();
        pathtoprocess = pathtoprocess.replaceAll("%20", " ");
        String path = String.valueOf(pathtoprocess) + "#" + this.getDisplayedActivityModel().getName();
        return path;
    }

    public void doSave(IProgressMonitor monitor) {
        logger.enter();
        try {
            EMFHelper.cleanViewData(this);
            EMFHelper.correctReferences(this, true);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            this.mainModelResource.save(options);
            this.mainDiagramResource.save(options);
            this.getEditDomain().getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            logger.severe("Error saving file " + this.getEditorInput().getName() + ".", e);
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)NLS.bind((String)PluginProperties.editor_ErrorSavingFile_message, (Object)this.getEditorInput().getName()));
        }
        if (this.getOverviewSheet() != null) {
            this.getOverviewSheet().reloadFileInformation();
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void doSaveAsInternal(IProgressMonitor monitor, String file) {
        logger.enter();
        EMFHelper.cleanViewData(this);
        EMFHelper.correctReferences(this, true);
        try {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            this.mainModelResource.setURI(URI.createFileURI((String)file));
            this.mainModelResource.save(options);
            this.mainDiagramResource.setURI(this.mainModelResource.getURI().trimFileExtension().appendFileExtension(WEEditor.getDiagramExtension()));
            this.mainDiagramResource.save(options);
            this.getEditDomain().getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            logger.severe("Error saving file " + this.getEditorInput().getName() + ".", e);
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)NLS.bind((String)PluginProperties.editor_ErrorSavingFile_message, (Object)this.getEditorInput().getName()));
        }
        this.getOverviewSheet().reloadFileInformation();
        monitor.done();
    }

    public void doSaveAs() {
        File file;
        logger.enter();
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        FileDialog fd = new FileDialog(shell, 8192);
        String selectedfile = null;
        try {
            fd.setFileName(this.getEditorInput().getName());
            fd.setFilterExtensions(new String[]{"*." + WEEditor.getWorkflowExtension()});
            selectedfile = fd.open();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (selectedfile == null) {
            return;
        }
        Path path = new Path(selectedfile);
        File file2 = file = path != null ? path.toFile() : null;
        if (file == null) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)NLS.bind((String)PluginProperties.editor_ErrorSavingFile_message, (Object)selectedfile));
            return;
        }
        IWorkbenchPage workbenchPage = Plugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = workbenchPage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            String openFileName = "";
            try {
                openFileName = editorReference.getEditorInput() instanceof URIEditorInput ? ((URIEditorInput)editorReference.getEditorInput()).getURI().toFileString() : (editorReference.getEditorInput() instanceof FileStoreEditorInput ? URI.createFileURI((String)((FileStoreEditorInput)editorReference.getEditorInput()).getURI().getPath()).toFileString() : editorReference.getEditorInput().getName());
            }
            catch (PartInitException partInitException) {}
            if (openFileName.equals(selectedfile)) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)NLS.bind((String)PluginProperties.editor_ErrorCurrentlyOpen_message, (Object)selectedfile));
                return;
            }
            ++n2;
        }
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_QuestionOverwriteFile_title, (String)NLS.bind((String)PluginProperties.editor_QuestionOverwriteFile_message, (Object)selectedfile))) {
            return;
        }
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation((IPath)path){
                private final /* synthetic */ IPath val$path;
                {
                    this.val$path = iPath;
                }

                public void execute(IProgressMonitor monitor) {
                    String pathtofile = this.val$path.makeAbsolute().toFile().getAbsolutePath();
                    WEEditor.this.doSaveAsInternal(monitor, pathtofile);
                    WEEditor.this.setInputWithNotify((IEditorInput)new URIEditorInput(WEEditor.this.mainModelResource.getURI()));
                }
            };
            new ProgressMonitorDialog(shell).run(false, false, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException ie) {
            logger.warning(ie);
        }
        catch (InvocationTargetException ite) {
            logger.warning(ite);
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)PluginProperties.editor_ErrorMessage_title, (String)NLS.bind((String)PluginProperties.editor_ErrorSavingFile_message, (Object)selectedfile));
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        final IPropertySheetPage localPropertySheetPage = this.propertySheetPage;
        if (localPropertySheetPage != null) {
            this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (localPropertySheetPage.getControl() != null && !localPropertySheetPage.getControl().isDisposed()) {
                        if (localPropertySheetPage instanceof PropertySheetPage) {
                            ((PropertySheetPage)localPropertySheetPage).refresh();
                        } else if (localPropertySheetPage != null && ((TabbedPropertySheetPage)localPropertySheetPage).getCurrentTab() != null) {
                            ((TabbedPropertySheetPage)localPropertySheetPage).refresh();
                        }
                    }
                }
            });
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(manager);
    }

    public void updateTitleName() {
        String newTitle = this.getActiveEditor() instanceof IActivityEditor ? this.getDisplayedActivityModel().getName() : this.getTabFolder().getItem(this.getActivePage()).getText();
        if (newTitle == null || newTitle.length() == 0) {
            newTitle = org.eclipse.jwt.meta.PluginProperties.model_Unnamed_name((Object)this.getDisplayedActivityModel());
        }
        this.setPartName(PluginProperties.editor_Title_text(newTitle, this.getEditorInput().getName()));
    }

    public void updateTitleImage() {
        ImageDescriptor titleImageDescriptor;
        IItemLabelProvider itemLabelProvider;
        this.titleImage = null;
        Activity activity = this.getDisplayedActivityModel();
        if (activity != null && (itemLabelProvider = (IItemLabelProvider)this.getAdapterFactory().adapt((Notifier)activity, IItemLabelProvider.class)) != null && (titleImageDescriptor = (ImageDescriptor)itemLabelProvider.getImage((Object)activity)) != null) {
            this.titleImage = Plugin.getDefault().getFactoryRegistry().getImageFactory(new Object[0]).getImage(titleImageDescriptor);
        }
        if (this.titleImage == null) {
            this.titleImage = Plugin.getDefault().getFactoryRegistry().getImageFactory(new Object[0]).getImage(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor(PluginProperties.model_Activity_icon));
        }
        this.setTitleImage(this.titleImage);
    }

    public int promptToSaveOnClose() {
        String title = PluginProperties.editor_Closing_title;
        String message = NLS.bind((String)PluginProperties.editor_Closing_message, (Object)this.getEditorInput().getName());
        String yes = PluginProperties.editor_Yes_message;
        String no = PluginProperties.editor_No_message;
        String cancel = PluginProperties.editor_Cancel_message;
        return new MessageDialog(this.getEditorSite().getShell(), title, null, message, 2, new String[]{yes, no, cancel}, 0).open();
    }

    public void dispose() {
        super.dispose();
        if (this.partActivationListener != null) {
            this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.partActivationListener);
            this.partActivationListener = null;
        }
        if (this.editorPropertyUpdater != null) {
            this.editorPropertyUpdater.dispose();
        }
        if (this.editorTabUpdater != null) {
            this.editorTabUpdater.dispose();
        }
        if (this.bindingManagerListener != null) {
            IBindingService bindingService = (IBindingService)Plugin.getDefault().getWorkbench().getService(IBindingService.class);
            bindingService.removeBindingManagerListener(this.bindingManagerListener);
            this.bindingManagerListener = null;
        }
        this.getEditDomain().getCommandStack().removeCommandStackListener((CommandStackListener)this);
        this.getSite().setSelectionProvider(null);
        this.getEditDomain().setActiveTool(null);
        this.getActionRegistry().dispose();
        ((ComposedAdapterFactory)this.getAdapterFactory()).dispose();
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
            this.propertySheetPage = null;
        }
        if (this.titleImage != null) {
            this.titleImage = null;
        }
        this.setEditDomain(null);
        ResourceProviderRegistry.getInstance().deregisterImageProvider((IEditorPart)this);
        ResourceProviderRegistry.getInstance().deregisterVisibilityProvider((IEditorPart)this);
        ResourceProviderRegistry.getInstance().deregisterCommandProvider((IEditorPart)this);
        GeneralHelper.deregisterEditor(this);
        GeneralHelper.setInitializingEditor(null);
        ResourceProviderRegistry.getInstance().setInitializingEditor(null);
    }
}

