/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.actions.handlers;

import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.actions.WEActionHandler;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.util.SaveImage;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class SaveImageHandler
extends WEActionHandler {
    public SaveImageHandler() {
        super(true);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (GeneralHelper.getActiveInstance() != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && ((IStructuredSelection)selection).getFirstElement() == GeneralHelper.getActiveInstance().getDisplayedActivityModel()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        GraphicalViewer viewer = GeneralHelper.getActiveInstance().getCurrentActivitySheet().getGraphicalViewer();
        String[] filterExtensions = new String[]{"*.png", "*.jpg", "*.bmp"};
        FileDialog filedialog = new FileDialog(GeneralHelper.getActiveShell(), 8192);
        filedialog.setFilterExtensions(filterExtensions);
        String filepath = "";
        boolean fileDoesExist = false;
        do {
            if ((filepath = filedialog.open()) == null || !new File(filepath).exists()) continue;
            boolean bl = fileDoesExist = !MessageDialog.openQuestion((Shell)GeneralHelper.getActiveShell(), (String)PluginProperties.dialog_overwrite_title, (String)PluginProperties.dialog_overwrite_message);
        } while (filepath != null && fileDoesExist);
        if (filepath != null) {
            if (filepath.endsWith(".jpg")) {
                SaveImage.save(viewer, filepath, 4);
            } else if (filepath.endsWith(".bmp")) {
                SaveImage.save(viewer, filepath, 0);
            } else {
                SaveImage.save(viewer, filepath, 5);
            }
        }
        return null;
    }
}

