/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.pages.activityEditor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.dnd.IDropListenerFactory;
import org.eclipse.jwt.we.editors.dnd.internal.DropListenerExtensionPoint;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.CustomGraphicalEditorWithFlyoutPalette;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.CustomTemplateTransferDropTargetListener;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.IActivityEditor;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.WEMouseMoveTrackListener;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.editors.selection.EditPartViewerSelectionConverter;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class WEEditorSheet
extends CustomGraphicalEditorWithFlyoutPalette
implements IActivityEditor {
    private static final Logger logger = Logger.getLogger(WEEditorSheet.class);
    private WEEditor parentEditor;
    private Activity activityModel;
    private PaletteViewer paletteViewer;
    private ScalableFreeformRootEditPart rootEditPart;

    public WEEditorSheet(WEEditor parent) {
        this.parentEditor = parent;
        this.setEditDomain(parent.getEditDomain());
    }

    protected PaletteRoot getPaletteRoot() {
        return Plugin.getInstance().getFactoryRegistry().getPaletteFactory().getPaletteRoot(this.parentEditor);
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    public Activity getActivityModel() {
        return this.activityModel;
    }

    public ScalableFreeformRootEditPart getRootEditPart() {
        return this.rootEditPart;
    }

    public PaletteViewer getPaletteViewer() {
        return this.paletteViewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.paletteViewer = this.getEditDomain().getPaletteViewer();
    }

    protected void hookGraphicalViewer() {
        this.parentEditor.getSelectionSynchronizer().setSelection((ISelection)new StructuredSelection());
        this.parentEditor.getSelectionSynchronizer().addSelectionProvider((ISelectionProvider)this.getGraphicalViewer(), new EditPartViewerSelectionConverter((EditPartViewer)this.getGraphicalViewer()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().getControl().setBackground(PreferenceReader.appearanceEditorColor.get());
        this.getGraphicalViewer().setEditPartFactory(Plugin.getInstance().getFactoryRegistry().getEditPartFactory());
        this.rootEditPart = new ScalableFreeformRootEditPart();
        this.getGraphicalViewer().setRootEditPart((RootEditPart)this.rootEditPart);
        this.getGraphicalViewer().setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(this.getGraphicalViewer()));
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(this.parentEditor.getContextMenuProvider());
        this.getGraphicalViewer().setContextMenu(contextMenu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.getGraphicalViewer());
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.addDropTargetListener((TransferDropTargetListener)new CustomTemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        this.getRootEditPart().getZoomManager().setZoomLevelContributions(zoomLevels);
        if (PreferenceReader.appearanceMousePosShow.get()) {
            this.getGraphicalViewer().getControl().addMouseMoveListener((MouseMoveListener)WEMouseMoveTrackListener.getInstance());
            this.getGraphicalViewer().getControl().addMouseTrackListener((MouseTrackListener)WEMouseMoveTrackListener.getInstance());
        }
    }

    protected void initializeActionRegistry() {
    }

    public void setGridProperties() {
        if (this.getGraphicalViewer() != null) {
            int gridWidth = PreferenceReader.gridWidth.get();
            int gridHeight = PreferenceReader.gridHeight.get();
            boolean gridVisible = PreferenceReader.gridVisible.get();
            boolean gridSnap = PreferenceReader.gridSnap.get();
            this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(gridWidth, gridHeight));
            this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)gridVisible);
            this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)gridSnap);
            this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)gridSnap);
        }
    }

    public void loadActivityModel(Activity newActivityModel) {
        logger.enter();
        try {
            this.parentEditor.getModel().getClass();
        }
        catch (Exception e) {
            String message = PluginProperties.editor_ErrorLoadingFile_message(this.getEditorInput().getName());
            logger.severe("Could not load input from " + this.getEditorInput().getName(), e);
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)message, (String)e.getMessage());
            return;
        }
        if (newActivityModel == null) {
            newActivityModel = this.parentEditor.getFirstActivityModel();
        }
        if (this.getActivityModel() == newActivityModel) {
            this.refreshEditorSheet();
            return;
        }
        this.parentEditor.getEditorPropertyUpdater().removeUpdateListener(this.getActivityModel());
        this.parentEditor.getEditorPropertyUpdater().addUpdateListener(newActivityModel);
        this.activityModel = newActivityModel;
        this.getGraphicalViewer().setContents((Object)this.getActivityModel());
        this.parentEditor.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.getActivityModel()));
        GraphicalViewer viewer = this.getGraphicalViewer();
        for (IDropListenerFactory dropFactory : DropListenerExtensionPoint.getDropListenersFactories()) {
            org.eclipse.jface.util.TransferDropTargetListener dropListener = dropFactory.createWEEditorSheetDropListener(this, this.getActivityModel());
            if (dropListener == null) continue;
            viewer.addDropTargetListener(dropListener);
        }
    }

    public void refreshEditorSheet() {
        if (this.getActivityModel() != null) {
            GraphicalViewer gv = this.getGraphicalViewer();
            gv.setContents(null);
            gv.setContents((Object)this.getActivityModel());
            this.getGraphicalViewer().getControl().removeMouseMoveListener((MouseMoveListener)WEMouseMoveTrackListener.getInstance());
            this.getGraphicalViewer().getControl().removeMouseTrackListener((MouseTrackListener)WEMouseMoveTrackListener.getInstance());
            if (PreferenceReader.appearanceMousePosShow.get()) {
                this.getGraphicalViewer().getControl().addMouseMoveListener((MouseMoveListener)WEMouseMoveTrackListener.getInstance());
                this.getGraphicalViewer().getControl().addMouseTrackListener((MouseTrackListener)WEMouseMoveTrackListener.getInstance());
            }
            this.getGraphicalViewer().getControl().setBackground(PreferenceReader.appearanceEditorColor.get());
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void doSave(IProgressMonitor monitor) {
        this.parentEditor.doSave(monitor);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        return this.parentEditor.isDirty();
    }

    public int absoluteToRelativeX(int x) {
        int baseX = 0;
        Control control = this.getGraphicalControl();
        while (control != null) {
            baseX += control.getLocation().x;
            control = control.getParent();
        }
        return x - baseX;
    }

    public int absoluteToRelativeY(int y) {
        int baseY = 0;
        Control control = this.getGraphicalControl();
        while (control != null) {
            baseY += control.getLocation().y;
            control = control.getParent();
        }
        return y - baseY;
    }

    public void dispose() {
        this.getGraphicalViewer().deselectAll();
        this.getGraphicalViewer().setContents(null);
        this.paletteViewer = null;
        if (this.parentEditor != null) {
            this.parentEditor.getSelectionSynchronizer().removeSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
            this.parentEditor.getEditorPropertyUpdater().removeUpdateListener(this.getActivityModel());
        }
        if (this.getGraphicalViewer().getControl() != null) {
            this.getGraphicalViewer().getControl().removeMouseMoveListener((MouseMoveListener)WEMouseMoveTrackListener.getInstance());
            this.getGraphicalViewer().getControl().removeMouseTrackListener((MouseTrackListener)WEMouseMoveTrackListener.getInstance());
        }
        if (this.rootEditPart != null) {
            this.rootEditPart.deactivate();
            this.rootEditPart = null;
        }
        this.activityModel = null;
        super.dispose();
    }
}

