/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.palette;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.meta.model.application.Application;
import org.eclipse.jwt.meta.model.application.ApplicationPackage;
import org.eclipse.jwt.meta.model.application.WebServiceApplication;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.core.PackageableElement;
import org.eclipse.jwt.meta.model.core.ReferenceableElement;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.data.DataPackage;
import org.eclipse.jwt.meta.model.events.Event;
import org.eclipse.jwt.meta.model.events.EventsPackage;
import org.eclipse.jwt.meta.model.organisations.OrganisationsPackage;
import org.eclipse.jwt.meta.model.organisations.Role;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.figures.internal.ImageFactory;
import org.eclipse.jwt.we.figures.internal.ScalingImageDescriptor;
import org.eclipse.jwt.we.misc.factories.CreateReferenceFactory;
import org.eclipse.jwt.we.misc.factories.EcoreCopyFactory;
import org.eclipse.jwt.we.misc.factories.EcoreFactory;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ViewPackage;
import org.eclipse.swt.graphics.Image;

public class Palette
extends PaletteRoot
implements Adapter {
    private WEEditor weeditor;
    public static final Class[] PALETTE_DYNAMIC_GROUPS = new Class[]{Activity.class, Application.class, WebServiceApplication.class, Role.class, Data.class, Event.class};
    private List<EObject> dynamicelements = new ArrayList<EObject>();
    public static final Dimension ICON_SMALL_SIZE = ImageFactory.MODEL_TYPE_IMAGE_SIZE;
    public static final Dimension ICON_LARGE_SIZE = new Dimension(24, 24);
    private static final Logger logger = Logger.getLogger(Palette.class);
    private ResourceSet resourceSet;
    private AdapterFactory adapterFactory;
    private PaletteGroup toolGroup = null;
    private PaletteDrawer activityGroup = null;
    private PaletteDrawer packageableElementsGroup = null;

    public Palette(WEEditor weeditor, ResourceSet resourceSet, AdapterFactory adapterFactory) {
        this.createStaticGroups();
        this.setAdapterFactory(adapterFactory);
        this.setResourceSet(resourceSet);
        this.weeditor = weeditor;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setResourceSet(ResourceSet newResourceSet) {
        if (this.resourceSet == newResourceSet) {
            return;
        }
        if (this.resourceSet != null) {
            this.resourceSet.eAdapters().remove((Object)this);
        }
        this.resourceSet = newResourceSet;
        this.resourceSet.eAdapters().add((Object)this);
        Iterator i = this.resourceSet.getResources().iterator();
        while (i.hasNext()) {
            this.addResource((Resource)i.next());
        }
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    private String getId(EObject model) {
        if (model == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer(model.getClass().getName());
        EClass eClass = model.eClass();
        if (eClass.getInstanceClassName() == null) {
            result.append('/');
            result.append(eClass.getEPackage().getNsURI());
            result.append('#');
            result.append(eClass.getName());
        }
        result.append('@');
        result.append(Integer.toHexString(model.hashCode()));
        return result.toString();
    }

    private PaletteContainer getDynamicGroup(Class modelType) {
        boolean valid = false;
        Class[] classArray = PALETTE_DYNAMIC_GROUPS;
        int n = PALETTE_DYNAMIC_GROUPS.length;
        int n2 = 0;
        while (n2 < n) {
            Class group = classArray[n2];
            if (modelType == group) {
                valid = true;
                break;
            }
            ++n2;
        }
        if (!valid) {
            return null;
        }
        return this;
    }

    private PaletteContainer getPackageEntry(PaletteContainer dynamicGroup, Package packageModel) {
        if (dynamicGroup == null) {
            return null;
        }
        String id = this.getId((EObject)packageModel);
        for (Object entry : dynamicGroup.getChildren()) {
            PaletteContainer container;
            if (!(entry instanceof PaletteContainer) || !id.equals((container = (PaletteContainer)entry).getId())) continue;
            return container;
        }
        return null;
    }

    private PaletteEntry getDynamicModelEntry(PaletteContainer packageEntry, EObject model) {
        if (packageEntry == null) {
            return null;
        }
        String id = this.getId(model);
        for (PaletteEntry entry : packageEntry.getChildren()) {
            if (!id.equals(entry.getId())) continue;
            return entry;
        }
        return null;
    }

    public void refreshDynamicGroups() {
        try {
            ArrayList<EObject> buffer = new ArrayList<EObject>();
            for (EObject eb : this.dynamicelements) {
                buffer.add(eb);
            }
            for (EObject eb : buffer) {
                Package p = this.getPackage(eb);
                this.removeModel(eb, p);
            }
            for (EObject eb : buffer) {
                this.addModel(eb);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void createStaticGroups() {
        if (this.toolGroup == null) {
            this.toolGroup = new PaletteGroup(PluginProperties.palette_ToolsGroup_name);
            PanningSelectionToolEntry tool = new PanningSelectionToolEntry();
            this.toolGroup.add((PaletteEntry)tool);
            this.setDefaultEntry((ToolEntry)tool);
            this.toolGroup.add((PaletteEntry)new MarqueeToolEntry());
        }
        if (this.activityGroup == null) {
            this.activityGroup = new PaletteDrawer(PluginProperties.palette_ActivityElementsGroups_name);
        }
        this.activityGroup.getChildren().clear();
        this.addPaletteDrawer(this.activityGroup, ProcessesPackage.Literals.ACTION);
        this.addPaletteDrawer(this.activityGroup, ProcessesPackage.Literals.INITIAL_NODE);
        this.addPaletteDrawer(this.activityGroup, ProcessesPackage.Literals.FINAL_NODE);
        this.addPaletteDrawer(this.activityGroup, EventsPackage.Literals.EVENT);
        this.addPaletteDrawer(this.activityGroup, ProcessesPackage.Literals.FORK_NODE);
        this.addPaletteDrawer(this.activityGroup, ProcessesPackage.Literals.JOIN_NODE);
        this.addPaletteDrawer(this.activityGroup, ProcessesPackage.Literals.DECISION_NODE);
        this.addPaletteDrawer(this.activityGroup, ProcessesPackage.Literals.MERGE_NODE);
        this.addPaletteDrawer(this.activityGroup, ProcessesPackage.Literals.GUARD);
        this.activityGroup.add((PaletteEntry)new PaletteSeparator());
        this.addPaletteDrawer(this.activityGroup, ProcessesPackage.Literals.STRUCTURED_ACTIVITY_NODE);
        this.addPaletteDrawer(this.activityGroup, ProcessesPackage.Literals.ACTIVITY_LINK_NODE);
        this.activityGroup.add((PaletteEntry)new PaletteSeparator());
        this.addPaletteConnectionDrawer(this.activityGroup, ProcessesPackage.Literals.ACTIVITY_EDGE);
        this.addPaletteConnectionDrawer(this.activityGroup, ViewPackage.Literals.REFERENCE_EDGE);
        if (this.packageableElementsGroup == null) {
            this.packageableElementsGroup = new PaletteDrawer(PluginProperties.palette_PackageableElementsGroups_name);
            this.packageableElementsGroup.setInitialState(1);
        }
        this.packageableElementsGroup.getChildren().clear();
        this.addPaletteDrawer(this.packageableElementsGroup, ApplicationPackage.Literals.APPLICATION);
        this.addPaletteDrawer(this.packageableElementsGroup, ApplicationPackage.Literals.WEB_SERVICE_APPLICATION);
        this.addPaletteDrawer(this.packageableElementsGroup, OrganisationsPackage.Literals.ROLE);
        this.addPaletteDrawer(this.packageableElementsGroup, DataPackage.Literals.DATA);
        this.packageableElementsGroup.add((PaletteEntry)new PaletteSeparator());
        this.remove((PaletteEntry)this.toolGroup);
        this.remove((PaletteEntry)this.activityGroup);
        this.remove((PaletteEntry)this.packageableElementsGroup);
        this.add((PaletteEntry)this.toolGroup);
        this.add((PaletteEntry)this.activityGroup);
        this.add((PaletteEntry)this.packageableElementsGroup);
    }

    private void addPaletteDrawer(PaletteDrawer pd, EClass obj) {
        if (Views.getInstance().displayObject((EObject)obj)) {
            pd.add((PaletteEntry)this.createCreationToolEntry(obj));
        }
    }

    private void addPaletteConnectionDrawer(PaletteDrawer pd, EClass obj) {
        if (Views.getInstance().displayObject((EObject)obj)) {
            pd.add((PaletteEntry)this.createConnectionCreationToolEntry(obj));
        }
    }

    private void addResource(Resource resource) {
        resource.eAdapters().add((Object)this);
        Iterator i = resource.getContents().iterator();
        while (i.hasNext()) {
            this.addModel((EObject)i.next());
        }
    }

    private void removeResource(Resource resource) {
        resource.eAdapters().remove((Object)this);
        Iterator i = resource.getContents().iterator();
        while (i.hasNext()) {
            this.removeModel((EObject)i.next(), null);
        }
    }

    private void addModel(EObject model) {
        if (model == null || !Views.getInstance().displayObject(model)) {
            return;
        }
        PaletteContainer group = this.getDynamicGroup(model.eClass().getInstanceClass());
        if (!this.dynamicelements.contains(model)) {
            this.dynamicelements.add(model);
        }
        if (group != null) {
            Package packageModel = this.getPackage(model);
            PaletteContainer packageEntry = this.getPackageEntry(group, packageModel);
            if (packageEntry == null) {
                packageEntry = this.createPackageEntry(packageModel);
                group.add((PaletteEntry)packageEntry);
            }
            ToolEntry te = this.createAddToolEntry(model);
            if (this.getDynamicModelEntry(packageEntry, model) == null) {
                packageEntry.add((PaletteEntry)te);
                Class<?> teClass = null;
                teClass = ((CreationFactory)((CombinedTemplateCreationEntry)te).getTemplate()).getObjectType() == Reference.class ? ((Reference)((CreationFactory)((CombinedTemplateCreationEntry)te).getTemplate()).getNewObject()).getReference().getClass() : (Class<?>)((CreationFactory)((CombinedTemplateCreationEntry)te).getTemplate()).getObjectType();
                int i = packageEntry.getChildren().size() - 2;
                while (i >= 0) {
                    Class<?> currentClass = null;
                    currentClass = ((CreationFactory)((CombinedTemplateCreationEntry)packageEntry.getChildren().get(i)).getTemplate()).getObjectType() == Reference.class ? ((Reference)((CreationFactory)((CombinedTemplateCreationEntry)packageEntry.getChildren().get(i)).getTemplate()).getNewObject()).getReference().getClass() : (Class<?>)((CreationFactory)((CombinedTemplateCreationEntry)packageEntry.getChildren().get(i)).getTemplate()).getObjectType();
                    if (currentClass == teClass) {
                        int j = packageEntry.getChildren().size() - 1;
                        while (j > i + 1) {
                            packageEntry.moveUp((PaletteEntry)te);
                            --j;
                        }
                        break;
                    }
                    --i;
                }
            }
        }
        model.eAdapters().add((Object)this);
        if (!model.eAdapters().contains((Object)this)) {
            model.eAdapters().add((Object)this);
        }
        Iterator i = model.eContents().iterator();
        while (i.hasNext()) {
            this.addModel((EObject)i.next());
        }
    }

    private void removeModel(EObject model, Package oldPackage) {
        Package packageModel;
        PaletteContainer packageEntry;
        PaletteContainer group;
        if (model == null) {
            return;
        }
        if (this.dynamicelements.contains(model)) {
            this.dynamicelements.remove(model);
        }
        if ((group = this.getDynamicGroup(model.eClass().getInstanceClass())) != null && (packageEntry = this.getPackageEntry(group, packageModel = oldPackage == null ? this.getPackage(model) : oldPackage)) != null) {
            packageEntry.remove(this.getDynamicModelEntry(packageEntry, model));
            if (packageEntry.getChildren().isEmpty()) {
                group.remove((PaletteEntry)packageEntry);
            }
        }
        model.eAdapters().remove((Object)this);
        Iterator i = model.eContents().iterator();
        while (i.hasNext()) {
            this.removeModel((EObject)i.next(), null);
        }
    }

    private void updateModel(EObject model) {
        if (model == null) {
            return;
        }
        PaletteContainer group = this.getDynamicGroup(model.eClass().getInstanceClass());
        if (group != null) {
            Package packageModel = this.getPackage(model);
            PaletteContainer packageEntry = this.getPackageEntry(group, packageModel);
            PaletteEntry dynamicModelEntry = this.getDynamicModelEntry(packageEntry, model);
            if (packageEntry != null && dynamicModelEntry != null) {
                this.updatePackageEntry(packageEntry, packageModel);
                this.updateAddToolEntry(dynamicModelEntry, model);
            }
        }
        Iterator i = model.eContents().iterator();
        while (i.hasNext()) {
            this.updateModel((EObject)i.next());
        }
    }

    private PaletteContainer createPackageEntry(Package packageModel) {
        PaletteDrawer packageEntry = new PaletteDrawer("");
        packageEntry.setId(this.getId((EObject)packageModel));
        packageEntry.setInitialState(1);
        this.updatePackageEntry((PaletteContainer)packageEntry, packageModel);
        return packageEntry;
    }

    private void updatePackageEntry(PaletteContainer packageEntry, Package packageModel) {
        ScalingImageDescriptor smallIcon = null;
        ScalingImageDescriptor largeIcon = null;
        if (this.adapterFactory.isFactoryForType(IItemLabelProvider.class) && packageModel != null) {
            IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)packageModel, IItemLabelProvider.class);
            smallIcon = new ScalingImageDescriptor((ImageDescriptor)labelProvider.getImage((Object)packageModel), ICON_SMALL_SIZE);
            largeIcon = new ScalingImageDescriptor((ImageDescriptor)labelProvider.getImage((Object)packageModel), ICON_LARGE_SIZE);
            if (!this.createsValidImage(smallIcon)) {
                smallIcon = null;
            }
            if (!this.createsValidImage(largeIcon)) {
                largeIcon = null;
            }
        }
        packageEntry.setLabel(this.getPackageName(packageModel));
        packageEntry.setSmallIcon(smallIcon);
        packageEntry.setLargeIcon(largeIcon);
    }

    public ToolEntry createCreationToolEntry(EClass modelType) {
        EcoreFactory factory = new EcoreFactory(modelType);
        ImageDescriptor smallIcon = Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor(PluginProperties.model_smallIcon(modelType));
        smallIcon = new ScalingImageDescriptor(smallIcon, ICON_SMALL_SIZE);
        ImageDescriptor largeIcon = Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor(PluginProperties.model_smallIcon(modelType));
        largeIcon = new ScalingImageDescriptor(largeIcon, ICON_LARGE_SIZE);
        if (!this.createsValidImage(smallIcon)) {
            smallIcon = null;
        }
        if (!this.createsValidImage(largeIcon)) {
            largeIcon = null;
        }
        return new CombinedTemplateCreationEntry(PluginProperties.palette_CreationEntry_name(modelType), PluginProperties.palette_CreationEntry_description(modelType), (Object)factory, (CreationFactory)factory, smallIcon, largeIcon);
    }

    public ToolEntry createConnectionCreationToolEntry(EClass modelType) {
        EcoreFactory factory = new EcoreFactory(modelType);
        return new ConnectionCreationToolEntry(PluginProperties.palette_CreationEntry_name(modelType), PluginProperties.palette_CreationEntry_description(modelType), (CreationFactory)factory, Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor(PluginProperties.model_smallIcon(modelType)), Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor(PluginProperties.model_largeIcon(modelType)));
    }

    public ToolEntry createAddToolEntry(EObject modelElement) {
        CombinedTemplateCreationEntry entry = new CombinedTemplateCreationEntry(null, null, null, null, null, null);
        entry.setId(this.getId(modelElement));
        this.updateAddToolEntry((PaletteEntry)entry, modelElement);
        return entry;
    }

    private void updateAddToolEntry(PaletteEntry paletteEntry, EObject modelElement) {
        CombinedTemplateCreationEntry creationEntry = (CombinedTemplateCreationEntry)paletteEntry;
        Object factory = null;
        factory = modelElement instanceof ReferenceableElement ? new CreateReferenceFactory((ReferenceableElement)modelElement) : new EcoreCopyFactory(this.weeditor, modelElement);
        String name = null;
        ScalingImageDescriptor smallIcon = null;
        ScalingImageDescriptor largeIcon = null;
        if (this.adapterFactory.isFactoryForType(IItemLabelProvider.class)) {
            IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)modelElement, IItemLabelProvider.class);
            name = labelProvider.getText((Object)modelElement);
            smallIcon = new ScalingImageDescriptor((ImageDescriptor)labelProvider.getImage((Object)modelElement), ICON_SMALL_SIZE);
            largeIcon = new ScalingImageDescriptor((ImageDescriptor)labelProvider.getImage((Object)modelElement), ICON_LARGE_SIZE);
            if (!this.createsValidImage(smallIcon)) {
                smallIcon = null;
            }
            if (!this.createsValidImage(largeIcon)) {
                largeIcon = null;
            }
        }
        if (name == null) {
            name = org.eclipse.jwt.meta.PluginProperties.model_Unnamed_name((Object)modelElement);
        }
        creationEntry.setLabel(name);
        creationEntry.setDescription(PluginProperties.palette_DynamicEntry_description(name, modelElement));
        creationEntry.setSmallIcon(smallIcon);
        creationEntry.setLargeIcon(largeIcon);
        creationEntry.setToolProperty(CreationTool.PROPERTY_CREATION_FACTORY, factory);
        creationEntry.setTemplate(factory);
    }

    private Package getPackage(EObject model) {
        Package packageModel = null;
        if (model instanceof PackageableElement) {
            packageModel = ((PackageableElement)model).getPackage();
        } else {
            EObject container = model.eContainer();
            if (container != null && container instanceof PackageableElement) {
                packageModel = ((PackageableElement)container).getPackage();
            }
        }
        return packageModel;
    }

    /*
     * Unable to fully structure code
     */
    private String getPackageName(Package element) {
        block3: {
            result = new StringBuffer();
            if (element != null) ** GOTO lbl15
            result.append(org.eclipse.jwt.meta.PluginProperties.model_DefaultPackage_name);
            break block3;
lbl-1000:
            // 1 sources

            {
                packageName = element.getName();
                if (packageName == null || packageName.length() == 0) {
                    packageName = org.eclipse.jwt.meta.PluginProperties.model_Unnamed_name((Object)element);
                }
                if (result.length() != 0) {
                    result.insert(0, org.eclipse.jwt.meta.PluginProperties.model_PackageName_separator);
                }
                result.insert(0, packageName);
                element = element.getSuperpackage();
lbl15:
                // 2 sources

                ** while (element != null)
            }
        }
        return result.toString();
    }

    public boolean createsValidImage(ImageDescriptor imageDescriptor) {
        boolean result = false;
        Image image = Plugin.getDefault().getFactoryRegistry().getImageFactory(new Object[0]).getImage(imageDescriptor);
        if (image != null) {
            result = true;
        }
        return result;
    }

    public void notifyChanged(Notification notification) {
        block26: {
            try {
                if (notification.getNotifier() == this.resourceSet) {
                    if (notification.getFeatureID(ResourceSet.class) == 0) {
                        switch (notification.getEventType()) {
                            case 3: {
                                this.addResource((Resource)notification.getNewValue());
                                break;
                            }
                            case 4: {
                                this.removeResource((Resource)notification.getOldValue());
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    break block26;
                }
                if (notification.getNotifier() instanceof Resource) {
                    if (notification.getFeatureID(Resource.class) == 2) {
                        switch (notification.getEventType()) {
                            case 3: {
                                this.addModel((EObject)notification.getNewValue());
                                break;
                            }
                            case 4: {
                                this.removeModel((EObject)notification.getOldValue(), null);
                                break;
                            }
                            case 5: 
                            case 6: {
                                throw new IllegalStateException("Event type not implemented.");
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    break block26;
                }
                if (!(notification.getNotifier() instanceof EObject)) break block26;
                switch (notification.getEventType()) {
                    case 3: {
                        EObject newValue = (EObject)notification.getNewValue();
                        if (((EObject)notification.getNotifier()).eContents().contains((Object)newValue)) {
                            this.addModel(newValue);
                        }
                        break;
                    }
                    case 4: {
                        this.removeModel((EObject)notification.getOldValue(), null);
                        break;
                    }
                    case 1: 
                    case 2: {
                        EObject model = (EObject)notification.getNotifier();
                        if (notification.getNotifier() instanceof PackageableElement && notification.getFeatureID(PackageableElement.class) == 3) {
                            this.removeModel(model, (Package)notification.getOldValue());
                            this.addModel(model);
                        }
                        this.updateModel(model);
                        break;
                    }
                    case 5: {
                        Object value = notification.getNewValue();
                        Iterator i = ((Iterable)value).iterator();
                        while (i.hasNext()) {
                            this.addModel((EObject)i.next());
                        }
                        break;
                    }
                    case 6: {
                        Object value = notification.getOldValue();
                        Iterator i = ((Iterable)value).iterator();
                        while (i.hasNext()) {
                            this.removeModel((EObject)i.next(), null);
                        }
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.warning(e);
            }
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }
}

