/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jwt.meta.model.core.Comment;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.commands.view.CreateLayoutDataCommand;
import org.eclipse.jwt.we.commands.view.ImportLayoutDataCommand;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.util.internal.EMFHelper;
import org.eclipse.jwt.we.misc.views.ViewDescriptor;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.misc.wizards.view.ViewConfWizard;
import org.eclipse.jwt.we.model.view.LayoutData;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.impl.ViewFactoryImpl;
import org.eclipse.ui.PlatformUI;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutDataManager {
    public static String VIEW_LAYOUTDATA_DIALOG = "view_layoutdata_dialog";
    public static String VIEW_LAYOUTDATA_WIZARD = "view_layoutdata_wizard";
    public static String VIEW_LAYOUTDATA_LAYOUT = "view_layoutdata_layout";
    public static String VIEW_LAYOUTDATA_IMPORT = "view_layoutdata_import";
    public static String VIEW_LAYOUTDATA_NOTHING = "view_layoutdata_nothing";

    public static void setX(WEEditor weeditor, GraphicalElement graphicalelement, int x) {
        LayoutDataManager.getLayoutData(weeditor, graphicalelement).setX(x);
        LayoutDataManager.getLayoutData(weeditor, graphicalelement).setInitialized(true);
    }

    public static void setY(WEEditor weeditor, GraphicalElement graphicalelement, int y) {
        LayoutDataManager.getLayoutData(weeditor, graphicalelement).setY(y);
        LayoutDataManager.getLayoutData(weeditor, graphicalelement).setInitialized(true);
    }

    public static void setWidth(WEEditor weeditor, GraphicalElement graphicalelement, int width) {
        LayoutDataManager.getLayoutData(weeditor, graphicalelement).setWidth(width);
        LayoutDataManager.getLayoutData(weeditor, graphicalelement).setInitialized(true);
    }

    public static void setHeight(WEEditor weeditor, GraphicalElement graphicalelement, int height) {
        LayoutDataManager.getLayoutData(weeditor, graphicalelement).setHeight(height);
        LayoutDataManager.getLayoutData(weeditor, graphicalelement).setInitialized(true);
    }

    public static int getX(WEEditor weeditor, GraphicalElement graphicalelement) {
        return LayoutDataManager.getLayoutData(weeditor, graphicalelement).getX();
    }

    public static int getY(WEEditor weeditor, GraphicalElement graphicalelement) {
        return LayoutDataManager.getLayoutData(weeditor, graphicalelement).getY();
    }

    public static int getWidth(WEEditor weeditor, GraphicalElement graphicalelement) {
        return LayoutDataManager.getLayoutData(weeditor, graphicalelement).getWidth();
    }

    public static int getHeight(WEEditor weeditor, GraphicalElement graphicalelement) {
        return LayoutDataManager.getLayoutData(weeditor, graphicalelement).getHeight();
    }

    public static void setLayoutData(WEEditor weeditor, GraphicalElement graphicalelement, LayoutData layoutData) {
        LayoutData layoutDataPresent = LayoutDataManager.findLayoutDataForView(weeditor, graphicalelement, layoutData.getViewid());
        LayoutDataManager.transferLayoutDataValues(layoutData, layoutDataPresent);
    }

    public static LayoutData getLayoutData(WEEditor weeditor, GraphicalElement graphicalelement) {
        LayoutData layoutData = LayoutDataManager.getLayoutDataForView(weeditor, graphicalelement, Views.getInstance().getSelectedView().getInternalName());
        weeditor.getAdapterFactory().adapt((Notifier)layoutData, IItemLabelProvider.class);
        return layoutData;
    }

    public static Collection getAllContainedLayoutDatas(WEEditor weeditor, Collection collection) {
        ArrayList<LayoutData> result = new ArrayList<LayoutData>();
        for (Object object : collection) {
            if (object instanceof GraphicalElement) {
                result.addAll((Collection<LayoutData>)LayoutDataManager.getLayoutDataForGraphicalElement(weeditor, (GraphicalElement)object));
            }
            if (!(object instanceof EObject) || ((EObject)object).eContents() == null) continue;
            result.addAll(LayoutDataManager.getAllContainedLayoutDatas(weeditor, (Collection)((EObject)object).eContents()));
        }
        return result;
    }

    public static LayoutData getLayoutDataForView(WEEditor weeditor, GraphicalElement graphicalelement, String viewID) {
        LayoutData layoutDataPresent = LayoutDataManager.findLayoutDataForView(weeditor, graphicalelement, viewID);
        if (layoutDataPresent != null) {
            return layoutDataPresent;
        }
        LayoutData newLayoutData = ViewFactoryImpl.eINSTANCE.createLayoutData();
        newLayoutData.setDescribesElement(graphicalelement);
        newLayoutData.setViewid(viewID);
        EMFHelper.getDiagram(weeditor).getLayoutData().add((Object)newLayoutData);
        return newLayoutData;
    }

    private static LayoutData findLayoutDataForView(WEEditor weeditor, GraphicalElement graphicalelement, String viewID) {
        if (graphicalelement == null) {
            return null;
        }
        viewID = viewID.toLowerCase();
        for (Object layoutData : LayoutDataManager.getLayoutDataForGraphicalElement(weeditor, graphicalelement)) {
            String viewIDld = ((LayoutData)layoutData).getViewid().toLowerCase();
            if (!viewIDld.equals(viewID)) continue;
            return (LayoutData)layoutData;
        }
        return null;
    }

    public static EList<LayoutData> getLayoutDataForGraphicalElement(WEEditor weeditor, GraphicalElement graphicalElement) {
        BasicEList layoutDatas = new BasicEList();
        for (Object layoutData : EMFHelper.getDiagram(weeditor).getLayoutData()) {
            if (((LayoutData)layoutData).getDescribesElement() == null || !((LayoutData)layoutData).getDescribesElement().equals(graphicalElement)) continue;
            layoutDatas.add((Object)((LayoutData)layoutData));
        }
        return layoutDatas;
    }

    public static void importLayoutData(WEEditor weeditor, Set<Scope> selectedScopes, String src_viewID, String dest_viewID, boolean onlyNew) {
        if (src_viewID.equals(dest_viewID)) {
            return;
        }
        weeditor.getEditDomain().getCommandStack().execute((Command)new ImportLayoutDataCommand(weeditor, selectedScopes, src_viewID, dest_viewID, onlyNew));
    }

    public static void createLayoutData(WEEditor weeditor, Set<Scope> selectedScopes, Class layoutClass) {
        weeditor.getEditDomain().getCommandStack().execute((Command)new CreateLayoutDataCommand(weeditor, selectedScopes, layoutClass));
    }

    public static void transferLayoutDataValues(LayoutData src_LayoutData, LayoutData dest_LayoutData) {
        dest_LayoutData.setX(src_LayoutData.getX());
        dest_LayoutData.setY(src_LayoutData.getY());
        dest_LayoutData.setWidth(src_LayoutData.getWidth());
        dest_LayoutData.setHeight(src_LayoutData.getHeight());
        dest_LayoutData.setInitialized(src_LayoutData.isInitialized());
    }

    public static void uninitializedLayoutDataCheck(WEEditor weeditor) {
        TreeIterator iter;
        if (PreferenceReader.viewLayoutData.get().equals(VIEW_LAYOUTDATA_NOTHING)) {
            return;
        }
        HashSet<GraphicalElement> uninitializedElements = new HashSet<GraphicalElement>();
        HashSet<EObject> initializedElements = new HashSet<EObject>();
        TreeIterator iter2 = EcoreUtil.getAllContents((EObject)((EObject)weeditor.getModel()), (boolean)true);
        while (iter2.hasNext()) {
            EObject eobject = (EObject)iter2.next();
            if (!(eobject instanceof GraphicalElement) || eobject instanceof Comment || !Views.getInstance().displayObject(eobject)) continue;
            if (!LayoutDataManager.getLayoutData(weeditor, (GraphicalElement)eobject).isInitialized()) {
                uninitializedElements.add((GraphicalElement)eobject);
                continue;
            }
            initializedElements.add(eobject);
        }
        for (EObject eobject : weeditor.getDiagramData().getReferences()) {
            if (!Views.getInstance().displayObject(eobject)) continue;
            if (!LayoutDataManager.getLayoutData(weeditor, (GraphicalElement)eobject).isInitialized()) {
                uninitializedElements.add((GraphicalElement)eobject);
                continue;
            }
            initializedElements.add(eobject);
        }
        if (uninitializedElements.size() == 0) {
            return;
        }
        if (PreferenceReader.viewLayoutData.get().equals(VIEW_LAYOUTDATA_WIZARD)) {
            ViewConfWizard wizard = new ViewConfWizard();
            wizard.init(PlatformUI.getWorkbench(), null);
            WizardDialog wizardDialog = new WizardDialog(GeneralHelper.getActiveShell(), (IWizard)wizard);
            wizardDialog.open();
        } else if (PreferenceReader.viewLayoutData.get().equals(VIEW_LAYOUTDATA_IMPORT)) {
            HashSet<Scope> activities = new HashSet<Scope>();
            iter = EcoreUtil.getAllContents((EObject)((EObject)weeditor.getModel()), (boolean)true);
            while (iter.hasNext()) {
                EObject eobject = (EObject)iter.next();
                if (!(eobject instanceof Scope)) continue;
                activities.add((Scope)eobject);
            }
            LayoutDataManager.importLayoutData(weeditor, activities, LayoutDataManager.computeBestView(weeditor), Views.getInstance().getSelectedView().getInternalName(), true);
        } else if (PreferenceReader.viewLayoutData.get().equals(VIEW_LAYOUTDATA_LAYOUT)) {
            HashSet<Scope> scopes = new HashSet<Scope>();
            iter = EcoreUtil.getAllContents((EObject)((EObject)weeditor.getModel()), (boolean)true);
            while (iter.hasNext()) {
                EObject eobject = (EObject)iter.next();
                if (!(eobject instanceof Scope)) continue;
                boolean scopeUninitialized = true;
                TreeIterator iter22 = EcoreUtil.getAllContents((EObject)((Scope)eobject), (boolean)true);
                while (iter22.hasNext()) {
                    EObject containedObject = (EObject)iter22.next();
                    if (!initializedElements.contains(containedObject)) continue;
                    scopeUninitialized = false;
                    break;
                }
                for (EObject containedObject : EMFHelper.getReferencesForScope(weeditor, (Scope)eobject)) {
                    if (!initializedElements.contains(containedObject)) continue;
                    scopeUninitialized = false;
                    break;
                }
                if (!scopeUninitialized) continue;
                scopes.add((Scope)eobject);
            }
            weeditor.getEditDomain().getCommandStack().execute((Command)new CreateLayoutDataCommand(weeditor, scopes, SpringLayoutAlgorithm.class));
        } else if (PreferenceReader.viewLayoutData.get().equals(VIEW_LAYOUTDATA_DIALOG)) {
            String bestViewID = LayoutDataManager.computeBestView(weeditor);
            if (!bestViewID.equals(Views.getInstance().getSelectedView().getInternalName())) {
                String bestViewNameID = bestViewID;
                for (ViewDescriptor viewdescriptor : Views.getInstance().getAvailableViews()) {
                    if (!bestViewID.equals(viewdescriptor.getInternalName())) continue;
                    bestViewNameID = viewdescriptor.getOfficialName();
                }
                int answer = new MessageDialog(GeneralHelper.getActiveShell(), PluginProperties.view_LayoutData_label, null, PluginProperties.bind((String)PluginProperties.view_NoLayoutData_label, (Object)bestViewNameID), 3, new String[]{PluginProperties.view_NoLayoutDataWizard_label, PluginProperties.bind((String)PluginProperties.view_NoLayoutDataImport_label, (Object)bestViewNameID), PluginProperties.view_NoLayoutDataNothing_label, PluginProperties.view_NoLayoutDataDeactivate_label}, 0).open();
                if (answer == 0) {
                    ViewConfWizard wizard = new ViewConfWizard();
                    wizard.init(PlatformUI.getWorkbench(), null);
                    WizardDialog wizardDialog = new WizardDialog(GeneralHelper.getActiveShell(), (IWizard)wizard);
                    wizardDialog.open();
                } else if (answer == 1) {
                    HashSet<Scope> activities = new HashSet<Scope>();
                    TreeIterator iter3 = EcoreUtil.getAllContents((EObject)((EObject)weeditor.getModel()), (boolean)true);
                    while (iter3.hasNext()) {
                        EObject eobject = (EObject)iter3.next();
                        if (!(eobject instanceof Scope)) continue;
                        activities.add((Scope)eobject);
                    }
                    LayoutDataManager.importLayoutData(weeditor, activities, bestViewID, Views.getInstance().getSelectedView().getInternalName(), true);
                } else if (answer == 3) {
                    PreferenceReader.viewLayoutData.set(VIEW_LAYOUTDATA_NOTHING);
                }
            } else {
                int answer = new MessageDialog(GeneralHelper.getActiveShell(), PluginProperties.view_LayoutData_label, null, PluginProperties.view_NoLayoutData2_label, 3, new String[]{PluginProperties.view_NoLayoutDataWizard_label, PluginProperties.view_NoLayoutDataNothing_label, PluginProperties.view_NoLayoutDataDeactivate_label}, 0).open();
                if (answer == 0) {
                    ViewConfWizard wizard = new ViewConfWizard();
                    wizard.init(PlatformUI.getWorkbench(), null);
                    WizardDialog wizardDialog = new WizardDialog(GeneralHelper.getActiveShell(), (IWizard)wizard);
                    wizardDialog.open();
                } else if (answer == 2) {
                    PreferenceReader.viewLayoutData.set(VIEW_LAYOUTDATA_NOTHING);
                }
            }
        }
    }

    public static HashMap computeViewScore(WEEditor weeditor) {
        HashMap<String, Integer> viewDefinitionIndex = new HashMap<String, Integer>();
        ArrayList<GraphicalElement> graphicalElements = new ArrayList<GraphicalElement>();
        TreeIterator iter = EcoreUtil.getAllContents((EObject)((EObject)weeditor.getModel()), (boolean)true);
        while (iter.hasNext()) {
            EObject eobject = (EObject)iter.next();
            if (!(eobject instanceof GraphicalElement)) continue;
            graphicalElements.add((GraphicalElement)eobject);
            LayoutDataManager.getLayoutData(weeditor, (GraphicalElement)eobject);
        }
        for (Reference reference : weeditor.getDiagramData().getReferences()) {
            graphicalElements.add(reference);
            LayoutDataManager.getLayoutData(weeditor, reference);
        }
        for (GraphicalElement graphicalElement : graphicalElements) {
            for (Object layoutData : LayoutDataManager.getLayoutDataForGraphicalElement(weeditor, graphicalElement)) {
                String viewid = ((LayoutData)layoutData).getViewid().toLowerCase();
                if (LayoutDataManager.getLayoutData(weeditor, graphicalElement).isInitialized() || !((LayoutData)layoutData).isInitialized() || !Views.getInstance().displayObject((EObject)graphicalElement)) continue;
                if (viewDefinitionIndex.get(viewid) == null) {
                    viewDefinitionIndex.put(viewid, new Integer(1));
                    continue;
                }
                viewDefinitionIndex.put(viewid, (Integer)viewDefinitionIndex.get(viewid) + 1);
            }
        }
        return viewDefinitionIndex;
    }

    public static String computeBestView(WEEditor weeditor) {
        HashMap viewDefinitionIndex = LayoutDataManager.computeViewScore(weeditor);
        if (viewDefinitionIndex.isEmpty()) {
            return Views.getInstance().getSelectedView().getInternalName();
        }
        String bestViewID = viewDefinitionIndex.keySet().iterator().next().toString();
        for (Object viewID : viewDefinitionIndex.keySet()) {
            if ((Integer)viewDefinitionIndex.get((String)viewID) <= (Integer)viewDefinitionIndex.get(bestViewID)) continue;
            bestViewID = (String)viewID;
        }
        if ((Integer)viewDefinitionIndex.get(bestViewID) == 0) {
            return Views.getInstance().getSelectedView().getInternalName();
        }
        return bestViewID;
    }

    public static void removeLayoutData(WEEditor weeditor, EObject eobject, String viewID) {
        ArrayList<GraphicalElement> graphicalelements = new ArrayList<GraphicalElement>();
        if (eobject instanceof GraphicalElement) {
            graphicalelements.add((GraphicalElement)eobject);
        }
        if (eobject.eContents() != null && eobject.eContents().size() > 0) {
            TreeIterator iter = EcoreUtil.getAllContents((EObject)eobject, (boolean)true);
            while (iter.hasNext()) {
                EObject object = (EObject)iter.next();
                if (!(object instanceof GraphicalElement)) continue;
                graphicalelements.add((GraphicalElement)object);
            }
        }
        viewID = viewID.toLowerCase();
        for (GraphicalElement graphicalelement : graphicalelements) {
            if (!(graphicalelement instanceof GraphicalElement)) continue;
            ArrayList<LayoutData> layoutdatas = new ArrayList<LayoutData>();
            for (Object lD : LayoutDataManager.getLayoutDataForGraphicalElement(weeditor, graphicalelement)) {
                layoutdatas.add((LayoutData)lD);
            }
            for (Object lD : layoutdatas) {
                String viewIDld = lD.getViewid().toLowerCase();
                if (viewIDld.equals(viewID)) continue;
                lD.setDescribesElement(null);
                EMFHelper.getDiagram(weeditor).getLayoutData().remove(lD);
            }
        }
    }
}

