/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.template.exp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.core.impl.CorePackageImpl;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ActivityLinkNode;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.actions.handlers.TemplateHandler;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.util.internal.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.misc.wizards.WizardHelper;
import org.eclipse.jwt.we.misc.wizards.template.TemplateFilter;
import org.eclipse.jwt.we.misc.wizards.template.exp.ExportTemplateCopier;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportTemplateWizardPage
extends WizardPage {
    static final Logger logger = Logger.getLogger(ExportTemplateWizardPage.class);
    protected Text templateField;
    private Button commentCheckbox;
    protected CheckboxTreeViewer packageViewer;

    public ExportTemplateWizardPage(String pageId, IWorkbench workbench) {
        super(pageId);
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)GeneralHelper.getActiveInstance().getAdapter(EditingDomain.class);
    }

    public AdapterFactory getAdapterFactory() {
        return (AdapterFactory)GeneralHelper.getActiveInstance().getAdapter(AdapterFactory.class);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        composite.setLayoutData((Object)WizardHelper.createData(4, 4, true, false, -1, -1));
        Tree packageTree = new Tree(composite, 32);
        packageTree.setLayoutData((Object)WizardHelper.createData(4, 4, true, true, -1, 5));
        final XMIResourceImpl xmires = this.getEditingDomain().getResourceSet().getResources().get(0) instanceof XMIResourceImpl ? (XMIResourceImpl)this.getEditingDomain().getResourceSet().getResources().get(0) : null;
        final ContainerCheckedTreeViewer packageViewer = new ContainerCheckedTreeViewer(packageTree);
        packageViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        packageViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.getAdapterFactory()));
        packageViewer.setInput(((Resource)this.getEditingDomain().getResourceSet().getResources().get(0)).getContents().get(0));
        if (xmires != null) {
            packageViewer.setGrayed((Object)xmires, true);
        }
        packageViewer.addFilter((ViewerFilter)new TemplateFilter());
        this.packageViewer = packageViewer;
        packageViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportTemplateWizardPage.this.checkXMI(event.getElement(), xmires);
                ExportTemplateWizardPage.this.setPageComplete(ExportTemplateWizardPage.this.validatePage());
            }
        });
        this.commentCheckbox = new Button(composite, 32);
        this.commentCheckbox.setText(PluginProperties.wizards_ExportComments_label);
        this.commentCheckbox.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 3));
        this.commentCheckbox.setSelection(true);
        Button expandButton = new Button(composite, 8);
        expandButton.setLayoutData((Object)WizardHelper.createData(-1, 3, false, false, -1, 1));
        expandButton.setImage(Plugin.getDefault().getFactoryRegistry().getImageFactory(new Object[0]).getImage(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor("menu_expandall.gif")));
        expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                packageViewer.expandAll();
            }
        });
        Button collapseButton = new Button(composite, 8);
        collapseButton.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 1));
        collapseButton.setImage(Plugin.getDefault().getFactoryRegistry().getImageFactory(new Object[0]).getImage(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor("menu_collapseall.gif")));
        collapseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                packageViewer.expandAll();
                packageViewer.collapseAll();
            }
        });
        Label dummyLabel = new Label(composite, 16384);
        dummyLabel.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, -1, 5));
        Label templateLabel = new Label(composite, 131072);
        templateLabel.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 1));
        templateLabel.setText(PluginProperties.wizards_ExportTemplate_label);
        this.templateField = new Text(composite, 2048);
        this.templateField.setLayoutData((Object)WizardHelper.createData(-1, 4, false, true, -1, 2));
        this.templateField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportTemplateWizardPage.this.setPageComplete(ExportTemplateWizardPage.this.validatePage());
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setLayoutData((Object)WizardHelper.createData(-1, 3, false, false, -1, 2));
        browseButton.setText(PluginProperties.wizards_Browse_label);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String fileExtension = WEEditor.getTemplateExtension();
                String fileExtensionName = PluginProperties.wizards_Files_templatefiles;
                String filePath = TemplateHandler.saveFilePathDialog(ExportTemplateWizardPage.this.getShell(), fileExtension, fileExtensionName, 8192);
                if (filePath != null) {
                    if (!filePath.endsWith("." + fileExtension)) {
                        filePath = String.valueOf(filePath) + "." + fileExtension;
                    }
                    ExportTemplateWizardPage.this.templateField.setText(filePath);
                }
            }
        });
        this.setPageComplete(this.validatePage());
        this.setMessage(null);
        this.setControl((Control)composite);
        this.getShell().pack();
        packageViewer.refresh();
        packageViewer.expandAll();
        packageViewer.collapseAll();
        packageViewer.expandToLevel(2);
        WizardHelper.resizeDialog(this.getShell());
    }

    protected void checkXMI(Object element, XMIResourceImpl xmires) {
        if (element instanceof XMIResourceImpl) {
            this.packageViewer.setGrayed((Object)xmires, true);
        } else if (xmires != null) {
            this.packageViewer.setGrayed((Object)xmires, true);
        }
    }

    public boolean validatePage() {
        if (this.getContainer().getCurrentPage() != this) {
            return false;
        }
        URI fileURI = this.getFileURI();
        if (fileURI == null || fileURI.isEmpty()) {
            this.setMessage(PluginProperties.wizards_ExportFilename_error);
            return false;
        }
        if (this.packageViewer.getCheckedElements().length < 1) {
            this.setMessage(PluginProperties.wizards_ExportChecked_error);
            return false;
        }
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.templateField.setFocus();
        }
    }

    public void selectFileField() {
        this.templateField.selectAll();
        this.templateField.setFocus();
    }

    public URI getFileURI() {
        try {
            return URI.createFileURI((String)this.templateField.getText());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection<EObject> getResources() {
        HashSet<Object> originalElements = new HashSet<Object>();
        originalElements.add((EObject)GeneralHelper.getActiveInstance().getModel());
        originalElements.add(GeneralHelper.getActiveInstance().getDiagramData());
        Object[] checkedelements = this.packageViewer.getCheckedElements();
        int i = 0;
        while (i < checkedelements.length) {
            if (checkedelements[i] instanceof EObject) {
                originalElements.add((EObject)checkedelements[i]);
            }
            ++i;
        }
        HashSet<Object> activityChildren = new HashSet<Object>();
        for (EObject eObject : originalElements) {
            if (!(eObject instanceof Activity)) continue;
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)eObject, (boolean)true);
            while (iterator.hasNext()) {
                EObject child = (EObject)iterator.next();
                activityChildren.add(child);
                if (!(child instanceof GraphicalElement)) continue;
                activityChildren.addAll((Collection<Object>)LayoutDataManager.getLayoutDataForGraphicalElement(GeneralHelper.getActiveInstance(), (GraphicalElement)child));
            }
            activityChildren.addAll((Collection<Object>)EMFHelper.getReferenceEdgesForScope(GeneralHelper.getActiveInstance(), (Scope)((Activity)eObject)));
            EList<Reference> references = EMFHelper.getReferencesForScope(GeneralHelper.getActiveInstance(), (Scope)((Activity)eObject));
            activityChildren.addAll((Collection<Object>)references);
            for (Iterator reference : references) {
                activityChildren.addAll((Collection<Object>)LayoutDataManager.getLayoutDataForGraphicalElement(GeneralHelper.getActiveInstance(), (GraphicalElement)reference));
            }
        }
        originalElements.addAll(activityChildren);
        ArrayList<EClass> arrayList = new ArrayList<EClass>();
        if (!this.commentCheckbox.getSelection()) {
            arrayList.add(CorePackageImpl.eINSTANCE.getComment());
        }
        HashSet<Object> tempList = originalElements;
        originalElements = new HashSet();
        for (EObject eobject : tempList) {
            boolean keepElement = true;
            for (EClass eclass : arrayList) {
                if (!eobject.eClass().equals(eclass)) continue;
                keepElement = false;
            }
            if (!keepElement) continue;
            originalElements.add(eobject);
        }
        boolean refElemsAdded = false;
        for (EObject eobject : activityChildren) {
            if (!(eobject instanceof Reference) || ((Reference)eobject).getReference() == null || originalElements.contains(((Reference)eobject).getReference())) continue;
            originalElements.add(((Reference)eobject).getReference());
            EObject refElemContainer = ((Reference)eobject).getReference().eContainer();
            while (refElemContainer != null && !originalElements.contains(refElemContainer)) {
                originalElements.add(refElemContainer);
                refElemContainer = refElemContainer.eContainer();
            }
            refElemsAdded = true;
        }
        try {
            ExportTemplateCopier copier = new ExportTemplateCopier(true, false);
            Collection result = copier.copyAll(originalElements);
            copier.copyReferences();
            for (Object object : result) {
                EObject eobject = (EObject)object;
                if (!(eobject instanceof ActivityLinkNode) || result.contains(((ActivityLinkNode)eobject).getLinksto())) continue;
                ((ActivityLinkNode)eobject).setLinksto(null);
                ((ActivityLinkNode)eobject).setName("<" + ((ActivityLinkNode)eobject).getName() + ">");
            }
            if (refElemsAdded) {
                MessageDialog.openInformation((Shell)GeneralHelper.getActiveShell(), (String)PluginProperties.editor_WizardExportRefAdded_title, (String)PluginProperties.editor_WizardExportRefAdded_description);
            }
            copier = null;
            return result;
        }
        catch (Exception e) {
            logger.warning("Could not create copy of selected elements.", e);
            return null;
        }
    }

    public void dispose() {
        this.packageViewer = null;
        this.templateField.dispose();
        this.commentCheckbox.dispose();
        super.dispose();
    }
}

