/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.binutils.Activator;
import org.eclipse.linuxtools.binutils.utils.STAddr2LineFactory;
import org.eclipse.linuxtools.binutils.utils.STCPPFiltFactory;

public class STSymbolManager {
    private static final long AUTO_DISPOSE_TIMEOUT = 30000L;
    public static final STSymbolManager sharedInstance = new STSymbolManager();
    private final HashMap<IBinaryParser.IBinaryObject, AutoDisposeAddr2line> addr2lines = new HashMap();
    private final HashMap<String, AutoDisposeCPPFilt> cppfilts = new HashMap();

    private STSymbolManager() {
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        STSymbolManager.this.cleanup();
                    }
                }
                catch (Exception _) {
                    Status s = new Status(4, "org.eclipse.linuxtools.binutils", _.getMessage(), (Throwable)_);
                    Activator.getDefault().getLog().log((IStatus)s);
                }
            }
        };
        new Thread(worker, "ST System Analysis Symbol Manager").start();
    }

    private synchronized void cleanup() {
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<IBinaryParser.IBinaryObject, AutoDisposeAddr2line>> iter = this.addr2lines.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<IBinaryParser.IBinaryObject, AutoDisposeAddr2line> entry = iter.next();
            AutoDisposeAddr2line ada2l = entry.getValue();
            long diff = currentTime - ada2l.startTime;
            if (diff <= 30000L) continue;
            ada2l.addr2line.dispose();
            ada2l.addr2line = null;
            iter.remove();
        }
        Iterator<Map.Entry<String, AutoDisposeCPPFilt>> iter2 = this.cppfilts.entrySet().iterator();
        while (iter2.hasNext()) {
            Map.Entry<String, AutoDisposeCPPFilt> entry = iter2.next();
            AutoDisposeCPPFilt adcppf = entry.getValue();
            long diff = currentTime - adcppf.startTime;
            if (diff <= 30000L) continue;
            if (adcppf.cppfilt != null) {
                adcppf.cppfilt.dispose();
                adcppf.cppfilt = null;
            }
            iter2.remove();
        }
    }

    public synchronized String demangle(IBinaryParser.ISymbol symbol) {
        String cpu = symbol.getBinaryObject().getCPU();
        String symbolName = symbol.getName();
        return this.demangleImpl(symbolName, cpu);
    }

    public synchronized String demangle(IBinaryParser.IBinaryObject program, String symbolName) {
        String cpu = program.getCPU();
        return this.demangleImpl(symbolName, cpu);
    }

    private synchronized String demangleImpl(String symbolName, String cpu) {
        CPPFilt cppfilt = this.getCppFilt(cpu);
        if (cppfilt != null && (symbolName.startsWith("_Z") || symbolName.startsWith("_G"))) {
            try {
                symbolName = cppfilt.getFunction(symbolName);
            }
            catch (IOException iOException) {}
        }
        return symbolName;
    }

    public synchronized String getLine(IBinaryParser.ISymbol symbol) {
        IBinaryParser.IBinaryObject binary = symbol.getBinaryObject();
        IAddress address = symbol.getAddress();
        return this.getLine(binary, address);
    }

    public synchronized String getLine(IBinaryParser.IBinaryObject program, IAddress address) {
        Addr2line addr2line = this.getAddr2line(program);
        if (addr2line == null) {
            return "??:0";
        }
        try {
            return addr2line.getLine(address);
        }
        catch (IOException iOException) {
            return "??:0";
        }
    }

    public synchronized String getLine(IBinaryParser.IBinaryObject program, String address) {
        IAddress addr = program.getAddressFactory().createAddress(address);
        return this.getLine(program, addr);
    }

    public synchronized String getLine(IBinaryParser.IBinaryObject program, long address) {
        IAddress addr = program.getAddressFactory().createAddress(Long.toString(address));
        return this.getLine(program, addr);
    }

    public synchronized int getLineNumber(IBinaryParser.IBinaryObject program, IAddress address) {
        Addr2line addr2line = this.getAddr2line(program);
        if (addr2line == null) {
            return -1;
        }
        try {
            return addr2line.getLineNumber(address);
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public synchronized int getLineNumber(IBinaryParser.IBinaryObject program, String address) {
        IAddress addr = program.getAddressFactory().createAddress(address);
        return this.getLineNumber(program, addr);
    }

    public synchronized int getLineNumber(IBinaryParser.IBinaryObject program, long address) {
        IAddress addr = program.getAddressFactory().createAddress(Long.toString(address));
        return this.getLineNumber(program, addr);
    }

    public int getLineNumber(IBinaryParser.ISymbol symbol) {
        IBinaryParser.IBinaryObject obj = symbol.getBinaryObject();
        IAddress address = symbol.getAddress();
        return this.getLineNumber(obj, address);
    }

    public synchronized String getFileName(IBinaryParser.IBinaryObject program, IAddress address) {
        Addr2line addr2line = this.getAddr2line(program);
        if (addr2line == null) {
            return null;
        }
        try {
            return addr2line.getFileName(address);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public synchronized String getFileName(IBinaryParser.IBinaryObject program, String address) {
        IAddress addr = program.getAddressFactory().createAddress(address);
        return this.getFileName(program, addr);
    }

    public synchronized String getFileName(IBinaryParser.IBinaryObject program, long address) {
        IAddress addr = program.getAddressFactory().createAddress(Long.toString(address));
        return this.getFileName(program, addr);
    }

    public String getFilename(IBinaryParser.ISymbol symbol) {
        IBinaryParser.IBinaryObject obj = symbol.getBinaryObject();
        IAddress address = symbol.getAddress();
        return this.getFileName(obj, address);
    }

    public synchronized String getFunctionName(IBinaryParser.IBinaryObject program, long address) {
        IAddress addr = program.getAddressFactory().createAddress(Long.toString(address));
        return this.getFunctionName(program, addr);
    }

    public synchronized String getFunctionName(IBinaryParser.IBinaryObject program, String address) {
        IAddress addr = program.getAddressFactory().createAddress(address);
        return this.getFunctionName(program, addr);
    }

    public synchronized String getFunctionName(IBinaryParser.IBinaryObject program, IAddress address) {
        Addr2line addr2line = this.getAddr2line(program);
        if (addr2line == null) {
            return null;
        }
        try {
            return addr2line.getFunction(address);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private synchronized CPPFilt getCppFilt(String cpu) {
        AutoDisposeCPPFilt adCppfilt = this.cppfilts.get(cpu);
        if (adCppfilt == null) {
            adCppfilt = new AutoDisposeCPPFilt();
            this.cppfilts.put(cpu, adCppfilt);
        }
        if (adCppfilt.cppfilt == null) {
            try {
                adCppfilt.cppfilt = STCPPFiltFactory.getCPPFilt(cpu);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        adCppfilt.startTime = System.currentTimeMillis();
        return adCppfilt.cppfilt;
    }

    private synchronized Addr2line getAddr2line(IBinaryParser.IBinaryObject program) {
        AutoDisposeAddr2line adAddr2line = this.addr2lines.get(program);
        if (adAddr2line == null) {
            adAddr2line = new AutoDisposeAddr2line();
            this.addr2lines.put(program, adAddr2line);
        }
        if (adAddr2line.addr2line == null) {
            try {
                adAddr2line.addr2line = STAddr2LineFactory.getAddr2line(program.getCPU(), program.getPath().toOSString());
            }
            catch (IOException iOException) {
                return null;
            }
        }
        adAddr2line.startTime = System.currentTimeMillis();
        return adAddr2line.addr2line;
    }

    public IBinaryParser.IBinaryObject getBinaryObject(String loc) {
        Path path = new Path(loc);
        return this.getBinaryObject((IPath)path);
    }

    public IBinaryParser.IBinaryObject getBinaryObject(IPath path) {
        return this.getBinaryObject(path, null);
    }

    public IBinaryParser.IBinaryObject getBinaryObject(IPath path, IBinaryParser defaultparser) {
        IFile c = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (c != null) {
            IBinaryParser.IBinaryObject object = this.getAlreadyExistingBinaryObject(c);
            if (this.isBinaryParserCompatible(object, defaultparser)) {
                return object;
            }
            if (defaultparser == null) {
                defaultparser = this.getBinaryParser(c.getProject());
            }
        }
        if (defaultparser == null) {
            try {
                defaultparser = CCorePlugin.getDefault().getDefaultBinaryParser();
            }
            catch (CoreException _) {
                Activator.getDefault().getLog().log(_.getStatus());
            }
        }
        return this.buildBinaryObject(path, defaultparser);
    }

    private boolean isBinaryParserCompatible(IBinaryParser.IBinaryObject o, IBinaryParser parser) {
        if (o == null) {
            return false;
        }
        if (parser == null) {
            return true;
        }
        IBinaryParser p = o.getBinaryParser();
        return p.getClass().equals(parser.getClass());
    }

    private IBinaryParser.IBinaryObject buildBinaryObject(IPath path, IBinaryParser parser) {
        if (parser == null) {
            return null;
        }
        IBinaryParser.IBinaryFile bf = null;
        try {
            bf = parser.getBinary(path);
        }
        catch (IOException iOException) {}
        if (bf instanceof IBinaryParser.IBinaryObject) {
            IBinaryParser.IBinaryObject object = (IBinaryParser.IBinaryObject)bf;
            String s = null;
            try {
                s = object.getCPU();
            }
            catch (Exception exception) {}
            if (s.length() > 0) {
                return object;
            }
        }
        return null;
    }

    private IBinaryParser.IBinaryObject getAlreadyExistingBinaryObject(IFile c) {
        ICProject cproject;
        IProject project = c.getProject();
        if (project != null && project.exists() && (cproject = CoreModel.getDefault().create(project)) != null) {
            try {
                IBinary[] b;
                IBinary[] iBinaryArray = b = cproject.getBinaryContainer().getBinaries();
                int n = b.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinary binary = iBinaryArray[n2];
                    if (binary.getResource().equals((Object)c) && binary instanceof IBinaryParser.IBinaryObject) {
                        return (IBinaryParser.IBinaryObject)binary;
                    }
                    ++n2;
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    private IBinaryParser getBinaryParser(IProject project) {
        try {
            ICExtensionReference[] parserRefs;
            ICExtensionReference[] iCExtensionReferenceArray = parserRefs = CCorePlugin.getDefault().getBinaryParserExtensions(project);
            int n = parserRefs.length;
            int n2 = 0;
            while (n2 < n) {
                ICExtensionReference parserRef = iCExtensionReferenceArray[n2];
                ICExtension extension = parserRef.createExtension();
                if (extension instanceof IBinaryParser) {
                    return (IBinaryParser)extension;
                }
                ++n2;
            }
        }
        catch (CoreException _) {
            Activator.getDefault().getLog().log(_.getStatus());
        }
        catch (Exception _) {
            Status s = new Status(4, "org.eclipse.linuxtools.binutils", _.getMessage(), (Throwable)_);
            Activator.getDefault().getLog().log((IStatus)s);
        }
        return null;
    }

    private final class AutoDisposeAddr2line {
        private Addr2line addr2line;
        private long startTime;

        private AutoDisposeAddr2line() {
        }
    }

    private final class AutoDisposeCPPFilt {
        private CPPFilt cppfilt;
        private long startTime;

        private AutoDisposeCPPFilt() {
        }
    }
}

