/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools;

import java.util.TreeSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;

public class AutotoolsDefaultBuildDirHandler
extends ManagedOptionValueHandler
implements IOptionApplicability {
    public static final String DEFAULT_BUILD_DIR = "build";
    public static final String CONFIGURE_TOOL_ID = "org.eclipse.linuxtools.cdt.autotools.gnu.toolchain.tool.configure";
    public static final String BUILD_DIR_OPTION_ID = "org.eclipse.linuxtools.cdt.autotools.option.configure.builddir";
    public static final String BUILD_DIR_APPLY = "BuildDir.apply";
    public static final String BUILD_DIR_DEFAULT_QUESTION = "BuildDir.default";
    public static final String BUILD_DIR_YES = "BuildDir.yes";
    public static final String BUILD_DIR_NO = "BuildDir.no";

    public boolean handleValue(IBuildObject buildObject, IHoldsOptions holder, IOption option, String extraArgument, int event) {
        String value;
        String valueBase = value = (String)option.getValue();
        if (buildObject instanceof IConfiguration && event == 1) {
            TreeSet<Integer> nums = new TreeSet<Integer>();
            IConfiguration configuration = (IConfiguration)buildObject;
            IConfiguration[] cfgs = configuration.getManagedProject().getConfigurations();
            int index = 1;
            boolean valueFound = false;
            int i = 0;
            while (i < cfgs.length) {
                ITool tool;
                IConfiguration config = cfgs[i];
                if (config != null && !config.getName().equals(configuration.getName()) && (tool = config.getToolFromOutputExtension("status")) != null) {
                    IOption buildDirOption = tool.getOptionBySuperClassId(BUILD_DIR_OPTION_ID);
                    String buildDir = (String)buildDirOption.getValue();
                    if (buildDir.equals(value)) {
                        valueFound = true;
                    }
                    if (buildDir.startsWith(DEFAULT_BUILD_DIR)) {
                        String numstr = buildDir.substring(DEFAULT_BUILD_DIR.length());
                        try {
                            Integer k = Integer.valueOf(numstr);
                            index = k + 1;
                            nums.add(k);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                ++i;
            }
            if (!valueFound) {
                return true;
            }
            if (value.startsWith(DEFAULT_BUILD_DIR)) {
                valueBase = DEFAULT_BUILD_DIR;
                while (nums.contains(index)) {
                    ++index;
                }
            }
            try {
                IOption optionToSet = holder.getOptionToSet(option, false);
                optionToSet.setValue(String.valueOf(valueBase) + index);
            }
            catch (BuildException buildException) {
                return false;
            }
        }
        return true;
    }

    public boolean isOptionEnabled(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return true;
    }

    public boolean isOptionUsedInCommandLine(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return false;
    }

    public boolean isOptionVisible(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return !option.getName().equals("includes") && !option.getName().equals("symbols");
    }
}

